#!/usr/bin/bash

pwprompt=" "

for arg in "$@"; do
	if [ `expr -- "$arg" : '--tmpdir='` -eq 9 ]; then
		tmpdir="`echo $arg | awk -F= '{print $2}'`"
	else
		echo "ignoring unknown argument: $arg" 1>&2
	fi
done

if [[ -f /etc/mysql/debian.cnf ]]; then
  MDB="/usr/bin/mysql --defaults-file=/etc/mysql/debian.cnf"
else
  MDB="/usr/bin/mysql"
fi

# DELETE libcalmysql.so entries first as they are in ha_columnstore.so in 1.4.2 onwards
$MDB 2> ${tmpdir}/mysql_install.log <<EOD
DELETE FROM mysql.func WHERE dl='libcalmysql.so';
CREATE OR REPLACE FUNCTION calgetstats RETURNS STRING SONAME 'ha_columnstore.so';
CREATE OR REPLACE FUNCTION calsettrace RETURNS INTEGER SONAME 'ha_columnstore.so';
CREATE OR REPLACE FUNCTION calsetparms RETURNS STRING SONAME 'ha_columnstore.so';
CREATE OR REPLACE FUNCTION calflushcache RETURNS INTEGER SONAME 'ha_columnstore.so';
CREATE OR REPLACE FUNCTION calgettrace RETURNS STRING SONAME 'ha_columnstore.so';
CREATE OR REPLACE FUNCTION calgetversion RETURNS STRING SONAME 'ha_columnstore.so';
CREATE OR REPLACE FUNCTION calonlinealter RETURNS INTEGER SONAME 'ha_columnstore.so';
CREATE OR REPLACE FUNCTION calviewtablelock RETURNS STRING SONAME 'ha_columnstore.so';
CREATE OR REPLACE FUNCTION calcleartablelock RETURNS STRING SONAME 'ha_columnstore.so';
CREATE OR REPLACE FUNCTION callastinsertid RETURNS INTEGER SONAME 'ha_columnstore.so';
CREATE OR REPLACE FUNCTION calgetsqlcount RETURNS STRING SONAME 'ha_columnstore.so';
CREATE OR REPLACE FUNCTION idbpm RETURNS INTEGER SONAME 'ha_columnstore.so';
CREATE OR REPLACE FUNCTION idbdbroot RETURNS INTEGER SONAME 'ha_columnstore.so';
CREATE OR REPLACE FUNCTION idbsegment RETURNS INTEGER SONAME 'ha_columnstore.so';
CREATE OR REPLACE FUNCTION idbsegmentdir RETURNS INTEGER SONAME 'ha_columnstore.so';
CREATE OR REPLACE FUNCTION idbextentrelativerid RETURNS INTEGER SONAME 'ha_columnstore.so';
CREATE OR REPLACE FUNCTION idbblockid RETURNS INTEGER SONAME 'ha_columnstore.so';
CREATE OR REPLACE FUNCTION idbextentid RETURNS INTEGER SONAME 'ha_columnstore.so';
CREATE OR REPLACE FUNCTION idbextentmin RETURNS STRING SONAME 'ha_columnstore.so';
CREATE OR REPLACE FUNCTION idbextentmax RETURNS STRING SONAME 'ha_columnstore.so';
CREATE OR REPLACE FUNCTION idbpartition RETURNS STRING SONAME 'ha_columnstore.so';
CREATE OR REPLACE FUNCTION idblocalpm RETURNS INTEGER SONAME 'ha_columnstore.so';
CREATE OR REPLACE FUNCTION mcssystemready RETURNS INTEGER SONAME 'ha_columnstore.so';
CREATE OR REPLACE FUNCTION mcssystemreadonly RETURNS INTEGER SONAME 'ha_columnstore.so';
CREATE OR REPLACE FUNCTION mcssystemprimary RETURNS INTEGER SONAME 'ha_columnstore.so';
CREATE OR REPLACE FUNCTION mcs_emindex_size RETURNS INTEGER SONAME 'ha_columnstore.so';
CREATE OR REPLACE FUNCTION mcs_emindex_free RETURNS INTEGER SONAME 'ha_columnstore.so';
CREATE OR REPLACE AGGREGATE FUNCTION regr_avgx RETURNS REAL SONAME 'libregr_mysql.so';
CREATE OR REPLACE AGGREGATE FUNCTION regr_avgy RETURNS REAL SONAME 'libregr_mysql.so';
CREATE OR REPLACE AGGREGATE FUNCTION regr_count RETURNS INTEGER SONAME 'libregr_mysql.so';
CREATE OR REPLACE AGGREGATE FUNCTION regr_slope RETURNS REAL SONAME 'libregr_mysql.so';
CREATE OR REPLACE AGGREGATE FUNCTION regr_intercept RETURNS REAL SONAME 'libregr_mysql.so';
CREATE OR REPLACE AGGREGATE FUNCTION regr_r2 RETURNS REAL SONAME 'libregr_mysql.so';
CREATE OR REPLACE AGGREGATE FUNCTION corr RETURNS REAL SONAME 'libregr_mysql.so';
CREATE OR REPLACE AGGREGATE FUNCTION regr_sxx RETURNS REAL SONAME 'libregr_mysql.so';
CREATE OR REPLACE AGGREGATE FUNCTION regr_syy RETURNS REAL SONAME 'libregr_mysql.so';
CREATE OR REPLACE AGGREGATE FUNCTION regr_sxy RETURNS REAL SONAME 'libregr_mysql.so';
CREATE OR REPLACE AGGREGATE FUNCTION covar_pop RETURNS REAL SONAME 'libregr_mysql.so';
CREATE OR REPLACE AGGREGATE FUNCTION covar_samp RETURNS REAL SONAME 'libregr_mysql.so';
CREATE OR REPLACE AGGREGATE FUNCTION distinct_count RETURNS INTEGER SONAME 'libudf_mysql.so';
CREATE OR REPLACE FUNCTION caldisablepartitions RETURNS STRING SONAME 'ha_columnstore.so';
CREATE OR REPLACE FUNCTION calenablepartitions RETURNS STRING SONAME 'ha_columnstore.so';
CREATE OR REPLACE FUNCTION caldroppartitions RETURNS STRING SONAME 'ha_columnstore.so';
CREATE OR REPLACE FUNCTION calshowpartitions RETURNS STRING SONAME 'ha_columnstore.so';
CREATE OR REPLACE FUNCTION caldroppartitionsbyvalue RETURNS STRING SONAME 'ha_columnstore.so';
CREATE OR REPLACE FUNCTION caldisablepartitionsbyvalue RETURNS STRING SONAME 'ha_columnstore.so';
CREATE OR REPLACE FUNCTION calenablepartitionsbyvalue RETURNS STRING SONAME 'ha_columnstore.so';
CREATE OR REPLACE FUNCTION calshowpartitionsbyvalue RETURNS STRING SONAME 'ha_columnstore.so';
CREATE OR REPLACE AGGREGATE FUNCTION moda RETURNS DECIMAL SONAME 'libregr_mysql.so';

CREATE DATABASE IF NOT EXISTS infinidb_querystats;
CREATE TABLE IF NOT EXISTS infinidb_querystats.querystats
(
  queryID bigint NOT NULL AUTO_INCREMENT,
  sessionID bigint DEFAULT NULL,
  host varchar(50),
  user varchar(50),
  priority char(20),
  queryType char(25),
  query varchar(8000),
  startTime timestamp NOT NULL,
  endTime timestamp NOT NULL,
  \`rows\` bigint,
  errno int,
  phyIO bigint,
  cacheIO bigint,
  blocksTouched bigint,
  CPBlocksSkipped bigint,
  msgInUM bigint,
  msgOutUm bigint,
  maxMemPct int,
  blocksChanged bigint,
  numTempFiles bigint,
  tempFileSpace bigint,
  PRIMARY KEY (queryID)
);

CREATE TABLE IF NOT EXISTS infinidb_querystats.user_priority
(
  host varchar(50),
  user varchar(50),
  priority char(20)
) DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

CREATE TABLE IF NOT EXISTS infinidb_querystats.priority
(
  priority char(20) primary key,
  priority_level int
) DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

insert ignore into infinidb_querystats.priority values ('High', 100),('Medium', 66), ('Low', 33);
EOD

$MDB </usr/share/columnstore/calsetuserpriority.sql 2>/dev/null
$MDB </usr/share/columnstore/calremoveuserpriority.sql 2>/dev/null
$MDB </usr/share/columnstore/calshowprocesslist.sql 2>/dev/null
$MDB </usr/share/columnstore/columnstore_info.sql 2>/dev/null
