#!/usr/bin/bash

# This script allows to gracefully start MCS

# prevent nodes using shared storage manager from stepping on each other when initializing
# flock will open up an exclusive file lock to run atomic operations
exec {fd_lock}>/var/lib/columnstore/storagemanager/storagemanager-lock
flock -n "$fd_lock" || exit 0

# pass in arg of 1 to start DBRM_Worker1
/bin/systemctl start mcs-workernode@1.service
/bin/systemctl start mcs-controllernode
/bin/systemctl start mcs-primproc
/bin/systemctl start mcs-writeengineserver
/bin/systemctl start mcs-exemgr
/bin/systemctl start mcs-dmlproc
/bin/systemctl start mcs-ddlproc
su -s /bin/sh -c '/usr/bin/dbbuilder 7' mysql 1> /var/log/mariadb/columnstore/install/dbbuilder.log

flock -u "$fd_lock"

exit 0
