/* A Bison parser, made by GNU Bison 3.7.4.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2020 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30704

/* Bison version string.  */
#define YYBISON_VERSION "3.7.4"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1


/* Substitute the variable and function names.  */
#define yyparse         ddlparse
#define yylex           ddllex
#define yyerror         ddlerror
#define yydebug         ddldebug
#define yynerrs         ddlnerrs

/* First part of user prologue.  */

#include "sqlparser.h"

#ifdef _MSC_VER
#include "ddl-gram-win.h"
#else
#include "ddl-gram.h"
#endif

#include "mariadb_my_sys.h" // CHARSET_INFO

#define scanner x->scanner

using namespace std;
using namespace ddlpackage;	

int ddllex(YYSTYPE* ddllval, void* yyscanner);
void ddlerror(struct pass_to_bison* x, char const *s);
char* copy_string(const char *str);

void fix_column_length(SchemaObject* elem, const CHARSET_INFO* def_cs) {
    auto* column = dynamic_cast<ColumnDef*>(elem);
    if (column == NULL || column->fType == NULL)
    {
        return;
    }

    if (column->fType->fType == DDL_VARCHAR ||
         column->fType->fType == DDL_CHAR ||
         (column->fType->fType == DDL_TEXT && column->fType->fExplicitLength))
    {
        unsigned mul = def_cs ? def_cs->mbmaxlen : 1;
        if (column->fType->fCharset) {
            const CHARSET_INFO* cs = get_charset_by_csname(column->fType->fCharset, MY_CS_PRIMARY, MYF(0));
            if (cs)
                mul = cs->mbmaxlen;
        }
        column->fType->fLength *= mul;
    }

    if (column->fType->fType == DDL_TEXT && column->fType->fExplicitLength)
    {
        // Rounding the resulting length of TEXT(N) field to the next default length
        if (column->fType->fLength <= 255)
            column->fType->fLength = 255;
        else if (column->fType->fLength <= 65535)
            column->fType->fLength = 65535;
        else 
            column->fType->fLength = 16777215;
    }
}



# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "ddl-gram.h"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_ACTION = 3,                     /* ACTION  */
  YYSYMBOL_ADD = 4,                        /* ADD  */
  YYSYMBOL_ALTER = 5,                      /* ALTER  */
  YYSYMBOL_AUTO_INCREMENT = 6,             /* AUTO_INCREMENT  */
  YYSYMBOL_BIGINT = 7,                     /* BIGINT  */
  YYSYMBOL_BIT = 8,                        /* BIT  */
  YYSYMBOL_BLOB = 9,                       /* BLOB  */
  YYSYMBOL_IDB_BLOB = 10,                  /* IDB_BLOB  */
  YYSYMBOL_CASCADE = 11,                   /* CASCADE  */
  YYSYMBOL_IDB_CHAR = 12,                  /* IDB_CHAR  */
  YYSYMBOL_CHARACTER = 13,                 /* CHARACTER  */
  YYSYMBOL_CHECK = 14,                     /* CHECK  */
  YYSYMBOL_CLOB = 15,                      /* CLOB  */
  YYSYMBOL_COLUMN = 16,                    /* COLUMN  */
  YYSYMBOL_BOOL = 17,                      /* BOOL  */
  YYSYMBOL_BOOLEAN = 18,                   /* BOOLEAN  */
  YYSYMBOL_COLUMNS = 19,                   /* COLUMNS  */
  YYSYMBOL_COMMENT = 20,                   /* COMMENT  */
  YYSYMBOL_CONSTRAINT = 21,                /* CONSTRAINT  */
  YYSYMBOL_CONSTRAINTS = 22,               /* CONSTRAINTS  */
  YYSYMBOL_CREATE = 23,                    /* CREATE  */
  YYSYMBOL_CURRENT_USER = 24,              /* CURRENT_USER  */
  YYSYMBOL_DATETIME = 25,                  /* DATETIME  */
  YYSYMBOL_DEC = 26,                       /* DEC  */
  YYSYMBOL_DECIMAL = 27,                   /* DECIMAL  */
  YYSYMBOL_DEFAULT = 28,                   /* DEFAULT  */
  YYSYMBOL_DEFERRABLE = 29,                /* DEFERRABLE  */
  YYSYMBOL_DEFERRED = 30,                  /* DEFERRED  */
  YYSYMBOL_IDB_DELETE = 31,                /* IDB_DELETE  */
  YYSYMBOL_DROP = 32,                      /* DROP  */
  YYSYMBOL_ENGINE = 33,                    /* ENGINE  */
  YYSYMBOL_FOREIGN = 34,                   /* FOREIGN  */
  YYSYMBOL_FULL = 35,                      /* FULL  */
  YYSYMBOL_IMMEDIATE = 36,                 /* IMMEDIATE  */
  YYSYMBOL_INDEX = 37,                     /* INDEX  */
  YYSYMBOL_INITIALLY = 38,                 /* INITIALLY  */
  YYSYMBOL_IDB_INT = 39,                   /* IDB_INT  */
  YYSYMBOL_INTEGER = 40,                   /* INTEGER  */
  YYSYMBOL_KEY = 41,                       /* KEY  */
  YYSYMBOL_LONGBLOB = 42,                  /* LONGBLOB  */
  YYSYMBOL_LONGTEXT = 43,                  /* LONGTEXT  */
  YYSYMBOL_MATCH = 44,                     /* MATCH  */
  YYSYMBOL_MAX_ROWS = 45,                  /* MAX_ROWS  */
  YYSYMBOL_MEDIUMBLOB = 46,                /* MEDIUMBLOB  */
  YYSYMBOL_MEDIUMTEXT = 47,                /* MEDIUMTEXT  */
  YYSYMBOL_MEDIUMINT = 48,                 /* MEDIUMINT  */
  YYSYMBOL_MIN_ROWS = 49,                  /* MIN_ROWS  */
  YYSYMBOL_MODIFY = 50,                    /* MODIFY  */
  YYSYMBOL_NO = 51,                        /* NO  */
  YYSYMBOL_NOT = 52,                       /* NOT  */
  YYSYMBOL_NULL_TOK = 53,                  /* NULL_TOK  */
  YYSYMBOL_NUMBER = 54,                    /* NUMBER  */
  YYSYMBOL_NUMERIC = 55,                   /* NUMERIC  */
  YYSYMBOL_ON = 56,                        /* ON  */
  YYSYMBOL_PARTIAL = 57,                   /* PARTIAL  */
  YYSYMBOL_PRECISION = 58,                 /* PRECISION  */
  YYSYMBOL_PRIMARY = 59,                   /* PRIMARY  */
  YYSYMBOL_REFERENCES = 60,                /* REFERENCES  */
  YYSYMBOL_RENAME = 61,                    /* RENAME  */
  YYSYMBOL_RESTRICT = 62,                  /* RESTRICT  */
  YYSYMBOL_SET = 63,                       /* SET  */
  YYSYMBOL_SMALLINT = 64,                  /* SMALLINT  */
  YYSYMBOL_TABLE = 65,                     /* TABLE  */
  YYSYMBOL_TEXT = 66,                      /* TEXT  */
  YYSYMBOL_TINYBLOB = 67,                  /* TINYBLOB  */
  YYSYMBOL_TINYTEXT = 68,                  /* TINYTEXT  */
  YYSYMBOL_TINYINT = 69,                   /* TINYINT  */
  YYSYMBOL_TO = 70,                        /* TO  */
  YYSYMBOL_UNIQUE = 71,                    /* UNIQUE  */
  YYSYMBOL_UNSIGNED = 72,                  /* UNSIGNED  */
  YYSYMBOL_UPDATE = 73,                    /* UPDATE  */
  YYSYMBOL_USER = 74,                      /* USER  */
  YYSYMBOL_SESSION_USER = 75,              /* SESSION_USER  */
  YYSYMBOL_SIGNED = 76,                    /* SIGNED  */
  YYSYMBOL_SYSTEM_USER = 77,               /* SYSTEM_USER  */
  YYSYMBOL_VARCHAR = 78,                   /* VARCHAR  */
  YYSYMBOL_VARBINARY = 79,                 /* VARBINARY  */
  YYSYMBOL_VARYING = 80,                   /* VARYING  */
  YYSYMBOL_WITH = 81,                      /* WITH  */
  YYSYMBOL_ZONE = 82,                      /* ZONE  */
  YYSYMBOL_DOUBLE = 83,                    /* DOUBLE  */
  YYSYMBOL_IDB_FLOAT = 84,                 /* IDB_FLOAT  */
  YYSYMBOL_REAL = 85,                      /* REAL  */
  YYSYMBOL_CHARSET = 86,                   /* CHARSET  */
  YYSYMBOL_COLLATE = 87,                   /* COLLATE  */
  YYSYMBOL_IDB_IF = 88,                    /* IDB_IF  */
  YYSYMBOL_EXISTS = 89,                    /* EXISTS  */
  YYSYMBOL_CHANGE = 90,                    /* CHANGE  */
  YYSYMBOL_TRUNCATE = 91,                  /* TRUNCATE  */
  YYSYMBOL_TIMESTAMP = 92,                 /* TIMESTAMP  */
  YYSYMBOL_ZEROFILL = 93,                  /* ZEROFILL  */
  YYSYMBOL_DQ_IDENT = 94,                  /* DQ_IDENT  */
  YYSYMBOL_IDENT = 95,                     /* IDENT  */
  YYSYMBOL_FCONST = 96,                    /* FCONST  */
  YYSYMBOL_SCONST = 97,                    /* SCONST  */
  YYSYMBOL_CP_SEARCH_CONDITION_TEXT = 98,  /* CP_SEARCH_CONDITION_TEXT  */
  YYSYMBOL_ICONST = 99,                    /* ICONST  */
  YYSYMBOL_DATE = 100,                     /* DATE  */
  YYSYMBOL_TIME = 101,                     /* TIME  */
  YYSYMBOL_102_ = 102,                     /* ';'  */
  YYSYMBOL_103_ = 103,                     /* '('  */
  YYSYMBOL_104_ = 104,                     /* ')'  */
  YYSYMBOL_105_ = 105,                     /* ','  */
  YYSYMBOL_106_ = 106,                     /* '='  */
  YYSYMBOL_107_ = 107,                     /* '.'  */
  YYSYMBOL_108_ = 108,                     /* '\''  */
  YYSYMBOL_YYACCEPT = 109,                 /* $accept  */
  YYSYMBOL_stmtblock = 110,                /* stmtblock  */
  YYSYMBOL_stmtmulti = 111,                /* stmtmulti  */
  YYSYMBOL_stmt = 112,                     /* stmt  */
  YYSYMBOL_drop_table_statement = 113,     /* drop_table_statement  */
  YYSYMBOL_opt_if_exists = 114,            /* opt_if_exists  */
  YYSYMBOL_drop_index_statement = 115,     /* drop_index_statement  */
  YYSYMBOL_create_index_statement = 116,   /* create_index_statement  */
  YYSYMBOL_opt_table_options = 117,        /* opt_table_options  */
  YYSYMBOL_create_table_statement = 118,   /* create_table_statement  */
  YYSYMBOL_opt_if_not_exists = 119,        /* opt_if_not_exists  */
  YYSYMBOL_trunc_table_statement = 120,    /* trunc_table_statement  */
  YYSYMBOL_rename_table_statement = 121,   /* rename_table_statement  */
  YYSYMBOL_table_element_list = 122,       /* table_element_list  */
  YYSYMBOL_table_element = 123,            /* table_element  */
  YYSYMBOL_table_constraint_def = 124,     /* table_constraint_def  */
  YYSYMBOL_opt_constraint_name = 125,      /* opt_constraint_name  */
  YYSYMBOL_table_constraint = 126,         /* table_constraint  */
  YYSYMBOL_unique_constraint_def = 127,    /* unique_constraint_def  */
  YYSYMBOL_column_name_list = 128,         /* column_name_list  */
  YYSYMBOL_unique_specifier = 129,         /* unique_specifier  */
  YYSYMBOL_referential_constraint_def = 130, /* referential_constraint_def  */
  YYSYMBOL_opt_match_type = 131,           /* opt_match_type  */
  YYSYMBOL_match_type = 132,               /* match_type  */
  YYSYMBOL_opt_referential_triggered_action = 133, /* opt_referential_triggered_action  */
  YYSYMBOL_referential_triggered_action = 134, /* referential_triggered_action  */
  YYSYMBOL_opt_delete_rule = 135,          /* opt_delete_rule  */
  YYSYMBOL_opt_update_rule = 136,          /* opt_update_rule  */
  YYSYMBOL_update_rule = 137,              /* update_rule  */
  YYSYMBOL_delete_rule = 138,              /* delete_rule  */
  YYSYMBOL_referential_action = 139,       /* referential_action  */
  YYSYMBOL_table_options = 140,            /* table_options  */
  YYSYMBOL_opt_equal = 141,                /* opt_equal  */
  YYSYMBOL_table_option = 142,             /* table_option  */
  YYSYMBOL_alter_table_statement = 143,    /* alter_table_statement  */
  YYSYMBOL_alter_table_actions = 144,      /* alter_table_actions  */
  YYSYMBOL_alter_table_action = 145,       /* alter_table_action  */
  YYSYMBOL_alter_table_comment = 146,      /* alter_table_comment  */
  YYSYMBOL_modify_column = 147,            /* modify_column  */
  YYSYMBOL_rename_column = 148,            /* rename_column  */
  YYSYMBOL_drop_table_constraint_def = 149, /* drop_table_constraint_def  */
  YYSYMBOL_add_table_constraint_def = 150, /* add_table_constraint_def  */
  YYSYMBOL_ata_rename_table = 151,         /* ata_rename_table  */
  YYSYMBOL_table_name = 152,               /* table_name  */
  YYSYMBOL_qualified_name = 153,           /* qualified_name  */
  YYSYMBOL_ident = 154,                    /* ident  */
  YYSYMBOL_ata_add_column = 155,           /* ata_add_column  */
  YYSYMBOL_column_name = 156,              /* column_name  */
  YYSYMBOL_constraint_name = 157,          /* constraint_name  */
  YYSYMBOL_column_option = 158,            /* column_option  */
  YYSYMBOL_column_def = 159,               /* column_def  */
  YYSYMBOL_opt_null_tok = 160,             /* opt_null_tok  */
  YYSYMBOL_default_clause = 161,           /* default_clause  */
  YYSYMBOL_optional_braces = 162,          /* optional_braces  */
  YYSYMBOL_opt_column_charset = 163,       /* opt_column_charset  */
  YYSYMBOL_opt_column_collate = 164,       /* opt_column_collate  */
  YYSYMBOL_data_type = 165,                /* data_type  */
  YYSYMBOL_column_qualifier_list = 166,    /* column_qualifier_list  */
  YYSYMBOL_column_constraint_def = 167,    /* column_constraint_def  */
  YYSYMBOL_opt_constraint_attributes = 168, /* opt_constraint_attributes  */
  YYSYMBOL_constraint_attributes = 169,    /* constraint_attributes  */
  YYSYMBOL_opt_deferrability_clause = 170, /* opt_deferrability_clause  */
  YYSYMBOL_deferrability_clause = 171,     /* deferrability_clause  */
  YYSYMBOL_constraint_check_time = 172,    /* constraint_check_time  */
  YYSYMBOL_column_constraint = 173,        /* column_constraint  */
  YYSYMBOL_check_constraint_def = 174,     /* check_constraint_def  */
  YYSYMBOL_string_literal = 175,           /* string_literal  */
  YYSYMBOL_opt_quoted_literal = 176,       /* opt_quoted_literal  */
  YYSYMBOL_character_string_type = 177,    /* character_string_type  */
  YYSYMBOL_binary_string_type = 178,       /* binary_string_type  */
  YYSYMBOL_blob_type = 179,                /* blob_type  */
  YYSYMBOL_text_type = 180,                /* text_type  */
  YYSYMBOL_numeric_type = 181,             /* numeric_type  */
  YYSYMBOL_exact_numeric_type = 182,       /* exact_numeric_type  */
  YYSYMBOL_opt_precision_scale = 183,      /* opt_precision_scale  */
  YYSYMBOL_opt_signed = 184,               /* opt_signed  */
  YYSYMBOL_opt_zerofill = 185,             /* opt_zerofill  */
  YYSYMBOL_opt_display_width = 186,        /* opt_display_width  */
  YYSYMBOL_approximate_numeric_type = 187, /* approximate_numeric_type  */
  YYSYMBOL_opt_display_precision_scale_null = 188, /* opt_display_precision_scale_null  */
  YYSYMBOL_literal = 189,                  /* literal  */
  YYSYMBOL_datetime_type = 190,            /* datetime_type  */
  YYSYMBOL_opt_time_precision = 191,       /* opt_time_precision  */
  YYSYMBOL_drop_column_def = 192,          /* drop_column_def  */
  YYSYMBOL_drop_behavior = 193,            /* drop_behavior  */
  YYSYMBOL_alter_column_def = 194,         /* alter_column_def  */
  YYSYMBOL_opt_column = 195                /* opt_column  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;


/* Second part of user prologue.  */





#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && ! defined __ICC && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                            \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  28
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   488

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  109
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  87
/* YYNRULES -- Number of rules.  */
#define YYNRULES  270
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  460

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   356


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,   108,
     103,   104,     2,     2,   105,     2,   107,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,   102,
       2,   106,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   244,   244,   249,   259,   274,   275,   276,   277,   278,
     279,   280,   281,   285,   286,   293,   294,   298,   304,   309,
     317,   318,   322,   333,   334,   338,   339,   343,   353,   359,
     367,   368,   372,   378,   386,   387,   391,   392,   393,   397,
     407,   412,   420,   421,   425,   432,   433,   437,   441,   442,
     446,   447,   451,   457,   466,   467,   471,   472,   476,   480,
     484,   485,   486,   487,   488,   492,   498,   507,   507,   511,
     513,   515,   517,   519,   521,   526,   528,   530,   532,   534,
     538,   545,   557,   562,   570,   571,   572,   573,   574,   575,
     576,   577,   578,   582,   585,   592,   595,   601,   603,   605,
     607,   609,   611,   613,   615,   617,   619,   621,   623,   625,
     627,   629,   631,   633,   635,   637,   639,   644,   651,   655,
     656,   660,   664,   670,   677,   678,   685,   686,   687,   693,
     702,   703,   704,   708,   712,   715,   719,   723,   727,   731,
     735,   739,   743,   747,   751,   757,   760,   764,   768,   772,
     773,   774,   775,   776,   780,   781,   785,   787,   791,   793,
     797,   801,   802,   803,   804,   805,   809,   814,   823,   828,
     836,   847,   862,   863,   867,   872,   886,   887,   891,   902,
     903,   907,   908,   909,   910,   911,   915,   919,   923,   925,
     929,   934,   939,   944,   949,   955,   961,   969,   977,   982,
     987,   992,   997,  1005,  1011,  1016,  1021,  1026,  1034,  1035,
    1039,  1045,  1051,  1056,  1061,  1067,  1073,  1078,  1083,  1088,
    1093,  1098,  1103,  1108,  1113,  1118,  1123,  1129,  1135,  1140,
    1148,  1149,  1150,  1154,  1155,  1158,  1159,  1162,  1163,  1167,
    1172,  1177,  1182,  1187,  1192,  1197,  1202,  1210,  1212,  1213,
    1217,  1218,  1219,  1223,  1230,  1236,  1243,  1251,  1252,  1256,
    1257,  1258,  1259,  1260,  1264,  1265,  1266,  1270,  1271,  1275,
    1276
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if YYDEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "ACTION", "ADD",
  "ALTER", "AUTO_INCREMENT", "BIGINT", "BIT", "BLOB", "IDB_BLOB",
  "CASCADE", "IDB_CHAR", "CHARACTER", "CHECK", "CLOB", "COLUMN", "BOOL",
  "BOOLEAN", "COLUMNS", "COMMENT", "CONSTRAINT", "CONSTRAINTS", "CREATE",
  "CURRENT_USER", "DATETIME", "DEC", "DECIMAL", "DEFAULT", "DEFERRABLE",
  "DEFERRED", "IDB_DELETE", "DROP", "ENGINE", "FOREIGN", "FULL",
  "IMMEDIATE", "INDEX", "INITIALLY", "IDB_INT", "INTEGER", "KEY",
  "LONGBLOB", "LONGTEXT", "MATCH", "MAX_ROWS", "MEDIUMBLOB", "MEDIUMTEXT",
  "MEDIUMINT", "MIN_ROWS", "MODIFY", "NO", "NOT", "NULL_TOK", "NUMBER",
  "NUMERIC", "ON", "PARTIAL", "PRECISION", "PRIMARY", "REFERENCES",
  "RENAME", "RESTRICT", "SET", "SMALLINT", "TABLE", "TEXT", "TINYBLOB",
  "TINYTEXT", "TINYINT", "TO", "UNIQUE", "UNSIGNED", "UPDATE", "USER",
  "SESSION_USER", "SIGNED", "SYSTEM_USER", "VARCHAR", "VARBINARY",
  "VARYING", "WITH", "ZONE", "DOUBLE", "IDB_FLOAT", "REAL", "CHARSET",
  "COLLATE", "IDB_IF", "EXISTS", "CHANGE", "TRUNCATE", "TIMESTAMP",
  "ZEROFILL", "DQ_IDENT", "IDENT", "FCONST", "SCONST",
  "CP_SEARCH_CONDITION_TEXT", "ICONST", "DATE", "TIME", "';'", "'('",
  "')'", "','", "'='", "'.'", "'\\''", "$accept", "stmtblock", "stmtmulti",
  "stmt", "drop_table_statement", "opt_if_exists", "drop_index_statement",
  "create_index_statement", "opt_table_options", "create_table_statement",
  "opt_if_not_exists", "trunc_table_statement", "rename_table_statement",
  "table_element_list", "table_element", "table_constraint_def",
  "opt_constraint_name", "table_constraint", "unique_constraint_def",
  "column_name_list", "unique_specifier", "referential_constraint_def",
  "opt_match_type", "match_type", "opt_referential_triggered_action",
  "referential_triggered_action", "opt_delete_rule", "opt_update_rule",
  "update_rule", "delete_rule", "referential_action", "table_options",
  "opt_equal", "table_option", "alter_table_statement",
  "alter_table_actions", "alter_table_action", "alter_table_comment",
  "modify_column", "rename_column", "drop_table_constraint_def",
  "add_table_constraint_def", "ata_rename_table", "table_name",
  "qualified_name", "ident", "ata_add_column", "column_name",
  "constraint_name", "column_option", "column_def", "opt_null_tok",
  "default_clause", "optional_braces", "opt_column_charset",
  "opt_column_collate", "data_type", "column_qualifier_list",
  "column_constraint_def", "opt_constraint_attributes",
  "constraint_attributes", "opt_deferrability_clause",
  "deferrability_clause", "constraint_check_time", "column_constraint",
  "check_constraint_def", "string_literal", "opt_quoted_literal",
  "character_string_type", "binary_string_type", "blob_type", "text_type",
  "numeric_type", "exact_numeric_type", "opt_precision_scale",
  "opt_signed", "opt_zerofill", "opt_display_width",
  "approximate_numeric_type", "opt_display_precision_scale_null",
  "literal", "datetime_type", "opt_time_precision", "drop_column_def",
  "drop_behavior", "alter_column_def", "opt_column", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_int16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,    59,    40,    41,    44,    61,    46,    39
};
#endif

#define YYPACT_NINF (-296)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-134)

#define yytable_value_is_error(Yyn) \
  0

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
       9,   -49,   121,    16,   -37,   154,    63,     0,  -296,  -296,
    -296,  -296,  -296,  -296,  -296,  -296,   131,   131,    49,   128,
     131,   130,   131,   131,  -296,  -296,  -296,    74,  -296,     9,
     200,  -296,   141,   149,   131,   131,  -296,   144,   131,   172,
    -296,   131,  -296,   112,   257,   103,    95,    55,    12,    93,
      73,  -296,  -296,  -296,  -296,  -296,  -296,  -296,  -296,  -296,
    -296,   131,   189,   181,   232,  -296,   265,   131,  -296,   248,
     131,  -296,  -296,   140,  -296,   165,   188,   262,  -296,  -296,
    -296,   157,  -296,   196,   203,  -296,   270,   193,   131,   157,
    -296,    -4,   157,   262,   131,  -296,   157,   157,   200,  -296,
     210,  -296,   140,   131,   281,  -296,   140,  -296,   165,  -296,
     125,  -296,  -296,  -296,   215,   286,   296,  -296,   113,  -296,
     236,  -296,  -296,   247,   253,  -296,   -53,    19,  -296,  -296,
    -296,   269,   274,   247,   247,  -296,  -296,  -296,  -296,   247,
     274,   274,   247,   284,  -296,  -296,   247,   285,   288,   -36,
     289,   289,   269,  -296,   269,   321,   381,  -296,  -296,   381,
    -296,  -296,  -296,  -296,    -9,   287,  -296,   157,    -4,   157,
      -4,   158,  -296,  -296,  -296,  -296,   262,  -296,  -296,   157,
     262,  -296,   157,   162,   291,  -296,   177,   113,  -296,   140,
     298,   295,  -296,   362,   109,  -296,  -296,   372,   157,   303,
     331,   308,   305,   311,   310,   312,   315,  -296,   316,   -27,
     344,   345,   348,   349,   350,   351,   325,   353,   327,   328,
     289,   329,   357,   358,   359,  -296,  -296,  -296,   338,   369,
     346,   346,   406,   407,  -296,   187,  -296,   195,  -296,  -296,
     157,  -296,   262,   338,   216,   211,   157,  -296,  -296,  -296,
     332,   157,  -296,  -296,  -296,  -296,  -296,  -296,   218,   333,
    -296,   334,   340,   336,   342,   339,   341,   220,   354,  -296,
    -296,  -296,  -296,  -296,  -296,  -296,  -296,   352,  -296,   355,
     356,   370,   228,  -296,  -296,  -296,  -296,   203,   131,   261,
     391,   405,  -296,  -296,   347,   338,  -296,   113,  -296,   160,
     160,  -296,  -296,  -296,  -296,  -296,  -296,  -296,   338,  -296,
     347,   338,   211,   343,   103,    32,   343,   343,   343,   343,
     343,  -296,   211,  -296,   271,  -296,   275,  -296,  -296,  -296,
     360,  -296,   361,  -296,  -296,  -296,   363,  -296,  -296,  -296,
    -296,  -296,  -296,  -296,   364,  -296,   194,   365,  -296,  -296,
    -296,  -296,  -296,  -296,  -296,  -296,  -296,  -296,  -296,  -296,
     347,  -296,   428,  -296,  -296,  -296,  -296,  -296,  -296,  -296,
     347,   338,  -296,   347,  -296,   428,  -296,   367,   203,  -296,
     387,   343,   343,   131,   368,   371,   131,   160,  -296,   211,
     392,  -296,  -296,   373,   374,   113,   375,  -296,  -296,  -296,
    -296,   347,  -296,   428,  -296,  -296,  -296,  -296,   343,   131,
     160,  -296,  -296,  -296,  -296,  -296,  -296,   131,  -296,  -296,
    -296,  -296,  -296,  -296,   131,  -296,  -296,   366,  -296,   157,
     279,    86,  -296,    86,  -296,   395,  -296,  -296,    79,  -296,
    -296,   397,   398,   120,   120,   424,  -296,  -296,   384,  -296,
    -296,  -296,   455,  -296,   104,  -296,  -296,  -296,  -296,  -296
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_int16 yydefact[] =
{
      12,     0,     0,     0,     0,     0,     0,     2,     4,     8,
       7,     9,     6,    10,    11,     5,     0,     0,    24,     0,
       0,    16,     0,     0,   124,   125,    26,   122,     1,    12,
       0,   121,     0,     0,     0,     0,    17,     0,     0,     0,
      25,     0,     3,    35,   270,     0,     0,     0,     0,     0,
      80,    81,    92,    90,    91,    88,    87,    89,    84,    85,
      86,     0,     0,     0,     0,    15,    13,     0,   123,     0,
      35,   131,   130,    35,   118,     0,   132,     0,    34,   126,
     269,     0,    68,     0,     0,    94,     0,     0,     0,     0,
     132,   266,     0,     0,     0,   119,     0,     0,     0,    83,
       0,    23,    35,     0,     0,    27,    35,   127,     0,   133,
       0,    28,    31,    30,     0,     0,     0,    43,   173,    36,
       0,    37,    38,   238,   199,   166,   191,   190,   167,   227,
     226,   258,   232,   238,   238,   202,   207,   201,   206,   238,
     232,   232,   238,   204,   200,   205,   238,     0,     0,   249,
     249,   249,   258,   254,   258,   145,   156,   161,   164,   156,
     162,   208,   209,   163,     0,     0,    93,     0,   266,     0,
     266,     0,    40,   264,   265,   259,     0,    95,   120,     0,
       0,    82,     0,     0,     0,    14,     0,   173,   128,    35,
       0,     0,    42,     0,     0,    33,   172,   177,     0,     0,
     220,     0,     0,     0,     0,     0,     0,   253,     0,   234,
     217,   216,   228,   214,   210,   218,     0,   219,     0,     0,
     249,     0,   239,   245,   243,   256,   255,   146,   135,     0,
     158,   158,     0,     0,   187,     0,   260,     0,   117,   262,
       0,    96,     0,    97,     0,    21,     0,   129,    32,    29,
       0,     0,   175,   179,   180,   178,   174,   176,     0,     0,
     225,     0,     0,     0,     0,     0,     0,     0,   236,   233,
     212,   222,   221,   229,   215,   211,   223,     0,   224,     0,
       0,   241,     0,   240,   246,   244,   184,     0,     0,     0,
       0,     0,   182,   139,   138,   136,   168,   173,   185,     0,
       0,   160,   165,   268,   267,   261,   263,    41,    99,    98,
     105,   101,    21,    67,     0,     0,    67,    67,    67,    67,
      67,    22,    20,    65,     0,   186,     0,    39,   237,   198,
       0,   193,     0,   192,   257,   230,     0,   235,   213,   203,
     196,   197,   242,   247,     0,   134,     0,   154,   149,   150,
     152,   153,   148,   252,   250,   251,   147,   181,   183,   144,
     137,   140,   142,   169,   170,   189,   188,   157,   159,   100,
     106,   102,   107,   111,   103,   109,    18,     0,     0,    73,
       0,    67,    67,     0,     0,     0,     0,     0,    66,    21,
       0,   195,   194,     0,     0,   173,     0,   151,   141,   143,
     108,   112,   104,   110,   115,   113,    74,    72,    67,     0,
       0,    69,    70,    71,    76,    79,    19,     0,   231,   248,
     171,   155,   116,   114,     0,    75,    78,     0,    77,     0,
       0,    46,    48,     0,    49,    51,    45,    47,     0,    44,
      50,    55,    57,     0,     0,     0,    52,    54,     0,    53,
      56,    60,     0,    64,     0,    59,    58,    63,    62,    61
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -296,  -296,  -296,   432,  -296,  -296,  -296,  -296,  -293,  -296,
    -296,  -296,  -296,    58,   282,   429,   403,   376,  -296,  -143,
    -296,  -296,  -296,    41,  -296,  -296,  -296,  -296,    33,    35,
      36,  -296,  -144,   159,  -296,  -296,    -3,  -296,  -296,  -296,
    -296,  -296,  -296,   -28,   124,    -5,  -296,   -12,   -85,  -235,
     -18,  -296,  -191,  -296,   323,   252,   -89,  -222,  -247,  -185,
    -296,  -296,  -296,   292,   142,   -62,   -44,  -295,  -296,  -296,
    -296,  -296,  -296,  -296,   245,  -296,  -296,   173,  -296,  -141,
    -296,  -296,    62,  -296,    53,  -296,  -296
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,     6,     7,     8,     9,    38,    10,    11,   321,    12,
      34,    13,    14,   110,   111,   112,    75,   118,   119,   171,
     120,   121,   435,   436,   439,   440,   446,   449,   441,   442,
     455,   322,    84,   323,    15,    50,    51,    52,    53,    54,
      55,    56,    57,    30,    31,    90,    58,   172,    78,   293,
     113,   228,   294,   397,   230,   301,   155,   295,   296,   195,
     196,   256,   257,   197,   297,   298,   366,   367,   156,   157,
     158,   159,   160,   161,   209,   270,   338,   200,   162,   222,
     356,   163,   207,    59,   175,    60,    81
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      27,    85,   248,   170,   177,   368,    63,   173,   309,   223,
     224,    27,    27,   122,     1,    27,    16,    27,    27,   376,
      95,   311,   220,   232,   235,    79,   237,   202,    22,    27,
      27,    77,     2,    27,    91,    93,    68,    97,    76,   244,
     166,     3,   304,    27,   380,   268,   122,    99,   363,   269,
     203,   107,   310,    20,   233,   258,    27,    77,   174,   359,
     361,    77,    27,    28,   363,   109,   178,   221,    76,   164,
       4,    92,   360,   369,   168,   372,   374,    43,    44,   281,
     176,    21,    94,   109,   179,   180,   371,   241,   373,    27,
      77,   243,   415,    45,    77,   181,   416,    76,    27,   204,
       5,    76,    29,   324,   362,    46,    24,    25,   326,    96,
     443,    86,   364,   363,    87,   426,    88,   370,   381,   382,
     375,   432,   205,    47,   363,   398,   363,   399,    69,    26,
     433,   451,   458,    70,    48,   400,   402,    33,   404,   253,
     405,    32,   193,   434,    36,   254,    39,    40,   401,    24,
      25,   194,   444,   308,   363,    71,    72,   459,    17,    64,
     183,    70,    66,    49,   186,    35,   422,   242,   423,   377,
     378,   452,   383,   384,   385,   386,   387,    77,    98,   114,
     403,    41,   453,   454,    76,   100,    18,    24,    25,    24,
      25,   105,    19,    71,    72,    71,    72,    61,    89,   115,
     286,    62,  -133,   346,    43,    44,    24,    25,   114,    82,
     420,    83,    71,    72,   225,    73,   226,   313,    37,    23,
      45,   236,  -133,   238,   116,    24,    25,   184,   307,   188,
     189,   314,    46,    65,    24,    25,   117,   409,   410,   315,
      71,    72,    67,   345,   316,   355,   290,  -133,    24,    25,
      47,    24,    25,   291,    24,    25,   317,    71,    72,  -133,
     318,    48,   239,   240,   424,   292,   245,   189,    83,   123,
     379,   124,   125,    80,   126,   127,   104,   128,   101,   129,
     130,   247,   189,   109,   102,   347,   430,   131,   103,   132,
      49,   305,   240,   165,   365,   365,   169,   319,   320,   306,
     240,   133,   134,   185,   135,   136,   210,   211,   137,   138,
     139,    83,   212,   182,   348,   215,   140,   141,   190,   217,
     312,   240,   327,   240,   335,   336,   142,   191,   143,   144,
     145,   146,   343,   344,   407,   349,   350,   192,   351,   198,
     147,   148,    24,    25,   286,   149,   150,   151,    71,    72,
     199,   106,   114,   286,   152,   352,   201,   353,   287,   288,
     354,   114,   153,   154,    24,    25,   289,   287,   288,    83,
      71,    72,   206,   167,   227,   389,   240,   208,   411,   390,
     240,   414,   365,   431,   240,   213,   214,   216,   218,   427,
     290,   219,   221,   229,   246,   234,   250,   291,   251,   290,
     194,   255,   259,   260,   425,   365,   291,   261,   262,   292,
     263,   265,    27,   264,   266,   267,   271,   272,   292,   428,
     273,   274,   275,   276,   277,   278,   279,   280,   282,   283,
     284,   285,   299,   300,   303,   289,   325,   328,   329,   330,
     331,   332,   342,   333,   357,   334,   358,   337,   287,    82,
     408,   438,   417,   445,   448,   443,   339,   444,   457,   340,
     341,    42,   393,   394,   391,   392,   406,   412,   396,   429,
     413,   249,    74,   108,   437,   450,   447,   418,   419,   421,
     456,   388,   231,   302,   187,   252,     0,     0,   395
};

static const yytype_int16 yycheck[] =
{
       5,    45,   187,    88,    93,   300,    34,    11,   243,   150,
     151,    16,    17,    75,     5,    20,    65,    22,    23,   312,
      48,   243,    58,    32,   167,    43,   169,    80,    65,    34,
      35,    43,    23,    38,    46,    47,    41,    49,    43,   182,
      84,    32,   233,    48,    12,    72,   108,    50,   295,    76,
     103,    69,   243,    37,    63,   198,    61,    69,    62,   294,
     295,    73,    67,     0,   311,    70,    94,   103,    73,    81,
      61,    16,   294,   308,    86,   310,   311,     4,     5,   220,
      92,    65,    70,    88,    96,    97,   308,   176,   310,    94,
     102,   180,   387,    20,   106,    98,   389,   102,   103,    80,
      91,   106,   102,   246,   295,    32,    94,    95,   251,    16,
      31,    16,   297,   360,    19,   410,    21,   308,    86,    87,
     311,    35,   103,    50,   371,   360,   373,   362,    16,     5,
      44,    11,    28,    21,    61,   370,   371,    88,   373,    30,
     375,    17,    29,    57,    20,    36,    22,    23,   370,    94,
      95,    38,    73,   242,   401,   100,   101,    53,    37,    35,
     102,    21,    38,    90,   106,    37,   401,   179,   403,   313,
     314,    51,   316,   317,   318,   319,   320,   189,   105,    14,
     371,   107,    62,    63,   189,    61,    65,    94,    95,    94,
      95,    67,    71,   100,   101,   100,   101,    56,   103,    34,
       6,    52,    14,   288,     4,     5,    94,    95,    14,   106,
     395,   108,   100,   101,   152,   103,   154,     6,    88,    65,
      20,   168,    34,   170,    59,    94,    95,   103,   240,   104,
     105,    20,    32,    89,    94,    95,    71,   381,   382,    28,
     100,   101,    70,   287,    33,   289,    52,    59,    94,    95,
      50,    94,    95,    59,    94,    95,    45,   100,   101,    71,
      49,    61,   104,   105,   408,    71,   104,   105,   108,     7,
     314,     9,    10,    16,    12,    13,    11,    15,    89,    17,
      18,   104,   105,   288,   103,    24,   429,    25,    56,    27,
      90,   104,   105,    97,   299,   300,   103,    86,    87,   104,
     105,    39,    40,    22,    42,    43,   133,   134,    46,    47,
      48,   108,   139,   103,    53,   142,    54,    55,   103,   146,
     104,   105,   104,   105,   104,   105,    64,    41,    66,    67,
      68,    69,   104,   105,   378,    74,    75,    41,    77,   103,
      78,    79,    94,    95,     6,    83,    84,    85,   100,   101,
     103,   103,    14,     6,    92,    94,   103,    96,    20,    21,
      99,    14,   100,   101,    94,    95,    28,    20,    21,   108,
     100,   101,   103,   103,    53,   104,   105,   103,   383,   104,
     105,   386,   387,   104,   105,   140,   141,   103,   103,   417,
      52,   103,   103,    12,   103,   108,    98,    59,   103,    52,
      38,    29,    99,    72,   409,   410,    59,    99,   103,    71,
      99,    99,   417,   103,    99,    99,    72,    72,    71,   424,
      72,    72,    72,    72,    99,    72,    99,    99,    99,    72,
      72,    72,    63,    87,    28,    28,   104,   104,   104,    99,
     104,    99,    72,   104,    53,   104,    41,    93,    20,   106,
      63,    56,    60,    56,    56,    31,   104,    73,     3,   104,
     104,    29,    99,    99,   104,   104,    99,    99,   103,   103,
      99,   189,    43,    70,   433,   442,   441,   104,   104,   104,
     444,   322,   159,   231,   108,   193,    -1,    -1,   346
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,     5,    23,    32,    61,    91,   110,   111,   112,   113,
     115,   116,   118,   120,   121,   143,    65,    37,    65,    71,
      37,    65,    65,    65,    94,    95,   153,   154,     0,   102,
     152,   153,   153,    88,   119,    37,   153,    88,   114,   153,
     153,   107,   112,     4,     5,    20,    32,    50,    61,    90,
     144,   145,   146,   147,   148,   149,   150,   151,   155,   192,
     194,    56,    52,   152,   153,    89,   153,    70,   154,    16,
      21,   100,   101,   103,   124,   125,   154,   156,   157,   159,
      16,   195,   106,   108,   141,   175,    16,    19,    21,   103,
     154,   156,    16,   156,    70,   152,    16,   156,   105,   145,
     153,    89,   103,    56,    11,   153,   103,   159,   125,   154,
     122,   123,   124,   159,    14,    34,    59,    71,   126,   127,
     129,   130,   174,     7,     9,    10,    12,    13,    15,    17,
      18,    25,    27,    39,    40,    42,    43,    46,    47,    48,
      54,    55,    64,    66,    67,    68,    69,    78,    79,    83,
      84,    85,    92,   100,   101,   165,   177,   178,   179,   180,
     181,   182,   187,   190,   156,    97,   175,   103,   156,   103,
     157,   128,   156,    11,    62,   193,   156,   165,   152,   156,
     156,   145,   103,   122,   153,    22,   122,   126,   104,   105,
     103,    41,    41,    29,    38,   168,   169,   172,   103,   103,
     186,   103,    80,   103,    80,   103,   103,   191,   103,   183,
     186,   186,   186,   183,   183,   186,   103,   186,   103,   103,
      58,   103,   188,   188,   188,   191,   191,    53,   160,    12,
     163,   163,    32,    63,   108,   128,   193,   128,   193,   104,
     105,   165,   156,   165,   128,   104,   103,   104,   168,   123,
      98,   103,   172,    30,    36,    29,   170,   171,   128,    99,
      72,    99,   103,    99,   103,    99,    99,    99,    72,    76,
     184,    72,    72,    72,    72,    72,    72,    99,    72,    99,
      99,   188,    99,    72,    72,    72,     6,    20,    21,    28,
      52,    59,    71,   158,   161,   166,   167,   173,   174,    63,
      87,   164,   164,    28,   161,   104,   104,   156,   165,   158,
     161,   166,   104,     6,    20,    28,    33,    45,    49,    86,
      87,   117,   140,   142,   128,   104,   128,   104,   104,   104,
      99,   104,    99,   104,   104,   104,   105,    93,   185,   104,
     104,   104,    72,   104,   105,   175,   157,    24,    53,    74,
      75,    77,    94,    96,    99,   175,   189,    53,    41,   158,
     166,   158,   161,   167,   168,   154,   175,   176,   176,   158,
     161,   166,   158,   166,   158,   161,   117,   141,   141,   175,
      12,    86,    87,   141,   141,   141,   141,   141,   142,   104,
     104,   104,   104,    99,    99,   173,   103,   162,   158,   158,
     158,   166,   158,   161,   158,   158,    99,   175,    63,   141,
     141,   154,    99,    99,   154,   176,   117,    60,   104,   104,
     168,   104,   158,   158,   141,   154,   176,   152,   154,   103,
     128,   104,    35,    44,    57,   131,   132,   132,    56,   133,
     134,   137,   138,    31,    73,    56,   135,   138,    56,   136,
     137,    11,    51,    62,    63,   139,   139,     3,    28,    53
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,   109,   110,   111,   111,   112,   112,   112,   112,   112,
     112,   112,   112,   113,   113,   114,   114,   115,   116,   116,
     117,   117,   118,   119,   119,   120,   120,   121,   122,   122,
     123,   123,   124,   124,   125,   125,   126,   126,   126,   127,
     128,   128,   129,   129,   130,   131,   131,   132,   132,   132,
     133,   133,   134,   134,   135,   135,   136,   136,   137,   138,
     139,   139,   139,   139,   139,   140,   140,   141,   141,   142,
     142,   142,   142,   142,   142,   142,   142,   142,   142,   142,
     143,   144,   144,   144,   145,   145,   145,   145,   145,   145,
     145,   145,   145,   146,   146,   147,   147,   148,   148,   148,
     148,   148,   148,   148,   148,   148,   148,   148,   148,   148,
     148,   148,   148,   148,   148,   148,   148,   149,   150,   151,
     151,   152,   153,   153,   154,   154,   155,   155,   155,   155,
     156,   156,   156,   157,   158,   159,   159,   159,   159,   159,
     159,   159,   159,   159,   159,   160,   160,   161,   161,   161,
     161,   161,   161,   161,   162,   162,   163,   163,   164,   164,
     165,   165,   165,   165,   165,   165,   165,   165,   166,   166,
     167,   167,   168,   168,   169,   169,   170,   170,   171,   172,
     172,   173,   173,   173,   173,   173,   174,   175,   176,   176,
     177,   177,   177,   177,   177,   177,   177,   178,   179,   179,
     179,   179,   179,   180,   180,   180,   180,   180,   181,   181,
     182,   182,   182,   182,   182,   182,   182,   182,   182,   182,
     182,   182,   182,   182,   182,   182,   182,   182,   182,   182,
     183,   183,   183,   184,   184,   185,   185,   186,   186,   187,
     187,   187,   187,   187,   187,   187,   187,   188,   188,   188,
     189,   189,   189,   190,   190,   190,   190,   191,   191,   192,
     192,   192,   192,   192,   193,   193,   193,   194,   194,   195,
     195
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     1,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     4,     6,     2,     0,     3,     9,    10,
       1,     0,     8,     3,     0,     3,     2,     5,     1,     3,
       1,     1,     4,     3,     1,     0,     1,     1,     1,     4,
       1,     3,     2,     1,    12,     1,     0,     2,     1,     1,
       1,     0,     2,     2,     1,     0,     1,     0,     3,     3,
       1,     2,     2,     2,     1,     1,     2,     0,     1,     3,
       3,     3,     3,     2,     3,     4,     3,     5,     4,     3,
       4,     1,     3,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     2,     3,     4,     4,     5,     5,
       6,     5,     6,     6,     7,     5,     6,     6,     7,     6,
       7,     6,     7,     7,     8,     7,     8,     4,     2,     2,
       3,     1,     1,     3,     1,     1,     2,     3,     4,     5,
       1,     1,     1,     1,     2,     3,     4,     5,     4,     4,
       5,     6,     5,     6,     5,     0,     1,     2,     2,     2,
       2,     3,     2,     2,     0,     2,     0,     3,     0,     2,
       3,     1,     1,     1,     1,     3,     1,     1,     1,     2,
       2,     4,     1,     0,     2,     2,     1,     0,     1,     2,
       2,     2,     1,     2,     1,     1,     4,     3,     1,     1,
       1,     1,     4,     4,     5,     5,     4,     4,     4,     1,
       1,     1,     1,     4,     1,     1,     1,     1,     1,     1,
       2,     3,     3,     4,     2,     3,     2,     2,     2,     2,
       2,     3,     3,     3,     3,     3,     1,     1,     2,     3,
       3,     5,     0,     1,     0,     1,     0,     3,     0,     2,
       3,     3,     4,     2,     3,     2,     3,     3,     5,     0,
       1,     1,     1,     2,     1,     2,     2,     3,     0,     3,
       4,     5,     4,     5,     1,     1,     0,     5,     5,     1,
       0
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (x, YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)

/* This macro is provided for backward compatibility. */
# ifndef YY_LOCATION_PRINT
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif


# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, x); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, struct ddlpackage::pass_to_bison * x)
{
  FILE *yyoutput = yyo;
  YYUSE (yyoutput);
  YYUSE (x);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yykind < YYNTOKENS)
    YYPRINT (yyo, yytoknum[yykind], *yyvaluep);
# endif
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YYUSE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, struct ddlpackage::pass_to_bison * x)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep, x);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule, struct ddlpackage::pass_to_bison * x)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)], x);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule, x); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, struct ddlpackage::pass_to_bison * x)
{
  YYUSE (yyvaluep);
  YYUSE (x);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YYUSE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}






/*----------.
| yyparse.  |
`----------*/

int
yyparse (struct ddlpackage::pass_to_bison * x)
{
/* Lookahead token kind.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
YY_INITIAL_VALUE (static YYSTYPE yyval_default;)
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

    /* Number of syntax errors so far.  */
    int yynerrs = 0;

    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    goto yyexhaustedlab;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex (&yylval, scanner);
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2: /* stmtblock: stmtmulti  */
                          { x->fParseTree = (yyvsp[0].sqlStmtList); }
    break;

  case 3: /* stmtmulti: stmtmulti ';' stmt  */
        {
		if ((yyvsp[0].sqlStmt) != NULL) {
			(yyvsp[-2].sqlStmtList)->push_back((yyvsp[0].sqlStmt));
			(yyval.sqlStmtList) = (yyvsp[-2].sqlStmtList);
		}
		else {
			(yyval.sqlStmtList) = (yyvsp[-2].sqlStmtList);
		}
	}
    break;

  case 4: /* stmtmulti: stmt  */
        { 
		if ((yyvsp[0].sqlStmt) != NULL)
		{
			(yyval.sqlStmtList) = x->fParseTree;
			(yyval.sqlStmtList)->push_back((yyvsp[0].sqlStmt));
		}
		else
		{
			(yyval.sqlStmtList) = NULL;
		}
	}
    break;

  case 12: /* stmt: %empty  */
          { (yyval.sqlStmt) = NULL; }
    break;

  case 13: /* drop_table_statement: DROP TABLE opt_if_exists qualified_name  */
                                                {(yyval.sqlStmt) = new DropTableStatement((yyvsp[0].qualifiedName), false);}
    break;

  case 14: /* drop_table_statement: DROP TABLE opt_if_exists qualified_name CASCADE CONSTRAINTS  */
        {
		{(yyval.sqlStmt) = new DropTableStatement((yyvsp[-2].qualifiedName), true);}
	}
    break;

  case 15: /* opt_if_exists: IDB_IF EXISTS  */
                      {(yyval.str) = NULL;}
    break;

  case 16: /* opt_if_exists: %empty  */
          {(yyval.str) = NULL;}
    break;

  case 17: /* drop_index_statement: DROP INDEX qualified_name  */
                                  {(yyval.sqlStmt) = new DropIndexStatement((yyvsp[0].qualifiedName));}
    break;

  case 18: /* create_index_statement: CREATE INDEX qualified_name ON qualified_name '(' column_name_list ')' opt_table_options  */
        {
		(yyval.sqlStmt) = new CreateIndexStatement((yyvsp[-6].qualifiedName), (yyvsp[-4].qualifiedName), (yyvsp[-2].columnNameList), false);
		delete (yyvsp[0].tableOptionMap);
	}
    break;

  case 19: /* create_index_statement: CREATE UNIQUE INDEX qualified_name ON qualified_name '(' column_name_list ')' opt_table_options  */
        {
		(yyval.sqlStmt) = new CreateIndexStatement((yyvsp[-6].qualifiedName), (yyvsp[-4].qualifiedName), (yyvsp[-2].columnNameList), true);
		delete (yyvsp[0].tableOptionMap);
	}
    break;

  case 21: /* opt_table_options: %empty  */
          {(yyval.tableOptionMap) = NULL;}
    break;

  case 22: /* create_table_statement: CREATE TABLE opt_if_not_exists table_name '(' table_element_list ')' opt_table_options  */
        {
        for (auto* elem : *(yyvsp[-2].tableElementList))
        {
            fix_column_length(elem, x->default_table_charset);
        }
		(yyval.sqlStmt) = new CreateTableStatement(new TableDef((yyvsp[-4].qualifiedName), (yyvsp[-2].tableElementList), (yyvsp[0].tableOptionMap)));
	}
    break;

  case 23: /* opt_if_not_exists: IDB_IF NOT EXISTS  */
                          {(yyval.str) = NULL;}
    break;

  case 24: /* opt_if_not_exists: %empty  */
          {(yyval.str) = NULL;}
    break;

  case 25: /* trunc_table_statement: TRUNCATE TABLE qualified_name  */
                                      {(yyval.sqlStmt) = new TruncTableStatement((yyvsp[0].qualifiedName));}
    break;

  case 26: /* trunc_table_statement: TRUNCATE qualified_name  */
                                  { {(yyval.sqlStmt) = new TruncTableStatement((yyvsp[0].qualifiedName));} }
    break;

  case 27: /* rename_table_statement: RENAME TABLE qualified_name TO qualified_name  */
    {
        // MCOL-876. The change reuses existing infrastructure. 
        AtaRenameTable* renameAction = new AtaRenameTable((yyvsp[0].qualifiedName));
        AlterTableActionList* actionList = new AlterTableActionList();
        actionList->push_back(renameAction);
        (yyval.sqlStmt) = new AlterTableStatement((yyvsp[-2].qualifiedName), actionList);
    }
    break;

  case 28: /* table_element_list: table_element  */
        {
		(yyval.tableElementList) = new TableElementList();
		(yyval.tableElementList)->push_back((yyvsp[0].schemaObject));
	}
    break;

  case 29: /* table_element_list: table_element_list ',' table_element  */
        {
		(yyval.tableElementList) = (yyvsp[-2].tableElementList);
		(yyval.tableElementList)->push_back((yyvsp[0].schemaObject));
	}
    break;

  case 32: /* table_constraint_def: CONSTRAINT opt_constraint_name table_constraint opt_constraint_attributes  */
        {
		(yyval.schemaObject) = (yyvsp[-1].schemaObject);
		(yyvsp[-1].schemaObject)->fName = (yyvsp[-2].str);
	}
    break;

  case 33: /* table_constraint_def: opt_constraint_name table_constraint opt_constraint_attributes  */
        {
		(yyval.schemaObject) = (yyvsp[-1].schemaObject);
		(yyvsp[-1].schemaObject)->fName = (yyvsp[-2].str);
	}
    break;

  case 34: /* opt_constraint_name: constraint_name  */
                        {(yyval.str) = (yyvsp[0].str);}
    break;

  case 35: /* opt_constraint_name: %empty  */
          {(yyval.str) = "noname";}
    break;

  case 38: /* table_constraint: check_constraint_def  */
                               {(yyval.schemaObject) = new TableCheckConstraintDef((yyvsp[0].str));}
    break;

  case 39: /* unique_constraint_def: unique_specifier '(' column_name_list ')'  */
        {
		if ((yyvsp[-3].constraintType) == DDL_UNIQUE)
		    (yyval.schemaObject) = new TableUniqueConstraintDef((yyvsp[-1].columnNameList));
        else if ((yyvsp[-3].constraintType) == DDL_PRIMARY_KEY)
            (yyval.schemaObject) = new TablePrimaryKeyConstraintDef((yyvsp[-1].columnNameList));
	}
    break;

  case 40: /* column_name_list: column_name  */
        {
		(yyval.columnNameList) = new vector<string>;
		(yyval.columnNameList)->push_back((yyvsp[0].str));
	}
    break;

  case 41: /* column_name_list: column_name_list ',' column_name  */
        {
		(yyval.columnNameList) = (yyvsp[-2].columnNameList);
		(yyval.columnNameList)->push_back((yyvsp[0].str));
	}
    break;

  case 42: /* unique_specifier: PRIMARY KEY  */
                    {(yyval.constraintType) = DDL_PRIMARY_KEY;}
    break;

  case 43: /* unique_specifier: UNIQUE  */
                 {(yyval.constraintType) = DDL_UNIQUE;}
    break;

  case 44: /* referential_constraint_def: FOREIGN KEY '(' column_name_list ')' REFERENCES table_name '(' column_name_list ')' opt_match_type opt_referential_triggered_action  */
        {
		(yyval.schemaObject) = new TableReferencesConstraintDef((yyvsp[-8].columnNameList), (yyvsp[-5].qualifiedName), (yyvsp[-3].columnNameList), (yyvsp[-1].matchType), (yyvsp[0].refAction));
	}
    break;

  case 46: /* opt_match_type: %empty  */
          {(yyval.matchType) = DDL_FULL;}
    break;

  case 47: /* match_type: MATCH match_type  */
                         {(yyval.matchType) = (yyvsp[0].matchType);}
    break;

  case 48: /* match_type: FULL  */
             {(yyval.matchType) = DDL_FULL;}
    break;

  case 49: /* match_type: PARTIAL  */
                  {(yyval.matchType) = DDL_PARTIAL;}
    break;

  case 51: /* opt_referential_triggered_action: %empty  */
          {(yyval.refAction) = NULL;}
    break;

  case 52: /* referential_triggered_action: update_rule opt_delete_rule  */
        {
		(yyval.refAction) = new ReferentialAction();
		(yyval.refAction)->fOnUpdate = (yyvsp[-1].refActionCode);
		(yyval.refAction)->fOnDelete = (yyvsp[0].refActionCode);
	}
    break;

  case 53: /* referential_triggered_action: delete_rule opt_update_rule  */
        {
		(yyval.refAction) = new ReferentialAction();
		(yyval.refAction)->fOnUpdate = (yyvsp[0].refActionCode);
		(yyval.refAction)->fOnDelete = (yyvsp[-1].refActionCode);
	}
    break;

  case 55: /* opt_delete_rule: %empty  */
          {(yyval.refActionCode) = DDL_NO_ACTION;}
    break;

  case 57: /* opt_update_rule: %empty  */
          {(yyval.refActionCode) = DDL_NO_ACTION;}
    break;

  case 58: /* update_rule: ON UPDATE referential_action  */
                                     {(yyval.refActionCode) = (yyvsp[0].refActionCode);}
    break;

  case 59: /* delete_rule: ON IDB_DELETE referential_action  */
                                         {(yyval.refActionCode) = (yyvsp[0].refActionCode);}
    break;

  case 60: /* referential_action: CASCADE  */
                {(yyval.refActionCode) = DDL_CASCADE;}
    break;

  case 61: /* referential_action: SET NULL_TOK  */
                       {(yyval.refActionCode) = DDL_SET_NULL;}
    break;

  case 62: /* referential_action: SET DEFAULT  */
                      {(yyval.refActionCode) = DDL_SET_DEFAULT;}
    break;

  case 63: /* referential_action: NO ACTION  */
                    {(yyval.refActionCode) = DDL_NO_ACTION;}
    break;

  case 64: /* referential_action: RESTRICT  */
                   {(yyval.refActionCode) = DDL_RESTRICT;}
    break;

  case 65: /* table_options: table_option  */
        {
		(yyval.tableOptionMap) = new TableOptionMap();
		(*(yyval.tableOptionMap))[(yyvsp[0].tableOption)->first] = (yyvsp[0].tableOption)->second;
		delete (yyvsp[0].tableOption);
	}
    break;

  case 66: /* table_options: table_options table_option  */
        {
		(yyval.tableOptionMap) = (yyvsp[-1].tableOptionMap);
		(*(yyval.tableOptionMap))[(yyvsp[0].tableOption)->first] = (yyvsp[0].tableOption)->second;
		delete (yyvsp[0].tableOption);
	}
    break;

  case 67: /* opt_equal: %empty  */
        {}
    break;

  case 68: /* opt_equal: '='  */
                 {}
    break;

  case 69: /* table_option: ENGINE opt_equal ident  */
                               {(yyval.tableOption) = new pair<string,string>("engine", (yyvsp[0].str));}
    break;

  case 70: /* table_option: MAX_ROWS opt_equal ICONST  */
                                  {(yyval.tableOption) = new pair<string,string>("max_rows", (yyvsp[0].str));}
    break;

  case 71: /* table_option: MIN_ROWS opt_equal ICONST  */
                                  {(yyval.tableOption) = new pair<string,string>("min_rows", (yyvsp[0].str));}
    break;

  case 72: /* table_option: COMMENT opt_equal string_literal  */
                                         {(yyval.tableOption) = new pair<string,string>("comment", (yyvsp[0].str));}
    break;

  case 73: /* table_option: COMMENT string_literal  */
                               {(yyval.tableOption) = new pair<string,string>("comment", (yyvsp[0].str));}
    break;

  case 74: /* table_option: AUTO_INCREMENT opt_equal ICONST  */
    {
       (yyval.tableOption) = new pair<string,string>("auto_increment", (yyvsp[0].str));
    }
    break;

  case 75: /* table_option: DEFAULT CHARSET opt_equal ident  */
                                        {(yyval.tableOption) = new pair<string,string>("default charset", (yyvsp[0].str));}
    break;

  case 76: /* table_option: CHARSET opt_equal ident  */
                            {(yyval.tableOption) = new pair<string, string>("default charset", (yyvsp[0].str));}
    break;

  case 77: /* table_option: DEFAULT IDB_CHAR SET opt_equal ident  */
                                             {(yyval.tableOption) = new pair<string,string>("default charset", (yyvsp[0].str));}
    break;

  case 78: /* table_option: DEFAULT COLLATE opt_equal opt_quoted_literal  */
                                                 {(yyval.tableOption) = new pair<string, string>("default collate", (yyvsp[0].str));}
    break;

  case 79: /* table_option: COLLATE opt_equal opt_quoted_literal  */
                                         {(yyval.tableOption) = new pair<string, string>("default collate", (yyvsp[0].str));}
    break;

  case 80: /* alter_table_statement: ALTER TABLE table_name alter_table_actions  */
        {
		(yyval.sqlStmt) = new AlterTableStatement((yyvsp[-1].qualifiedName), (yyvsp[0].ataList));
	}
    break;

  case 81: /* alter_table_actions: alter_table_action  */
        {
		if ((yyvsp[0].ata) != NULL) {
			(yyval.ataList) = new AlterTableActionList();
			(yyval.ataList)->push_back((yyvsp[0].ata));
		}
		else {
			/* An alter_table_statement requires at least one action.
			   So, this shouldn't happen. */
			(yyval.ataList) = NULL;
		}		
	}
    break;

  case 82: /* alter_table_actions: alter_table_actions ',' alter_table_action  */
        {
		(yyval.ataList) = (yyvsp[-2].ataList);
		(yyval.ataList)->push_back((yyvsp[0].ata));
	}
    break;

  case 83: /* alter_table_actions: alter_table_actions alter_table_action  */
        {
		(yyval.ataList) = (yyvsp[-1].ataList);
		(yyval.ataList)->push_back((yyvsp[0].ata));
	}
    break;

  case 93: /* alter_table_comment: COMMENT opt_equal string_literal  */
    {(yyval.ata) = new AtaTableComment((yyvsp[0].str));}
    break;

  case 94: /* alter_table_comment: COMMENT string_literal  */
    {(yyval.ata) = new AtaTableComment((yyvsp[0].str));}
    break;

  case 95: /* modify_column: MODIFY column_name data_type  */
        {(yyval.ata) = new AtaModifyColumnType((yyvsp[-1].str),(yyvsp[0].columnType));}
    break;

  case 96: /* modify_column: MODIFY COLUMN column_name data_type  */
        {(yyval.ata) = new AtaModifyColumnType((yyvsp[-1].str),(yyvsp[0].columnType));}
    break;

  case 97: /* rename_column: CHANGE column_name column_name data_type  */
        {(yyval.ata) = new AtaRenameColumn((yyvsp[-2].str), (yyvsp[-1].str), (yyvsp[0].columnType), NULL);}
    break;

  case 98: /* rename_column: CHANGE column_name column_name data_type column_option  */
        {(yyval.ata) = new AtaRenameColumn((yyvsp[-3].str), (yyvsp[-2].str), (yyvsp[-1].columnType), (yyvsp[0].columnOption));}
    break;

  case 99: /* rename_column: CHANGE COLUMN column_name column_name data_type  */
        {(yyval.ata) = new AtaRenameColumn((yyvsp[-2].str), (yyvsp[-1].str), (yyvsp[0].columnType), NULL);}
    break;

  case 100: /* rename_column: CHANGE COLUMN column_name column_name data_type column_option  */
        {(yyval.ata) = new AtaRenameColumn((yyvsp[-3].str), (yyvsp[-2].str), (yyvsp[-1].columnType), (yyvsp[0].columnOption));}
    break;

  case 101: /* rename_column: CHANGE column_name column_name data_type column_qualifier_list  */
        {(yyval.ata) = new AtaRenameColumn((yyvsp[-3].str), (yyvsp[-2].str), (yyvsp[-1].columnType), (yyvsp[0].constraintList), NULL);}
    break;

  case 102: /* rename_column: CHANGE COLUMN column_name column_name data_type column_qualifier_list  */
        {(yyval.ata) = new AtaRenameColumn((yyvsp[-3].str), (yyvsp[-2].str), (yyvsp[-1].columnType), (yyvsp[0].constraintList), NULL);}
    break;

  case 103: /* rename_column: CHANGE column_name column_name data_type column_qualifier_list column_option  */
        {(yyval.ata) = new AtaRenameColumn((yyvsp[-4].str), (yyvsp[-3].str), (yyvsp[-2].columnType), (yyvsp[-1].constraintList), NULL, (yyvsp[0].columnOption));}
    break;

  case 104: /* rename_column: CHANGE COLUMN column_name column_name data_type column_qualifier_list column_option  */
        {(yyval.ata) = new AtaRenameColumn((yyvsp[-4].str), (yyvsp[-3].str), (yyvsp[-2].columnType), (yyvsp[-1].constraintList), NULL, (yyvsp[0].columnOption));}
    break;

  case 105: /* rename_column: CHANGE column_name column_name data_type default_clause  */
        {(yyval.ata) = new AtaRenameColumn((yyvsp[-3].str), (yyvsp[-2].str), (yyvsp[-1].columnType), NULL, (yyvsp[0].colDefault));}
    break;

  case 106: /* rename_column: CHANGE COLUMN column_name column_name data_type default_clause  */
        {(yyval.ata) = new AtaRenameColumn((yyvsp[-3].str), (yyvsp[-2].str), (yyvsp[-1].columnType), NULL, (yyvsp[0].colDefault));}
    break;

  case 107: /* rename_column: CHANGE column_name column_name data_type default_clause column_option  */
        {(yyval.ata) = new AtaRenameColumn((yyvsp[-4].str), (yyvsp[-3].str), (yyvsp[-2].columnType), NULL, (yyvsp[-1].colDefault), (yyvsp[0].columnOption));}
    break;

  case 108: /* rename_column: CHANGE COLUMN column_name column_name data_type default_clause column_option  */
        {(yyval.ata) = new AtaRenameColumn((yyvsp[-4].str), (yyvsp[-3].str), (yyvsp[-2].columnType), NULL, (yyvsp[-1].colDefault), (yyvsp[0].columnOption));}
    break;

  case 109: /* rename_column: CHANGE column_name column_name data_type column_qualifier_list default_clause  */
        {(yyval.ata) = new AtaRenameColumn((yyvsp[-4].str), (yyvsp[-3].str), (yyvsp[-2].columnType), (yyvsp[-1].constraintList), (yyvsp[0].colDefault));}
    break;

  case 110: /* rename_column: CHANGE COLUMN column_name column_name data_type column_qualifier_list default_clause  */
        {(yyval.ata) = new AtaRenameColumn((yyvsp[-4].str), (yyvsp[-3].str), (yyvsp[-2].columnType), (yyvsp[-1].constraintList), (yyvsp[0].colDefault));}
    break;

  case 111: /* rename_column: CHANGE column_name column_name data_type default_clause column_qualifier_list  */
        {(yyval.ata) = new AtaRenameColumn((yyvsp[-4].str), (yyvsp[-3].str), (yyvsp[-2].columnType), (yyvsp[0].constraintList), (yyvsp[-1].colDefault));}
    break;

  case 112: /* rename_column: CHANGE COLUMN column_name column_name data_type default_clause column_qualifier_list  */
        {(yyval.ata) = new AtaRenameColumn((yyvsp[-4].str), (yyvsp[-3].str), (yyvsp[-2].columnType), (yyvsp[0].constraintList), (yyvsp[-1].colDefault));}
    break;

  case 113: /* rename_column: CHANGE column_name column_name data_type column_qualifier_list default_clause column_option  */
        {(yyval.ata) = new AtaRenameColumn((yyvsp[-5].str), (yyvsp[-4].str), (yyvsp[-3].columnType), (yyvsp[-2].constraintList), (yyvsp[-1].colDefault), (yyvsp[0].columnOption));}
    break;

  case 114: /* rename_column: CHANGE COLUMN column_name column_name data_type column_qualifier_list default_clause column_option  */
        {(yyval.ata) = new AtaRenameColumn((yyvsp[-5].str), (yyvsp[-4].str), (yyvsp[-3].columnType), (yyvsp[-2].constraintList), (yyvsp[-1].colDefault), (yyvsp[0].columnOption));}
    break;

  case 115: /* rename_column: CHANGE column_name column_name data_type default_clause column_qualifier_list column_option  */
        {(yyval.ata) = new AtaRenameColumn((yyvsp[-5].str), (yyvsp[-4].str), (yyvsp[-3].columnType), (yyvsp[-1].constraintList), (yyvsp[-2].colDefault), (yyvsp[0].columnOption));}
    break;

  case 116: /* rename_column: CHANGE COLUMN column_name column_name data_type default_clause column_qualifier_list column_option  */
        {(yyval.ata) = new AtaRenameColumn((yyvsp[-5].str), (yyvsp[-4].str), (yyvsp[-3].columnType), (yyvsp[-1].constraintList), (yyvsp[-2].colDefault), (yyvsp[0].columnOption));}
    break;

  case 117: /* drop_table_constraint_def: DROP CONSTRAINT constraint_name drop_behavior  */
        {
		(yyval.ata) = new AtaDropTableConstraint((yyvsp[-1].str), (yyvsp[0].refActionCode));
	}
    break;

  case 118: /* add_table_constraint_def: ADD table_constraint_def  */
                                 {(yyval.ata) = new AtaAddTableConstraint(dynamic_cast<TableConstraintDef *>((yyvsp[0].schemaObject)));}
    break;

  case 119: /* ata_rename_table: RENAME table_name  */
                          {(yyval.ata) = new AtaRenameTable((yyvsp[0].qualifiedName));}
    break;

  case 120: /* ata_rename_table: RENAME TO table_name  */
                               {(yyval.ata) = new AtaRenameTable((yyvsp[0].qualifiedName));}
    break;

  case 122: /* qualified_name: ident  */
              {
				if (x->fDBSchema.size())
					(yyval.qualifiedName) = new QualifiedName((char*)x->fDBSchema.c_str(), (yyvsp[0].str));
				else
				    (yyval.qualifiedName) = new QualifiedName((yyvsp[0].str));   
			}
    break;

  case 123: /* qualified_name: ident '.' ident  */
        {
            (yyval.qualifiedName) = new QualifiedName((yyvsp[-2].str), (yyvsp[0].str));
        }
    break;

  case 126: /* ata_add_column: ADD column_def  */
                       { fix_column_length((yyvsp[0].schemaObject), x->default_table_charset); (yyval.ata) = new AtaAddColumn(dynamic_cast<ColumnDef*>((yyvsp[0].schemaObject)));}
    break;

  case 127: /* ata_add_column: ADD COLUMN column_def  */
                                { fix_column_length((yyvsp[0].schemaObject), x->default_table_charset); (yyval.ata) = new AtaAddColumn(dynamic_cast<ColumnDef*>((yyvsp[0].schemaObject)));}
    break;

  case 128: /* ata_add_column: ADD '(' table_element_list ')'  */
                                         {
        for (auto* elem : *(yyvsp[-1].tableElementList)) {
            fix_column_length(elem, x->default_table_charset);
        }
        (yyval.ata) = new AtaAddColumns((yyvsp[-1].tableElementList));
    }
    break;

  case 129: /* ata_add_column: ADD COLUMN '(' table_element_list ')'  */
                                                {
        for (auto* elem : *(yyvsp[-1].tableElementList)) {
            fix_column_length(elem, x->default_table_charset);
        }
        (yyval.ata) = new AtaAddColumns((yyvsp[-1].tableElementList));
    }
    break;

  case 134: /* column_option: COMMENT string_literal  */
                                {(yyval.columnOption) = (yyvsp[0].str);}
    break;

  case 135: /* column_def: column_name data_type opt_null_tok  */
        {
		(yyval.schemaObject) = new ColumnDef((yyvsp[-2].str), (yyvsp[-1].columnType), NULL, NULL );
	}
    break;

  case 136: /* column_def: column_name data_type opt_null_tok column_qualifier_list  */
        {
		(yyval.schemaObject) = new ColumnDef((yyvsp[-3].str), (yyvsp[-2].columnType), (yyvsp[0].constraintList), NULL);
	}
    break;

  case 137: /* column_def: column_name data_type opt_null_tok default_clause column_qualifier_list  */
        {
		(yyval.schemaObject) = new ColumnDef((yyvsp[-4].str), (yyvsp[-3].columnType), (yyvsp[0].constraintList), (yyvsp[-1].colDefault));
	}
    break;

  case 138: /* column_def: column_name data_type opt_null_tok default_clause  */
        {
		(yyval.schemaObject) = new ColumnDef((yyvsp[-3].str), (yyvsp[-2].columnType), NULL, (yyvsp[0].colDefault), NULL);
	}
    break;

  case 139: /* column_def: column_name data_type opt_null_tok column_option  */
        {
		(yyval.schemaObject) = new ColumnDef((yyvsp[-3].str), (yyvsp[-2].columnType), NULL, NULL, (yyvsp[0].columnOption) );
	}
    break;

  case 140: /* column_def: column_name data_type opt_null_tok column_qualifier_list column_option  */
        {
		(yyval.schemaObject) = new ColumnDef((yyvsp[-4].str), (yyvsp[-3].columnType), (yyvsp[-1].constraintList), NULL, (yyvsp[0].columnOption));
	}
    break;

  case 141: /* column_def: column_name data_type opt_null_tok default_clause column_qualifier_list column_option  */
        {
		(yyval.schemaObject) = new ColumnDef((yyvsp[-5].str), (yyvsp[-4].columnType), (yyvsp[-1].constraintList), (yyvsp[-2].colDefault), (yyvsp[0].columnOption));
	}
    break;

  case 142: /* column_def: column_name data_type opt_null_tok column_qualifier_list default_clause  */
        {
		(yyval.schemaObject) = new ColumnDef((yyvsp[-4].str), (yyvsp[-3].columnType), (yyvsp[-1].constraintList), (yyvsp[0].colDefault));
	}
    break;

  case 143: /* column_def: column_name data_type opt_null_tok column_qualifier_list default_clause column_option  */
        {
		(yyval.schemaObject) = new ColumnDef((yyvsp[-5].str), (yyvsp[-4].columnType), (yyvsp[-2].constraintList), (yyvsp[-1].colDefault), (yyvsp[0].columnOption));
	}
    break;

  case 144: /* column_def: column_name data_type opt_null_tok default_clause column_option  */
        {
		(yyval.schemaObject) = new ColumnDef((yyvsp[-4].str), (yyvsp[-3].columnType), NULL, (yyvsp[-1].colDefault), (yyvsp[0].columnOption));
	}
    break;

  case 147: /* default_clause: DEFAULT literal  */
        {
		(yyval.colDefault) = new ColumnDefaultValue((yyvsp[0].str));
	}
    break;

  case 148: /* default_clause: DEFAULT DQ_IDENT  */
        {
		(yyval.colDefault) = new ColumnDefaultValue((yyvsp[0].str));
	}
    break;

  case 149: /* default_clause: DEFAULT NULL_TOK  */
                           {(yyval.colDefault) = new ColumnDefaultValue(NULL);}
    break;

  case 150: /* default_clause: DEFAULT USER  */
                       {(yyval.colDefault) = new ColumnDefaultValue("$USER");}
    break;

  case 151: /* default_clause: DEFAULT CURRENT_USER optional_braces  */
                                               {(yyval.colDefault) = new ColumnDefaultValue("$CURRENT_USER");}
    break;

  case 152: /* default_clause: DEFAULT SESSION_USER  */
                               {(yyval.colDefault) = new ColumnDefaultValue("$SESSION_USER");}
    break;

  case 153: /* default_clause: DEFAULT SYSTEM_USER  */
                              {(yyval.colDefault) = new ColumnDefaultValue("$SYSTEM_USER");}
    break;

  case 154: /* optional_braces: %empty  */
                    {}
    break;

  case 155: /* optional_braces: '(' ')'  */
                  {}
    break;

  case 156: /* opt_column_charset: %empty  */
                { (yyval.str) = NULL; }
    break;

  case 157: /* opt_column_charset: IDB_CHAR SET opt_quoted_literal  */
                                    { (yyval.str) = (yyvsp[0].str); }
    break;

  case 158: /* opt_column_collate: %empty  */
                {}
    break;

  case 159: /* opt_column_collate: COLLATE opt_quoted_literal  */
                               {}
    break;

  case 160: /* data_type: character_string_type opt_column_charset opt_column_collate  */
                                                                    {
        (yyvsp[-2].columnType)->fCharset = (yyvsp[-1].str);
        (yyval.columnType) = (yyvsp[-2].columnType);
    }
    break;

  case 165: /* data_type: text_type opt_column_charset opt_column_collate  */
                                                          {
        (yyvsp[-2].columnType)->fCharset = (yyvsp[-1].str);
        (yyval.columnType) = (yyvsp[-2].columnType);
    }
    break;

  case 166: /* data_type: IDB_BLOB  */
        {
		(yyval.columnType) = new ColumnType(DDL_BLOB);
		(yyval.columnType)->fLength = DDLDatatypeLength[DDL_BLOB];
	}
    break;

  case 167: /* data_type: CLOB  */
        {
		(yyval.columnType) = new ColumnType(DDL_CLOB);
		(yyval.columnType)->fLength = DDLDatatypeLength[DDL_CLOB];
	}
    break;

  case 168: /* column_qualifier_list: column_constraint_def  */
        {
		(yyval.constraintList) = new ColumnConstraintList();
		(yyval.constraintList)->push_back((yyvsp[0].columnConstraintDef));
	}
    break;

  case 169: /* column_qualifier_list: column_qualifier_list column_constraint_def  */
        {
		(yyval.constraintList) = (yyvsp[-1].constraintList);
		(yyval.constraintList)->push_back((yyvsp[0].columnConstraintDef));
	}
    break;

  case 170: /* column_constraint_def: column_constraint opt_constraint_attributes  */
        {
		(yyval.columnConstraintDef) = (yyvsp[-1].columnConstraintDef);

		if((yyvsp[0].constraintAttributes) != NULL)
		{
			(yyvsp[-1].columnConstraintDef)->fDeferrable = (yyvsp[0].constraintAttributes)->fDeferrable;
			(yyvsp[-1].columnConstraintDef)->fCheckTime = (yyvsp[0].constraintAttributes)->fCheckTime;
		}

	}
    break;

  case 171: /* column_constraint_def: CONSTRAINT constraint_name column_constraint opt_constraint_attributes  */
        {
		(yyval.columnConstraintDef) = (yyvsp[-1].columnConstraintDef);
		(yyvsp[-1].columnConstraintDef)->fName = (yyvsp[-2].str);

		if((yyvsp[0].constraintAttributes) != NULL)
		{
			(yyvsp[-1].columnConstraintDef)->fDeferrable = (yyvsp[0].constraintAttributes)->fDeferrable;
			(yyvsp[-1].columnConstraintDef)->fCheckTime = (yyvsp[0].constraintAttributes)->fCheckTime;
		}
		
	}
    break;

  case 172: /* opt_constraint_attributes: constraint_attributes  */
                              {(yyval.constraintAttributes) = (yyvsp[0].constraintAttributes);}
    break;

  case 173: /* opt_constraint_attributes: %empty  */
          {(yyval.constraintAttributes) = NULL;}
    break;

  case 174: /* constraint_attributes: constraint_check_time opt_deferrability_clause  */
        {
		(yyval.constraintAttributes) = new ConstraintAttributes((yyvsp[-1].cattr), ((yyvsp[0].cattr) != 0));
	}
    break;

  case 175: /* constraint_attributes: DEFERRABLE constraint_check_time  */
        {
		(yyval.constraintAttributes) = new ConstraintAttributes((yyvsp[0].cattr), true);
	}
    break;

  case 177: /* opt_deferrability_clause: %empty  */
          {(yyval.cattr) = DDL_NON_DEFERRABLE;}
    break;

  case 178: /* deferrability_clause: DEFERRABLE  */
                   {(yyval.cattr) = DDL_DEFERRABLE;}
    break;

  case 179: /* constraint_check_time: INITIALLY DEFERRED  */
                           {(yyval.cattr) = DDL_INITIALLY_DEFERRED;}
    break;

  case 180: /* constraint_check_time: INITIALLY IMMEDIATE  */
                              {(yyval.cattr) = DDL_INITIALLY_IMMEDIATE;}
    break;

  case 181: /* column_constraint: NOT NULL_TOK  */
                     {(yyval.columnConstraintDef) = new ColumnConstraintDef(DDL_NOT_NULL);}
    break;

  case 182: /* column_constraint: UNIQUE  */
                 {(yyval.columnConstraintDef) = new ColumnConstraintDef(DDL_UNIQUE);}
    break;

  case 183: /* column_constraint: PRIMARY KEY  */
                      {(yyval.columnConstraintDef) = new ColumnConstraintDef(DDL_PRIMARY_KEY);}
    break;

  case 184: /* column_constraint: AUTO_INCREMENT  */
                         {(yyval.columnConstraintDef) = new ColumnConstraintDef(DDL_AUTO_INCREMENT);}
    break;

  case 185: /* column_constraint: check_constraint_def  */
                               {(yyval.columnConstraintDef) = new ColumnConstraintDef((yyvsp[0].str));}
    break;

  case 186: /* check_constraint_def: CHECK '(' CP_SEARCH_CONDITION_TEXT ')'  */
                                               {(yyval.str) = (yyvsp[-1].str);}
    break;

  case 187: /* string_literal: '\'' SCONST '\''  */
                         {(yyval.str) = (yyvsp[-1].str);}
    break;

  case 190: /* character_string_type: CHARACTER  */
        {
		(yyval.columnType) = new ColumnType(DDL_CHAR);
		(yyval.columnType)->fLength = 1;
	}
    break;

  case 191: /* character_string_type: IDB_CHAR  */
        {
		(yyval.columnType) = new ColumnType(DDL_CHAR);
		(yyval.columnType)->fLength = 1;
	}
    break;

  case 192: /* character_string_type: CHARACTER '(' ICONST ')'  */
        {
		(yyval.columnType) = new ColumnType(DDL_CHAR);
		(yyval.columnType)->fLength = atoi((yyvsp[-1].str));
	}
    break;

  case 193: /* character_string_type: IDB_CHAR '(' ICONST ')'  */
        {
		(yyval.columnType) = new ColumnType(DDL_CHAR);
		(yyval.columnType)->fLength = atoi((yyvsp[-1].str));
	}
    break;

  case 194: /* character_string_type: CHARACTER VARYING '(' ICONST ')'  */
        {
		(yyval.columnType) = new ColumnType(DDL_VARCHAR);
		(yyval.columnType)->fLength = atoi((yyvsp[-1].str));
	}
    break;

  case 195: /* character_string_type: IDB_CHAR VARYING '(' ICONST ')'  */
        {
		(yyval.columnType) = new ColumnType(DDL_VARCHAR);
		(yyval.columnType)->fLength = atoi((yyvsp[-1].str));
	}
    break;

  case 196: /* character_string_type: VARCHAR '(' ICONST ')'  */
        {
		(yyval.columnType) = new ColumnType(DDL_VARCHAR);
		(yyval.columnType)->fLength = atoi((yyvsp[-1].str));
	}
    break;

  case 197: /* binary_string_type: VARBINARY '(' ICONST ')'  */
        {
		(yyval.columnType) = new ColumnType(DDL_VARBINARY);
		(yyval.columnType)->fLength = atoi((yyvsp[-1].str));
	}
    break;

  case 198: /* blob_type: BLOB '(' ICONST ')'  */
        {
		(yyval.columnType) = new ColumnType(DDL_BLOB);
		(yyval.columnType)->fLength = atol((yyvsp[-1].str));
	}
    break;

  case 199: /* blob_type: BLOB  */
        {
		(yyval.columnType) = new ColumnType(DDL_BLOB);
		(yyval.columnType)->fLength = 65535;
	}
    break;

  case 200: /* blob_type: TINYBLOB  */
        {
		(yyval.columnType) = new ColumnType(DDL_BLOB);
		(yyval.columnType)->fLength = 255;
	}
    break;

  case 201: /* blob_type: MEDIUMBLOB  */
        {
		(yyval.columnType) = new ColumnType(DDL_BLOB);
		(yyval.columnType)->fLength = 16777215;
	}
    break;

  case 202: /* blob_type: LONGBLOB  */
        {
		(yyval.columnType) = new ColumnType(DDL_BLOB);
		(yyval.columnType)->fLength = 16777215;
	}
    break;

  case 203: /* text_type: TEXT '(' ICONST ')'  */
        {
		(yyval.columnType) = new ColumnType(DDL_TEXT);
		(yyval.columnType)->fLength = atol((yyvsp[-1].str));
		(yyval.columnType)->fExplicitLength = true;
	}
    break;

  case 204: /* text_type: TEXT  */
        {
		(yyval.columnType) = new ColumnType(DDL_TEXT);
		(yyval.columnType)->fLength = 65535;
	}
    break;

  case 205: /* text_type: TINYTEXT  */
        {
		(yyval.columnType) = new ColumnType(DDL_TEXT);
		(yyval.columnType)->fLength = 255;
	}
    break;

  case 206: /* text_type: MEDIUMTEXT  */
        {
		(yyval.columnType) = new ColumnType(DDL_TEXT);
		(yyval.columnType)->fLength = 16777215;
	}
    break;

  case 207: /* text_type: LONGTEXT  */
        {
		(yyval.columnType) = new ColumnType(DDL_TEXT);
		(yyval.columnType)->fLength = 16777215;
	}
    break;

  case 210: /* exact_numeric_type: NUMERIC opt_precision_scale  */
        {
		(yyvsp[0].columnType)->fType = DDL_NUMERIC;
		(yyvsp[0].columnType)->fLength = DDLDatatypeLength[DDL_NUMERIC];
		(yyval.columnType) = (yyvsp[0].columnType);
	}
    break;

  case 211: /* exact_numeric_type: NUMERIC opt_precision_scale UNSIGNED  */
        {
		(yyvsp[-1].columnType)->fType = DDL_UNSIGNED_NUMERIC;
		(yyvsp[-1].columnType)->fLength = DDLDatatypeLength[DDL_UNSIGNED_NUMERIC];
		(yyval.columnType) = (yyvsp[-1].columnType);
	}
    break;

  case 212: /* exact_numeric_type: DECIMAL opt_precision_scale opt_signed  */
        {
		(yyvsp[-1].columnType)->fType = DDL_DECIMAL;
		(yyval.columnType) = (yyvsp[-1].columnType);
	}
    break;

  case 213: /* exact_numeric_type: DECIMAL opt_precision_scale UNSIGNED opt_zerofill  */
        {
		(yyvsp[-2].columnType)->fType = DDL_UNSIGNED_DECIMAL;
		(yyval.columnType) = (yyvsp[-2].columnType);
	}
    break;

  case 214: /* exact_numeric_type: NUMBER opt_precision_scale  */
        {
		(yyvsp[0].columnType)->fType = DDL_DECIMAL;
		(yyvsp[0].columnType)->fLength = DDLDatatypeLength[DDL_DECIMAL];
		(yyval.columnType) = (yyvsp[0].columnType);
	}
    break;

  case 215: /* exact_numeric_type: NUMBER opt_precision_scale UNSIGNED  */
        {
		(yyvsp[-1].columnType)->fType = DDL_UNSIGNED_DECIMAL;
		(yyvsp[-1].columnType)->fLength = DDLDatatypeLength[DDL_UNSIGNED_DECIMAL];
		(yyval.columnType) = (yyvsp[-1].columnType);
	}
    break;

  case 216: /* exact_numeric_type: INTEGER opt_display_width  */
        {
		(yyval.columnType) = new ColumnType(DDL_INT);
		(yyval.columnType)->fLength = DDLDatatypeLength[DDL_INT];
	}
    break;

  case 217: /* exact_numeric_type: IDB_INT opt_display_width  */
        {
		(yyval.columnType) = new ColumnType(DDL_INT);
		(yyval.columnType)->fLength = DDLDatatypeLength[DDL_INT];
	}
    break;

  case 218: /* exact_numeric_type: SMALLINT opt_display_width  */
        {
		(yyval.columnType) = new ColumnType(DDL_SMALLINT);
		(yyval.columnType)->fLength = DDLDatatypeLength[DDL_SMALLINT];
	}
    break;

  case 219: /* exact_numeric_type: TINYINT opt_display_width  */
        {
		(yyval.columnType) = new ColumnType(DDL_TINYINT);
		(yyval.columnType)->fLength = DDLDatatypeLength[DDL_TINYINT];
	}
    break;

  case 220: /* exact_numeric_type: BIGINT opt_display_width  */
        {
		(yyval.columnType) = new ColumnType(DDL_BIGINT);
		(yyval.columnType)->fLength = DDLDatatypeLength[DDL_BIGINT];
	}
    break;

  case 221: /* exact_numeric_type: INTEGER opt_display_width UNSIGNED  */
        {
		(yyval.columnType) = new ColumnType(DDL_UNSIGNED_INT);
		(yyval.columnType)->fLength = DDLDatatypeLength[DDL_INT];
	}
    break;

  case 222: /* exact_numeric_type: IDB_INT opt_display_width UNSIGNED  */
        {
		(yyval.columnType) = new ColumnType(DDL_UNSIGNED_INT);
		(yyval.columnType)->fLength = DDLDatatypeLength[DDL_INT];
	}
    break;

  case 223: /* exact_numeric_type: SMALLINT opt_display_width UNSIGNED  */
        {
		(yyval.columnType) = new ColumnType(DDL_UNSIGNED_SMALLINT);
		(yyval.columnType)->fLength = DDLDatatypeLength[DDL_SMALLINT];
	}
    break;

  case 224: /* exact_numeric_type: TINYINT opt_display_width UNSIGNED  */
        {
		(yyval.columnType) = new ColumnType(DDL_UNSIGNED_TINYINT);
		(yyval.columnType)->fLength = DDLDatatypeLength[DDL_TINYINT];
	}
    break;

  case 225: /* exact_numeric_type: BIGINT opt_display_width UNSIGNED  */
        {
		(yyval.columnType) = new ColumnType(DDL_UNSIGNED_BIGINT);
		(yyval.columnType)->fLength = DDLDatatypeLength[DDL_BIGINT];
	}
    break;

  case 226: /* exact_numeric_type: BOOLEAN  */
        {
                (yyval.columnType) = new ColumnType(DDL_TINYINT);
                (yyval.columnType)->fLength = DDLDatatypeLength[DDL_TINYINT];
                (yyval.columnType)->fPrecision = 1;
        }
    break;

  case 227: /* exact_numeric_type: BOOL  */
        {
                (yyval.columnType) = new ColumnType(DDL_TINYINT);
                (yyval.columnType)->fLength = DDLDatatypeLength[DDL_TINYINT];
                (yyval.columnType)->fPrecision = 1;
        }
    break;

  case 228: /* exact_numeric_type: MEDIUMINT opt_display_width  */
        {
		(yyval.columnType) = new ColumnType(DDL_MEDINT);
		(yyval.columnType)->fLength = DDLDatatypeLength[DDL_MEDINT];
	}
    break;

  case 229: /* exact_numeric_type: MEDIUMINT opt_display_width UNSIGNED  */
        {
		(yyval.columnType) = new ColumnType(DDL_UNSIGNED_MEDINT);
		(yyval.columnType)->fLength = DDLDatatypeLength[DDL_UNSIGNED_MEDINT];
	}
    break;

  case 230: /* opt_precision_scale: '(' ICONST ')'  */
                       {(yyval.columnType) = new ColumnType(atoi((yyvsp[-1].str)), 0);}
    break;

  case 231: /* opt_precision_scale: '(' ICONST ',' ICONST ')'  */
                                    {(yyval.columnType) = new ColumnType(atoi((yyvsp[-3].str)), atoi((yyvsp[-1].str)));}
    break;

  case 232: /* opt_precision_scale: %empty  */
          {(yyval.columnType) = new ColumnType(10,0);}
    break;

  case 233: /* opt_signed: SIGNED  */
           {(yyval.str) = NULL;}
    break;

  case 234: /* opt_signed: %empty  */
      {(yyval.str) = NULL;}
    break;

  case 235: /* opt_zerofill: ZEROFILL  */
                 {(yyval.str) = NULL;}
    break;

  case 236: /* opt_zerofill: %empty  */
          {(yyval.str) = NULL;}
    break;

  case 237: /* opt_display_width: '(' ICONST ')'  */
                       {(yyval.str) = NULL;}
    break;

  case 238: /* opt_display_width: %empty  */
          {(yyval.str) = NULL;}
    break;

  case 239: /* approximate_numeric_type: DOUBLE opt_display_precision_scale_null  */
        {
            (yyval.columnType) = new ColumnType(DDL_DOUBLE);
            (yyval.columnType)->fLength = DDLDatatypeLength[DDL_DOUBLE];
        }
    break;

  case 240: /* approximate_numeric_type: DOUBLE opt_display_precision_scale_null UNSIGNED  */
        {
            (yyval.columnType) = new ColumnType(DDL_UNSIGNED_DOUBLE);
            (yyval.columnType)->fLength = DDLDatatypeLength[DDL_DOUBLE];
        }
    break;

  case 241: /* approximate_numeric_type: DOUBLE PRECISION opt_display_precision_scale_null  */
        {
            (yyval.columnType) = new ColumnType(DDL_DOUBLE);
            (yyval.columnType)->fLength = DDLDatatypeLength[DDL_DOUBLE];
        }
    break;

  case 242: /* approximate_numeric_type: DOUBLE PRECISION opt_display_precision_scale_null UNSIGNED  */
        {
            (yyval.columnType) = new ColumnType(DDL_UNSIGNED_DOUBLE);
            (yyval.columnType)->fLength = DDLDatatypeLength[DDL_DOUBLE];
        }
    break;

  case 243: /* approximate_numeric_type: REAL opt_display_precision_scale_null  */
        {
            (yyval.columnType) = new ColumnType(DDL_DOUBLE);
            (yyval.columnType)->fLength = DDLDatatypeLength[DDL_DOUBLE];
        }
    break;

  case 244: /* approximate_numeric_type: REAL opt_display_precision_scale_null UNSIGNED  */
        {
            (yyval.columnType) = new ColumnType(DDL_UNSIGNED_DOUBLE);
            (yyval.columnType)->fLength = DDLDatatypeLength[DDL_DOUBLE];
        }
    break;

  case 245: /* approximate_numeric_type: IDB_FLOAT opt_display_precision_scale_null  */
        {
            (yyval.columnType) = new ColumnType(DDL_FLOAT);
            (yyval.columnType)->fLength = DDLDatatypeLength[DDL_FLOAT];
        }
    break;

  case 246: /* approximate_numeric_type: IDB_FLOAT opt_display_precision_scale_null UNSIGNED  */
        {
            (yyval.columnType) = new ColumnType(DDL_UNSIGNED_FLOAT);
            (yyval.columnType)->fLength = DDLDatatypeLength[DDL_FLOAT];
        }
    break;

  case 247: /* opt_display_precision_scale_null: '(' ICONST ')'  */
                           {(yyval.str) = NULL;}
    break;

  case 248: /* opt_display_precision_scale_null: '(' ICONST ',' ICONST ')'  */
                                      {(yyval.str) = NULL;}
    break;

  case 249: /* opt_display_precision_scale_null: %empty  */
              {(yyval.str) = NULL;}
    break;

  case 253: /* datetime_type: DATETIME opt_time_precision  */
        {
            (yyval.columnType) = new ColumnType(DDL_DATETIME);
            (yyval.columnType)->fLength = DDLDatatypeLength[DDL_DATETIME];
                    (yyval.columnType)->fPrecision = (yyvsp[0].ival);
        }
    break;

  case 254: /* datetime_type: DATE  */
        {
            (yyval.columnType) = new ColumnType(DDL_DATE);
            (yyval.columnType)->fLength = DDLDatatypeLength[DDL_DATE];
        }
    break;

  case 255: /* datetime_type: TIME opt_time_precision  */
        {
            (yyval.columnType) = new ColumnType(DDL_TIME);
            (yyval.columnType)->fLength = DDLDatatypeLength[DDL_TIME];
            (yyval.columnType)->fPrecision = (yyvsp[0].ival);
        }
    break;

  case 256: /* datetime_type: TIMESTAMP opt_time_precision  */
        {
            (yyval.columnType) = new ColumnType(DDL_TIMESTAMP);
            (yyval.columnType)->fLength = DDLDatatypeLength[DDL_TIMESTAMP];
            (yyval.columnType)->fPrecision = (yyvsp[0].ival);
        }
    break;

  case 257: /* opt_time_precision: '(' ICONST ')'  */
                       {(yyval.ival) = atoi((yyvsp[-1].str));}
    break;

  case 258: /* opt_time_precision: %empty  */
          {(yyval.ival) = -1;}
    break;

  case 259: /* drop_column_def: DROP column_name drop_behavior  */
                                       {(yyval.ata) = new AtaDropColumn((yyvsp[-1].str), (yyvsp[0].refActionCode));}
    break;

  case 260: /* drop_column_def: DROP COLUMN column_name drop_behavior  */
                                                {(yyval.ata) = new AtaDropColumn((yyvsp[-1].str), (yyvsp[0].refActionCode));}
    break;

  case 261: /* drop_column_def: DROP COLUMN '(' column_name_list ')'  */
                                               {(yyval.ata) = new AtaDropColumns((yyvsp[-1].columnNameList));}
    break;

  case 262: /* drop_column_def: DROP '(' column_name_list ')'  */
                                        {(yyval.ata) = new AtaDropColumns((yyvsp[-1].columnNameList));}
    break;

  case 263: /* drop_column_def: DROP COLUMNS '(' column_name_list ')'  */
                                                {(yyval.ata) = new AtaDropColumns((yyvsp[-1].columnNameList));}
    break;

  case 264: /* drop_behavior: CASCADE  */
                {(yyval.refActionCode) = DDL_CASCADE;}
    break;

  case 265: /* drop_behavior: RESTRICT  */
                   {(yyval.refActionCode) = DDL_RESTRICT;}
    break;

  case 266: /* drop_behavior: %empty  */
          {(yyval.refActionCode) = DDL_NO_ACTION;}
    break;

  case 267: /* alter_column_def: ALTER opt_column column_name SET default_clause  */
                                                        {(yyval.ata) = new AtaSetColumnDefault((yyvsp[-2].str), (yyvsp[0].colDefault));}
    break;

  case 268: /* alter_column_def: ALTER opt_column column_name DROP DEFAULT  */
                                                          {(yyval.ata) = new AtaDropColumnDefault((yyvsp[-2].str));}
    break;



      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (x, YY_("syntax error"));
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, x);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, x);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;


#if !defined yyoverflow
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (x, YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturn;
#endif


/*-------------------------------------------------------.
| yyreturn -- parsing is finished, clean up and return.  |
`-------------------------------------------------------*/
yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, x);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, x);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}




