-- CREAR TABLA PARA EL HISTORIAL DE INDEMNNIZACIONES (EQUIVALENTE A LA TABLA DE RETIRO)
CREATE TABLE inv_indemnizacion_voluntaria (
	inv_id int NOT NULL AUTO_INCREMENT,
	inv_id_emp int NOT NULL COMMENT 'Llave del empleado',
	inv_fecha_calculo date NOT NULL,
	inv_observacion varchar(1000) NULL,
	inv_estado int NOT NULL COMMENT '0->inactivo, 1->activo, 2->completado',
	inv_usu_creacion int NOT NULL COMMENT 'Auditoria',
	inv_fecha_creacion datetime NOT NULL COMMENT 'Auditoria',
	inv_usu_modificacion int NOT NULL COMMENT 'Auditoria',
	inv_fecha_modificacion datetime NOT NULL COMMENT 'Auditoria',
	PRIMARY KEY (inv_id),
	CONSTRAINT fk_inv_id_emp FOREIGN KEY (inv_id_emp) REFERENCES emp_empleado (emp_id) ON DELETE RESTRICT ON UPDATE RESTRICT
);

-- MODIFICAR LA TABLA DE LIQUIDACIONES PARA USAR EN AMBOS CASOS
ALTER TABLE lqe_liquidacion_empleado 
MODIFY COLUMN lqe_id_rte int NULL COMMENT 'Llave principal - retiro empleados (dar de baja)' AFTER lqe_id,
ADD COLUMN lqe_id_inv int NULL COMMENT 'Llave principal - indemnizacion empleados (no dar de baja)' AFTER lqe_id_rte,
ADD CONSTRAINT fk_lqe_id_inv FOREIGN KEY (lqe_id_inv) REFERENCES inv_indemnizacion_voluntaria (inv_id) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AGREGAR PARAMETRO CON LA CONFIGURACION
INSERT INTO par_parametro (par_id_tpr, par_tipo, par_nombre, par_codigo, par_valor, par_default, par_data, par_sistema) VALUES (1, 'string', 'Parámetro para determinar las configuraciones del cálculo de la indemnización voluntaria', 'SYS_CONFIGURACION_INDEMNIZACION_VOLUNTARIA', 
'{"ID_TIPO_PLANILLA_INDEMNIZACION":"0", "MINIMO_MESES_PARA_INDEMNIZACION":"12", "NUMERO_MESES_SALARIO_PROMEDIO":"6", "ID_AGRUPADOR_INDEMNIZACION":"0", "AGREGAR_SALARIO":"0"}',
'{"ID_TIPO_PLANILLA_INDEMNIZACION":"0", "MINIMO_MESES_PARA_INDEMNIZACION":"12", "NUMERO_MESES_SALARIO_PROMEDIO":"6", "ID_AGRUPADOR_INDEMNIZACION":"0", "AGREGAR_SALARIO":"0"}', NULL, 1);

-- ACTUALIZAR EL PARAMETRO POR REFERENCIAS
SET @ID = (SELECT par_id FROM par_parametro WHERE par_codigo = 'TPL_PLANILLAS' AND par_sistema = 1);
UPDATE par_parametro SET par_valor = REPLACE(par_valor, '"}','", "INDEMNIZACION_INDIVIDUAL":"7"}'),
par_default = REPLACE(par_default, '"}','", "INDEMNIZACION_INDIVIDUAL":"0"}') WHERE par_id = @ID;

-- NUEVA OPCION EN EL MENU
INSERT INTO opc_opcion (opc_nombre, opc_funcion, opc_descripcion, opc_padre, opc_orden, opc_nivel, opc_hijo, opc_icono, 
	opc_color_modulo, opc_icono_personalizado, opc_imagen_personalizada, opc_estado, opc_usu_creacion, opc_fecha_creacion, 
	opc_usu_modificacion, opc_fecha_modificacion, opc_id_mos) VALUES ('Indemnización', 'calculo_indemnizacion', 'Cálculo de indemnización', 
	164, 4, 2, 0, NULL, NULL, NULL, NULL, 1, '1', '2019-04-30 16:48:21', '1', '2019-04-30 16:48:21', 0);
