/* NOTA DE REMISION */

/* AGREGAR CAMPO PARA CANTIDAD FALTANTE EN LA "FACTURA PADRE" */
ALTER TABLE def_detalle_fact
ADD COLUMN def_cantidad_faltante decimal(19, 6) NULL COMMENT 'Cantidad que aun no ha sido entregada al cliente, al momento de crear la factura es cero, cuando se haga una salida parcial, se actualizaria la cantidad. Esto servira para controlar las N notas de remision asociadas a una factura' 
AFTER def_precio_inventario;

------------------------------------------------------------------------------------------------------------------------------------------------------------

/* ACTUALIZAR LA TABLA DONDE SE ASOCIARAN LAS NOTAS DE REMISION A LA FACTURA PADRE */

ALTER TABLE fxr_factura_remisionxfactura DROP FOREIGN KEY fk_fxr_id_fac_remision;
ALTER TABLE fxr_factura_remisionxfactura DROP FOREIGN KEY FK_reference_1612;

ALTER TABLE fxr_factura_remisionxfactura
ADD COLUMN fxr_total_unidades_padre decimal(19, 6) NOT NULL COMMENT 'Cantidad total de articulos en la factura padre' AFTER fxr_id_fac_remision,
ADD COLUMN fxr_total_unidades_pendientes decimal(19, 6) NOT NULL COMMENT 'Cantidad total de articulos pendientes' AFTER fxr_total_unidades_padre,
ADD COLUMN fxr_total_unidades_entregadas decimal(19, 6) NOT NULL COMMENT 'Cantidad total de articulos que se entregaron' AFTER fxr_total_unidades_pendientes;
ALTER TABLE fxr_factura_remisionxfactura DROP INDEX fk_fxr_id_fac_remision, DROP INDEX FK_reference_1612;

ALTER TABLE fxr_factura_remisionxfactura
ADD CONSTRAINT fk_fxr_id_fac_padre FOREIGN KEY (fxr_id_fac) REFERENCES fac_factura (fac_id) ON DELETE RESTRICT ON UPDATE RESTRICT,
ADD CONSTRAINT fk_fxr_id_fac_remision FOREIGN KEY (fxr_id_fac_remision) REFERENCES fac_factura (fac_id) ON DELETE RESTRICT ON UPDATE RESTRICT,
COMMENT = 'facturas de remision por factura oficial';


------------------------------------------------------------------------------------------------------------------------------------------------------------

/* OPC ANULAR NOTA DE REMISION */
INSERT INTO opc_opcion (opc_nombre, opc_funcion, opc_descripcion, opc_padre, opc_orden, opc_nivel, opc_hijo, opc_icono, 
	opc_color_modulo, opc_icono_personalizado, opc_imagen_personalizada, opc_estado, opc_usu_creacion, opc_fecha_creacion, 
	opc_usu_modificacion, opc_fecha_modificacion, opc_id_mos) VALUES ('Anular Nota Remisión', 'anular_remision', 
	'Anulación de notas de remisión', 326, NULL, 2, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 7
);