-- CAMBIAR IMPACTO POR CONSECUENCIA
SET @ID = (SELECT opc_id FROM opc_opcion WHERE opc_funcion = 'conf_impact_rsg');
UPDATE opc_opcion SET opc_nombre = 'Consecuencia Riesgo', opc_descripcion = 'Mantenimiento de la consecuencia del riesgo'
WHERE opc_id = @ID;

-- COMO SE AGREGA UN PASO EXTRA LA 1RA EVALUACION SE PASA COMO ANALISIS 
SET @ID0 = (SELECT opc_id FROM opc_opcion WHERE opc_funcion = 'conf_evalua_rsg');
UPDATE opc_opcion SET opc_nombre = 'Análisis de Riesgo', opc_descripcion = 'Mantenimiento del análisis del riesgo'
WHERE opc_id = @ID0;

-- SE CREA UN MANTENIMIENTO NUEVO PARA LA EVALUACION FINAL
INSERT INTO opc_opcion(opc_nombre, opc_funcion, opc_descripcion, opc_padre, opc_orden, opc_nivel, opc_hijo, opc_icono, opc_color_modulo, opc_icono_personalizado, opc_imagen_personalizada, opc_estado, opc_usu_creacion, opc_fecha_creacion, opc_usu_modificacion, opc_fecha_modificacion, opc_id_mos) VALUES ('Evaluación de Riesgo', 'conf_evaluacion_final', 'Mantenimiento de la evaluación total del riesgo', 1326, 15, 2, 0, NULL, NULL, NULL, NULL, 1, '1', '2021-08-25 00:00:00', '1', '2021-08-25 00:00:00', 1);

CREATE TABLE evt_evaluacion_riesgo_total (
  evt_id int(11) NOT NULL AUTO_INCREMENT COMMENT 'Llave Principal - Evaluacion final de Riesgo',
  evt_id_evr_antes int(11) NOT NULL COMMENT 'Llave Principal - Evaluacion de Riesgo antes de control',
  evt_id_evr_despues int(11) NOT NULL COMMENT 'Llave Principal - Evaluacion de Riesgo despues de control',
  evt_nombre varchar(100) NOT NULL COMMENT 'Nombre de la Evaluación',
  evt_color_alerta varchar(100) NOT NULL COMMENT 'Codigo Hexadecimal del la Alerta',
  evt_estado int(11) NOT NULL COMMENT 'Estado de registro',
  evt_usu_creacion int(11) NOT NULL COMMENT 'Auditoria',
  evt_usu_modificacion int(11) NOT NULL COMMENT 'Auditoria',
  evt_fecha_creacion datetime(0) NOT NULL COMMENT 'Auditoria',
  evt_fecha_modificacion datetime(0) NOT NULL COMMENT 'Auditoria',
  PRIMARY KEY (evt_id),
  CONSTRAINT fk_evt_id_evr_a FOREIGN KEY (evt_id_evr_antes) REFERENCES evr_evaluacion_riesgo (evr_id) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT fk_evt_id_evr_d FOREIGN KEY (evt_id_evr_despues) REFERENCES evr_evaluacion_riesgo (evr_id) ON DELETE RESTRICT ON UPDATE RESTRICT
);

-- SE MODIFICA LA TABLA RIESGO PARA LOS CAMPOS NUEVOS
ALTER TABLE rsg_riesgos 
	DROP FOREIGN KEY fk_rsg_id_imr,
	DROP FOREIGN KEY fk_rsg_id_prb;
ALTER TABLE rsg_riesgos 
	DROP INDEX fk_rsg_id_imr, 
	DROP INDEX fk_rsg_id_prb;
ALTER TABLE rsg_riesgos 
	CHANGE COLUMN rsg_id_imr rsg_id_imr_pre_control int(11) NULL COMMENT 'Llave Principal - Impacto de Riesgo antes de controles' AFTER rsg_id_clr,
	CHANGE COLUMN rsg_id_prb rsg_id_prb_pre_control int(11) NULL COMMENT 'Llave Principal - Probabilidad de Riesgo antes de controles' AFTER rsg_id_imr_pre_control;
ALTER TABLE rsg_riesgos 
	ADD COLUMN rsg_id_imr_post_control int(11) NULL COMMENT 'Llave Principal - Impacto de Riesgo despues de controles' AFTER rsg_id_imr_pre_control,
	ADD COLUMN rsg_id_prb_post_control int(11) NULL COMMENT 'Llave Principal - Probabilidad de Riesgo despues de controles' AFTER rsg_id_prb_pre_control;
ALTER TABLE rsg_riesgos ADD COLUMN rsg_id_evt int(11) NULL COMMENT 'Llave Principal - Evaluacion final del Riesgo' AFTER rsg_id_prb_post_control;
ALTER TABLE rsg_riesgos 
	ADD CONSTRAINT fk_rsg_id_imr_antes FOREIGN KEY (rsg_id_prb_pre_control) REFERENCES imr_impacto_riesgo (imr_id) ON DELETE NO ACTION ON UPDATE NO ACTION,
	ADD CONSTRAINT fk_rsg_id_imr_despues FOREIGN KEY (rsg_id_imr_post_control) REFERENCES imr_impacto_riesgo (imr_id) ON DELETE NO ACTION ON UPDATE NO ACTION,
	ADD CONSTRAINT fk_rsg_id_prb_antes FOREIGN KEY (rsg_id_prb_pre_control) REFERENCES prb_probabilidad_riesgo (prb_id) ON DELETE NO ACTION ON UPDATE NO ACTION,
	ADD CONSTRAINT fk_rsg_id_prb_despues FOREIGN KEY (rsg_id_prb_post_control) REFERENCES prb_probabilidad_riesgo (prb_id) ON DELETE NO ACTION ON UPDATE NO ACTION,
	ADD CONSTRAINT fk_rsg_id_evt FOREIGN KEY (rsg_id_evt) REFERENCES evt_evaluacion_riesgo_total (evt_id) ON DELETE NO ACTION ON UPDATE NO ACTION;