# TABLAS Y OPCIONES DE MENU PARA SEGUIMIENTO DE RIESGO
drop table if exists rsd_riesgo_residual;
CREATE TABLE rsd_riesgo_residual (
    rsd_id int(11) NOT NULL AUTO_INCREMENT COMMENT 'Llave Principal',
    rsd_nombre varchar(100) NOT NULL COMMENT 'Nombre del riesgo residual',
    rsd_descripcion varchar(1000) NULL COMMENT 'Descripcion del riesgo residual',
    rsd_estado int(11) NOT NULL COMMENT 'Estado del riesgo residual',
    rsd_usu_creacion int(11) NOT NULL COMMENT 'Auditoria',
    rsd_usu_modificacion int(11) NOT NULL COMMENT 'Auditoria',
    rsd_fecha_creacion datetime(0) NOT NULL COMMENT 'Auditoria',
    rsd_fecha_modificacion datetime(0) NOT NULL COMMENT 'Auditoria',
    PRIMARY KEY (rsd_id)
);


drop table if exists stl_estado_logro;
CREATE TABLE stl_estado_logro (
    stl_id int(11) NOT NULL AUTO_INCREMENT COMMENT 'Llave principal',
    stl_nombre varchar(100) NOT NULL COMMENT 'Nombre del estado',
    stl_descripcion varchar(1000) NULL COMMENT 'Descripcion del estado',
    stl_estado int(11) NOT NULL COMMENT '1 Activo / 0 Inactivo',
    stl_usu_creacion int(11) NOT NULL COMMENT 'Auditoria',
    stl_fecha_creacion datetime(0) NOT NULL COMMENT 'Auditoria',
    stl_usu_modificacion int(11) NOT NULL COMMENT 'Auditoria',
    stl_fecha_modificacion datetime(0) NOT NULL COMMENT 'Auditoria',
    PRIMARY KEY (stl_id)
);


drop table if exists sga_seguimiento_matriz;
create table sga_seguimiento_matriz
(
    sga_id               int not null auto_increment comment 'Llave principal - Seguimiento de Matriz',
    sga_id_mxu           int not null comment 'Llave Principal -Matriz  por Unidad',
    sga_id_psf           int not null comment 'Llave Principal - Paso Flujo',
    sga_id_usu_inicia    int not null comment 'Llave principal - Usuario Inicia el paso',
    sga_id_usu_cierra    int comment 'Llave principal - Usuario cierra el paso',
    sga_fecha_entrada    datetime not null comment 'Fecha de entrada de paso',
    sga_fecha_salida     datetime comment 'Fecha de salida de paso',
    sga_observacion      varchar(1000) comment 'Observaciones ',
    sga_anexo            varchar(1000) comment 'Anexos',
    sga_estado           int not null comment 'estado de flujo',
    sga_usu_creacion     int not null comment 'auditoria',
    sga_usu_modificacion int not null comment 'auditoria',
    sga_fecha_creacion   datetime not null comment 'auditoria',
    sga_fecha_modificacion datetime not null comment 'auditoria',
    primary key (sga_id)
);
alter table sga_seguimiento_matriz comment 'Seguimiento de Matriz';
alter table sga_seguimiento_matriz add constraint fk_sga_id_mxu foreign key (sga_id_mxu) references mxu_matrizxunidad (mxu_id) on delete restrict on update restrict;
alter table sga_seguimiento_matriz add constraint fk_sga_id_psf foreign key (sga_id_psf) references psf_paso_flujo (psf_id) on delete restrict on update restrict;


drop table if exists sgu_seguimiento_resumen;
create table sgu_seguimiento_resumen
(
    sgu_id               int not null auto_increment comment 'Llave principal- Seguimiento de Riesgo',
    sgu_id_flu           int(11) not null comment 'codigo de flujo',
    sgu_id_mxu           int not null comment 'Llave Principal -Matriz  por Unidad',
    sgu_observacion      varchar(1000) comment 'Observaciones de Seguimiento de Riesgo',
    sgu_fecha            datetime not null comment 'Fecha de Seguimiento de Riesgo',
    sgu_estado           int not null comment 'Estado de registro',
    sgu_usu_creacion     int not null comment 'Auditoria',
    sgu_usu_modificacion int not null comment 'Auditoria',
    sgu_fecha_creacion   datetime not null comment 'Auditoria',
    sgu_fecha_modificacion datetime not null comment 'Auditoria',
    primary key (sgu_id)
) COMMENT = 'Tabla para el resumen de seguimiento de riesgo';
alter table sgu_seguimiento_resumen add constraint fk_sgu_id_flu foreign key (sgu_id_flu) references flu_flujo (flu_id) on delete restrict on update restrict;
alter table sgu_seguimiento_resumen add constraint fk_sgu_id_mxu foreign key (sgu_id_mxu) references mxu_matrizxunidad (mxu_id) on delete restrict on update restrict;


drop table if exists sgr_seguimiento_riesgo;
CREATE TABLE sgr_seguimiento_riesgo  (
    sgr_id int(11) NOT NULL AUTO_INCREMENT COMMENT 'Llave Principal',
    sgr_id_sgu int(11) NOT NULL COMMENT 'Llave Principal - Seguimiento Resumen de Riesgo',
    sgr_id_rsg int(11) NOT NULL COMMENT 'Llave Principal - Riesgo', 
    sgr_id_rsd int(11) NOT NULL COMMENT 'Llave Principal - Riesgo residual',
    sgr_id_imr int(11) NULL COMMENT 'Llave Principal - Impacto',
    sgr_id_prb int(11) NULL COMMENT 'Llave Principal - Probabilidad',
    sgr_acciones_cont varchar(1000) NULL COMMENT 'Acciones de contingencia',
    sgr_fecha_inicio datetime(0) NOT NULL COMMENT 'Fecha inicio',
    sgr_fecha_final datetime(0) NOT NULL COMMENT 'Fecha final',
    sgr_estado int(11) NOT NULL COMMENT 'Estado 1-Activo 0-Inactivo',
    sgr_usu_creacion int(11) NOT NULL COMMENT 'auditoria',
    sgr_fecha_creacion datetime(0) NOT NULL COMMENT 'auditoria',
    sgr_usu_modificacion int(11) NOT NULL COMMENT 'auditoria',
    sgr_fecha_modificacion datetime(0) NOT NULL COMMENT 'auditoria',
    PRIMARY KEY (sgr_id),
    CONSTRAINT fk_sgr_id_rsg FOREIGN KEY (sgr_id_rsg) REFERENCES rsg_riesgos (rsg_id) ON DELETE RESTRICT ON UPDATE RESTRICT,
    CONSTRAINT fk_sgr_id_sgu FOREIGN KEY (sgr_id_sgu) REFERENCES sgu_seguimiento_resumen (sgu_id) ON DELETE RESTRICT ON UPDATE RESTRICT,
    CONSTRAINT fk_sgr_id_imr FOREIGN KEY (sgr_id_imr) REFERENCES imr_impacto_riesgo (imr_id) ON DELETE RESTRICT ON UPDATE RESTRICT,
    CONSTRAINT fk_sgr_id_prb FOREIGN KEY (sgr_id_prb) REFERENCES prb_probabilidad_riesgo (prb_id) ON DELETE RESTRICT ON UPDATE RESTRICT,
    CONSTRAINT fk_sgr_id_rsd FOREIGN KEY (sgr_id_rsd) REFERENCES rsd_riesgo_residual (rsd_id) ON DELETE RESTRICT ON UPDATE RESTRICT
) COMMENT = 'Tabla para el seguimiento de riesgo';


drop table if exists sgg_seguimiento_riesgo_flujo;
create table sgg_seguimiento_riesgo_flujo
(
    sgg_id               int not null auto_increment comment 'Llave principal - Seguimiento de riesgo(Seguimiento)',
    sgg_id_sgu           int not null comment 'Llave principal- Seguimiento de Riesgo',
    sgg_id_psf           int(11) not null comment 'Llave Principal - Paso Flujo',
    sgg_id_usu           int not null comment 'Llave principal - Usuario',
    sgg_fecha_entrada    datetime not null comment 'Fecha de entrada de paso',
    sgg_fecha_salida     datetime comment 'Fecha de salida de paso',
    sgg_observacion      varchar(1000) comment 'Observaciones ',
    sgg_anexo            varchar(1000) comment 'Anexos',
    sgg_estado           int not null comment 'Estado de flujo',
    sgg_usu_creacion     int not null comment 'Auditoría',
    sgg_usu_modificacion int not null comment 'Auditoría',
    sgg_fecha_creacion   datetime not null comment 'Auditoría',
    sgg_fecha_modificacion datetime not null comment 'Auditoría',
    primary key (sgg_id)
) COMMENT = 'Tabla para el seguimiento de riesgo (flujo)';
alter table sgg_seguimiento_riesgo_flujo add constraint fk_sgg_id_psf foreign key (sgg_id_psf) references psf_paso_flujo (psf_id) on delete restrict on update restrict;
alter table sgg_seguimiento_riesgo_flujo  add constraint fk_sgg_id_sgu foreign key (sgg_id_sgu) references sgu_seguimiento_resumen (sgu_id) on delete restrict on update restrict;


drop table if exists ixs_indicadoresxseguimiento;
CREATE TABLE ixs_indicadoresxseguimiento  (
    ixs_id int(11) NOT NULL AUTO_INCREMENT COMMENT 'Llave Principal',
    ixs_id_sgr int(11) NOT NULL COMMENT 'Llave Principal - Seguimiento Riesgo',
    ixs_id_inr int(11) NULL COMMENT 'Llave Principal - Indicador Riesgo',
    ixs_id_stl int(11) NULL COMMENT 'Llave Principal - Estado del logro',
    ixs_fecha_seguimiento datetime(0) NOT NULL COMMENT 'Fecha en que se hizo el seguimiento',
    ixs_fecha_accion_seguimiento datetime(0) NULL COMMENT 'Fecha en que se hizo / completo la accion',
    ixs_limitaciones varchar(1000) NULL COMMENT 'Limitaciones en el cumplimiento',
    ixs_logros_obtenidos varchar(1000) NULL COMMENT 'Logro obtenido en el cumplimiento',
    ixs_porcentaje_ind decimal(19, 6) NOT NULL COMMENT 'porcentaje de cumplimiento',
    ixs_estado int(11) NOT NULL COMMENT 'Estado 1-Activo 0-Inactivo',
    ixs_usu_creacion int(11) NOT NULL COMMENT 'auditoria',
    ixs_fecha_creacion datetime(0) NOT NULL COMMENT 'auditoria',
    ixs_usu_modificacion int(11) NOT NULL COMMENT 'auditoria',
    ixs_fecha_modificacion datetime(0) NOT NULL COMMENT 'auditoria',
    PRIMARY KEY (ixs_id),
    CONSTRAINT fk_ixs_id_sgr FOREIGN KEY (ixs_id_sgr) REFERENCES sgr_seguimiento_riesgo (sgr_id) ON DELETE RESTRICT ON UPDATE RESTRICT,
    CONSTRAINT fk_ixs_id_stl FOREIGN KEY (ixs_id_stl) REFERENCES stl_estado_logro (stl_id) ON DELETE RESTRICT ON UPDATE RESTRICT,
    CONSTRAINT fk_ixs_id_inr FOREIGN KEY (ixs_id_inr) REFERENCES inr_indicador_riesgo (inr_id) ON DELETE RESTRICT ON UPDATE RESTRICT
) COMMENT = 'Tabla para el Listado de Indicadores de los indicadores del riesgo';

CREATE TABLE ans_anexo_seguim_riesgo (
    ans_id int(11) NOT NULL AUTO_INCREMENT COMMENT 'Llave Principal',
    ans_id_sgr int(11) NOT NULL COMMENT 'LLave Principal Seguimiento riesgo',
    ans_nombre varchar(300) NOT NULL COMMENT 'Nombre anexo',
    ans_url varchar(300) NOT NULL COMMENT 'Url del anexo',
    ans_estado int(11) NOT NULL COMMENT '1 Activo / 0 Inactivo',
    ans_usu_creacion int(11) NOT NULL COMMENT 'Auditoria',
    ans_usu_modificacion int(11) NOT NULL COMMENT 'Auditoria',
    ans_fecha_creacion datetime(0) NOT NULL COMMENT 'Auditoria',
    ans_fecha_modificacion datetime(0) NOT NULL COMMENT 'Auditoria',
    PRIMARY KEY (ans_id),
    CONSTRAINT fk_ans_id_sgr FOREIGN KEY (ans_id_sgr) REFERENCES sgr_seguimiento_riesgo (sgr_id) ON DELETE RESTRICT ON UPDATE RESTRICT
);

INSERT INTO flu_flujo(
    flu_nombre, flu_descripcion, flu_tabla_proceso, flu_tabla_seguimiento, flu_estado, flu_usu_creacion, flu_usu_modificacion, flu_fecha_creacion, flu_fecha_modificacion
) VALUES (
    'Planificación - Riesgos - Formulación', 'Planificación - Formulación de Riesgos', 'rsg_riesgos', 'sga_seguimiento_matriz', 1, 1, 1, '2021-11-11 00:00:00', '2021-11-11 14:27:28'
);


INSERT INTO flu_flujo(
    flu_nombre, flu_descripcion, flu_tabla_proceso, flu_tabla_seguimiento, flu_estado, flu_usu_creacion, flu_usu_modificacion, flu_fecha_creacion, flu_fecha_modificacion
) VALUES (
    'Planificación - Riesgos - Seguimiento', 'Planificación - Seguimiento de Riesgos', 'sgu_seguimiento_resumen', 'sgr_seguimiento_riesgo', 1, 1, 1, '2021-11-11 00:00:00', '2021-11-11 00:00:00'
);


INSERT INTO opc_opcion(
    opc_nombre, opc_funcion, opc_descripcion, opc_padre, opc_orden, opc_nivel, opc_hijo, opc_icono, opc_color_modulo, opc_icono_personalizado,
    opc_imagen_personalizada, opc_estado, opc_usu_creacion, opc_fecha_creacion, opc_usu_modificacion, opc_fecha_modificacion, opc_id_mos
) VALUES (
    'Habilitar Tareas Riesgos', 'habilita_tarea_rsg', 'Habilitar tareas de la matriz de riegos', 1326, 12, 2, 0, NULL, NULL, NULL, NULL,
    1, '1', '2020-04-15 15:54:32', '1', '2020-04-15 15:54:34', 1
);


INSERT INTO opc_opcion(
    opc_nombre, opc_funcion, opc_descripcion, opc_padre, opc_orden, opc_nivel, opc_hijo, opc_icono, opc_color_modulo, opc_icono_personalizado,
    opc_imagen_personalizada, opc_estado, opc_usu_creacion, opc_fecha_creacion, opc_usu_modificacion, opc_fecha_modificacion, opc_id_mos
) VALUES (
    'Riesgos Residuales', 'conf_rsg_resid', 'Mantenimiento de los riesgos residual', 1326, 13, 2, 0, NULL, NULL, NULL, NULL, 1, '1', '2020-04-15 15:54:32', '1', '2020-04-15 15:54:34', 1
);


INSERT INTO opc_opcion(
    opc_nombre, opc_funcion, opc_descripcion, opc_padre, opc_orden, opc_nivel, opc_hijo, opc_icono, opc_color_modulo, opc_icono_personalizado,
    opc_imagen_personalizada, opc_estado, opc_usu_creacion, opc_fecha_creacion, opc_usu_modificacion, opc_fecha_modificacion, opc_id_mos
) VALUES (
    'Estado del Logro', 'conf_estado_logro', 'Mantenimiento del estado de los logros en el tratamiento del riesgo', 1326, 14, 2, 0,
    NULL, NULL, NULL, NULL, 1, '1', '2020-04-15 15:54:32', '1', '2020-04-15 15:54:32', 1
);