drop table if exists slm_solicitud_modificacion;

/*==============================================================*/
/* Table: slm_solicitud_modificacion                            */
/*==============================================================*/
create table slm_solicitud_modificacion
(
   slm_id               int not null auto_increment comment 'LLave Principal - Solicitud de Modificacion',
   slm_id_flu           int not null comment 'Llave Principal - Flujo',
   slm_id_pxu           int not null comment 'Llave Principal - Plan Operativo por Unidad',
   slm_id_usu           int not null comment 'Usuario a quien pertenece la Solicitud',
   slm_fecha            datetime not null comment 'Fecha de la Solicitud',
   slm_justificacion    varchar(1000) not null comment 'Justificacion de la solicitud',
   slm_comentarios      varchar(1000) comment 'Comentarios de la Solicitud',
   slm_estado           int not null comment 'Estado de registro',
   slm_usu_creacion     int not null comment 'Auditoria',
   slm_fecha_creacion   datetime not null comment 'Auditoria',
   slm_usu_modificacion int not null comment 'Auditoria',
   slm_fecha_modificacion datetime not null comment 'Auditoria',
   primary key (slm_id)
);

alter table slm_solicitud_modificacion add constraint fk_slm_id_flu foreign key (slm_id_flu)
      references flu_flujo (flu_id) on delete restrict on update restrict;

alter table slm_solicitud_modificacion add constraint fk_slm_id_pxu foreign key (slm_id_pxu)
      references pxu_plan_operativoxunidad (pxu_id) on delete restrict on update restrict;
