drop table if exists ino_indicador_operativo;
/*==============================================================*/
/* Table: ino_indicador_operativo                               */
/*==============================================================*/
create table ino_indicador_operativo
(
   ino_id               int not null auto_increment comment 'Llave Principal - Indicador Operativo',
   ino_id_obo           int not null comment 'Llave Principal - Objetivo Operativo',
   ino_nombre           varchar(100) not null comment 'Nombre del Indicador Operativo',
   ino_forma_calculo    varchar(1000) comment 'Forma de calculo del indicador',
   ino_frecuencia_medicion varchar(1000) comment 'Frecuencia de medición',
   ino_meta             varchar(100) comment 'Meta del indicador',
   ino_estado           int not null comment 'Estado del registro (1- Activo, 0 - Inactivo)',
   ino_usu_creacion     int not null comment 'Auditoria',
   ino_usu_modificacion int not null comment 'Auditoria',
   ino_fecha_creacion   datetime not null comment 'Auditoria',
   ino_fecha_modificacion datetime not null comment 'Auditoria',
   primary key (ino_id)
);

alter table ino_indicador_operativo comment 'Indicador Operativo';

alter table ino_indicador_operativo add constraint fk_ino_id_obo foreign key (ino_id_obo) references obo_objetivo_operativo (obo_id) on delete restrict on update restrict;

drop table if exists rei_responsable_indicador;
/*==============================================================*/
/* Table: rei_responsable_indicador                             */
/*==============================================================*/
create table rei_responsable_indicador
(
   rei_id               int not null auto_increment comment 'Llave Principal - Responsables Indicador Operativo',
   rei_id_plz           int(11) not null comment 'Llave Principal - Plaza',
   rei_id_ino           int not null comment 'Llave Principal - Indicador Operativo',
   rei_estado           int not null comment 'Estado de registro',
   rei_usu_creacion     int not null comment 'Auditoria',
   rei_usu_modificacion int not null comment 'Auditoria',
   rei_fecha_creacion   datetime not null comment 'Auditoria',
   rei_fecha_modificacion datetime not null comment 'Auditoria',
   primary key (rei_id)
);

alter table rei_responsable_indicador add constraint fk_rei_id_ino foreign key (rei_id_ino) references ino_indicador_operativo (ino_id) on delete restrict on update restrict;
alter table rei_responsable_indicador add constraint fk_rei_id_plz foreign key (rei_id_plz) references plz_plaza (plz_id) on delete restrict on update restrict;

ALTER TABLE met_meta_operativa DROP FOREIGN KEY fk_met_id_obo;
ALTER TABLE met_meta_operativa DROP COLUMN met_id_obo;

ALTER TABLE met_meta_operativa
ADD met_id_ino           int comment 'Llave Principal - Indicador Operativo' AFTER met_id_aco;

alter table met_meta_operativa add constraint fk_met_id_ino foreign key (met_id_ino) references ino_indicador_operativo (ino_id) on delete restrict on update restrict;



/* MODIFICAR LAS OPCIONES DE MENU */
SET @ID1 = (SELECT opc_id FROM opc_opcion WHERE opc_funcion = 'meta_operativa' AND opc_padre = 1329);
SET @ID2 = (SELECT opc_id FROM opc_opcion WHERE opc_funcion = 'obj_operativo' AND opc_padre = 1329);
UPDATE opc_opcion SET opc_funcion = 'obj_operativo' WHERE opc_id = @ID1;
DELETE FROM opc_opcion WHERE opc_id = IFNULL(@ID2, 0) LIMIT 1;