SET FOREIGN_KEY_CHECKS = 0;

drop table if exists obo_objetivo_operativo;

/*==============================================================*/
/* Table: obo_objetivo_operativo                                */
/*==============================================================*/
create table obo_objetivo_operativo
(
   obo_id               int not null auto_increment comment 'Llave Principal - Objetivo Operativo',
   obo_id_pxu           int not null comment 'Llave Principal - Plan Operativo por Unidad',
   obo_codigo           varchar(100) not null comment 'Codigo del Objetivo Operativo',
   obo_nombre           varchar(100) not null comment 'Nombre del Objetivo Operativo',
   obo_estado           int not null comment 'Estado del registro',
   obo_usu_creacion     int not null comment 'Auditoria',
   obo_usu_modificacion int not null comment 'Auditoria',
   obo_fecha_creacion   datetime not null comment 'Auditoria',
   obo_fecha_modificacion datetime not null comment 'Auditoria',
   primary key (obo_id)
);

alter table obo_objetivo_operativo comment 'Objetivos Operativos';

alter table obo_objetivo_operativo add constraint fk_obo_id_pxu foreign key (obo_id_pxu)
      references pxu_plan_operativoxunidad (pxu_id) on delete restrict on update restrict;

SET FOREIGN_KEY_CHECKS = 1;
