/* CREAR TABLA DE AJUSTES */
SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;
DROP TABLE IF EXISTS `aju_ajuste_inventario`;
CREATE TABLE `aju_ajuste_inventario`  (
  `aju_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Llave Principal - Ajuste de Inventario',
  `aju_correlativo` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'Correlativo de Ajuste',
  `aju_usu_genera` int(11) NOT NULL COMMENT 'Usuario que genera el ajuste',
  `aju_fecha_ajuste` datetime(0) NOT NULL COMMENT 'Fecha del Ajuste',
  `aju_estado` int(11) NOT NULL COMMENT 'Estado del registro (1 - activo, 0 - Inactivo)',
  `aju_usu_modificacion` int(11) NOT NULL COMMENT 'Auditoria',
  `aju_fecha_modificacion` datetime(0) NOT NULL COMMENT 'auditoria',
  `aju_usu_creacion` int(11) NOT NULL COMMENT 'auditoria',
  `aju_fecha_creacion` datetime(0) NOT NULL COMMENT 'auditoria',
  PRIMARY KEY (`aju_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = latin1 COLLATE = latin1_swedish_ci COMMENT = 'Ajustes de inventario' ROW_FORMAT = Compact;
SET FOREIGN_KEY_CHECKS = 1;


/* CREAR TABLA DE DETALLE DE AJUSTES */
SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;
DROP TABLE IF EXISTS `dea_detalle_ajuste_inv`;
CREATE TABLE `dea_detalle_ajuste_inv`  (
  `dea_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Llave Principal - Detalle de Ajuste',
  `dea_id_aju` int(11) NOT NULL COMMENT 'Llave Principal - Ajuste de Inventario',
  `dea_id_art` int(11) NOT NULL COMMENT 'Llave principal de articulos',
  `dea_cantidad_fisica` decimal(19, 6) NOT NULL COMMENT 'Cantidad Fisica actual',
  `dea_existencia` decimal(19, 6) NOT NULL COMMENT 'Cantidad en existencias',
  `dea_tipo_operacion` int(11) NOT NULL COMMENT 'Tipo de operacion a realizar (1 - Ingreso, 2 - Salida)',
  `dea_procesado` int(11) NOT NULL COMMENT 'Flag que define si se genero el movimiento o no (1 - Si, 0 - No)',
  `dea_estado` int(11) NOT NULL COMMENT 'Estado del registro (1 - activo, 0 - Inactivo)',
  `dea_usu_modificacion` int(11) NOT NULL COMMENT 'Auditoria',
  `dea_fecha_modificacion` datetime(0) NOT NULL COMMENT 'auditoria',
  `dea_usu_creacion` int(11) NOT NULL COMMENT 'auditoria',
  `dea_fecha_creacion` datetime(0) NOT NULL COMMENT 'auditoria',
  PRIMARY KEY (`dea_id`) USING BTREE,
  INDEX `fk_dea_id_aju`(`dea_id_aju`) USING BTREE,
  INDEX `fk_dea_id_art`(`dea_id_art`) USING BTREE,
  CONSTRAINT `fk_dea_id_aju` FOREIGN KEY (`dea_id_aju`) REFERENCES `aju_ajuste_inventario` (`aju_id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_dea_id_art` FOREIGN KEY (`dea_id_art`) REFERENCES `art_articulo` (`art_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = latin1 COLLATE = latin1_swedish_ci COMMENT = 'Detalle de Ajuste de Inventario' ROW_FORMAT = Compact;
SET FOREIGN_KEY_CHECKS = 1;


/* MODIFICAR LA TABLA DE MOVIMIENTOS DE INV */
ALTER TABLE moi_movimiento_inv ADD COLUMN `moi_id_aju` int(255) NULL COMMENT 'Llave Principal - Ajuste de Inventario' AFTER `moi_id_moi_reversa`;


/* AGREGAR OPCION AL MENU */
INSERT INTO opc_opcion(`opc_nombre`, `opc_funcion`, `opc_descripcion`, `opc_padre`, `opc_orden`, `opc_nivel`, `opc_hijo`, `opc_icono`, `opc_color_modulo`, `opc_icono_personalizado`, `opc_imagen_personalizada`, `opc_estado`, `opc_usu_creacion`, `opc_fecha_creacion`, `opc_usu_modificacion`, `opc_fecha_modificacion`, `opc_id_mos`) VALUES ('Ajustes de Inventario', 'ajustes_inventario', 'Reporte de Ajustes de Inventario', 121, NULL, 2, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 0);
