/* AGREGAR TABLA A LA BASE Y LUEGO MODIFICAR LAS OTRAS TABLAS PARA AGREGAR LA NUEVA COLUMNA */
drop table if exists rea_receta_articulo;
/*==============================================================*/
/* Table: rea_receta_articulo                                   */
/*==============================================================*/
create table rea_receta_articulo
(
    rea_id               int(11) not null auto_increment comment 'Llave Principal - Receta por Articulo',
    rea_id_art           int(11) not null comment 'Llave principal de articulos',
    rea_codigo           varchar(100) not null comment 'Codigo de la receta',
    rea_correlativo      int(11) not null comment 'Correlativo de la receta',
    rea_nombre           varchar(100) not null comment 'Nombre de la receta',
    rea_cantidad_producir decimal(19,2) not null comment 'Cantidad a Producir con la receta',
    rea_fecha            datetime not null comment 'Fecha de la Receta',
    rea_defecto          int(11) COMMENT 'Flag de receta por defecto (1 / null - Si, 0 - No)',
    rea_estado           int(11) not null comment 'Estado de registro (1 - Activo, 0 - Inactivo)',
    rea_usu_creacion     int(11) not null comment 'Auditoria',
    rea_fecha_creacion   datetime not null comment 'Auditoria',
    rea_usu_modificacion int(11) not null comment 'Auditoria',
    rea_fecha_modificacion datetime not null comment 'Auditoria',
    primary key (rea_id)
);
alter table rea_receta_articulo comment 'Receta del Producto';
alter table rea_receta_articulo add constraint fk_rea_id_art foreign key (rea_id_art) references art_articulo (art_id) on delete restrict on update restrict;

ALTER TABLE moa_mano_obra_articulo  ADD moa_id_rea           int(11) comment 'Llave Principal - Receta por Articulo' AFTER moa_id_art;
alter table moa_mano_obra_articulo add constraint fk_moa_id_rea foreign key (moa_id_rea) references rea_receta_articulo (rea_id) on delete restrict on update restrict;
	  
ALTER TABLE mpa_materia_prima_articulo  ADD mpa_id_rea           int(11) comment 'Llave Principal - Receta por Articulo' AFTER mpa_id_etp;
alter table mpa_materia_prima_articulo add constraint fk_mpa_id_rea foreign key (mpa_id_rea) references rea_receta_articulo (rea_id) on delete restrict on update restrict;
	  
ALTER TABLE esr_estimacion_articulo  ADD esr_id_rea           int(11) comment 'Llave Principal - Receta por Articulo' AFTER esr_id_esm;
alter table esr_estimacion_articulo add constraint fk_esr_id_rea foreign key (esr_id_rea) references rea_receta_articulo (rea_id) on delete restrict on update restrict;

alter table axo_articuloxorden ADD axo_id_rea           int(11) comment 'Llave Principal - Receta por Articulo' AFTER axo_id_cva;
alter table axo_articuloxorden add constraint fk_axo_id_rea foreign key (axo_id_rea) references rea_receta_articulo (rea_id) on delete restrict on update restrict;


/* LUEGO MIGRAR LOS PRODUCTOS QUE YA POSEEN RECETA A LA NUEVA TABLA Y ACTUALIZAR LA LLAVE FORANEA */
INSERT INTO rea_receta_articulo (rea_id_art, rea_codigo, rea_correlativo, rea_nombre, rea_cantidad_producir, rea_fecha, rea_defecto, rea_estado, rea_usu_creacion, rea_fecha_creacion,
    rea_usu_modificacion,   rea_fecha_modificacion) SELECT art_id, CONCAT(art_codigo,'-001'), 1, 'Receta por defecto', 1, NOW(), 1, 1, 1, NOW(), 1, NOW() FROM art_articulo 
INNER JOIN mpa_materia_prima_articulo on mpa_id_art = art_id GROUP BY art_id ORDER BY art_id;

UPDATE mpa_materia_prima_articulo SET mpa_id_rea = (SELECT rea_id FROM rea_receta_articulo WHERE rea_id_art = mpa_id_art AND rea_defecto = 1);
UPDATE moa_mano_obra_articulo SET moa_id_rea = (SELECT rea_id FROM rea_receta_articulo WHERE rea_id_art = moa_id_art AND rea_defecto = 1);
UPDATE esr_estimacion_articulo SET esr_id_rea = (SELECT rea_id FROM rea_receta_articulo WHERE rea_id_art = esr_id_art AND rea_defecto = 1);