/* CREAR LAS TABLAS EN BASE */

/*==============================================================*/
/* Table: vao_variable_constancia                               */
/*==============================================================*/
drop table if exists vao_variable_constancia;
create table vao_variable_constancia(
    vao_id               int(11) not null auto_increment comment 'Llave Principal - Variable de Constancia',
    vao_nombre           varchar(100) not null comment 'Nombre de variable de constancia',
    vao_descripcion      varchar(1000) not null comment 'Descripción de la variable',
    vao_estado           tinyint(4) not null comment 'Estado del registro',
    vao_usu_creacion     int(11) not null comment 'Auditoria',
    vao_fecha_creacion   datetime not null comment 'Auditoria',
    vao_usu_modificacion int(11) not null comment 'Auditoria',
    vao_fecha_modificacion datetime not null comment 'Auditoria',
    primary key (vao_id)
);
alter table vao_variable_constancia comment 'Catalogo de Variables de constancia';

/*==============================================================*/
/* Table: tpo_tipo_constancia                                   */
/*==============================================================*/
drop table if exists tpo_tipo_constancia;
create table tpo_tipo_constancia(
    tpo_id               int(11) not null auto_increment comment 'Llave Principal - Tipo de Formato de constancia',
    tpo_nombre           varchar(100) comment 'Nombre del tipo de constancia',
    tpo_descripcion      varchar(1000) comment 'Descripción del tipo de constancia',
    tpo_estado           tinyint(4) not null comment 'Estado del Registro',
    tpo_usu_creacion     int(11) not null comment 'Auditoria',
    tpo_fecha_creacion   datetime not null comment 'Auditoria',
    tpo_usu_modificacion int(11) not null comment 'Auditoria',
    tpo_fecha_modificacion datetime not null comment 'Auditoria',
    primary key (tpo_id)
);
alter table tpo_tipo_constancia comment 'Catalogo de Tipo de Constancias ';

/*==============================================================*/
/* Table: vxt_variablextipo_constancia                          */
/*==============================================================*/
drop table if exists vxt_variablextipo_constancia;
create table vxt_variablextipo_constancia(
    vxt_id               int(11) not null auto_increment comment 'Llave Principal - Variable por Tipo de Constancia',
    vxt_id_tpo           int(11) not null comment 'Llave Principal - Tipo de Formato de constancia',
    vxt_id_vao           int(11) not null comment 'Llave Principal - Variable de Constancia',
    vxt_estado           tinyint(4) not null comment 'Estado del registro',
    vxt_usu_creacion     int(11) not null comment 'Auditoria',
    vxt_fecha_creacion   datetime not null comment 'Auditoria',
    vxt_usu_modificacion int(11) not null comment 'Auditoria',
    vxt_fecha_modificacion datetime not null comment 'Auditoria',
    primary key (vxt_id)
);
alter table vxt_variablextipo_constancia comment 'Catalogo de Variables de constancia';
alter table vxt_variablextipo_constancia add constraint fk_vxt_id_tpo foreign key (vxt_id_tpo)
      references tpo_tipo_constancia (tpo_id) on delete restrict on update restrict;
alter table vxt_variablextipo_constancia add constraint fk_vxt_id_vao foreign key (vxt_id_vao)
      references vao_variable_constancia (vao_id) on delete restrict on update restrict;

/*==============================================================*/
/* Table: fre_formato_constancia_empleado                       */
/*==============================================================*/
drop table if exists fre_formato_constancia_empleado;
create table fre_formato_constancia_empleado(
    fre_id               int(11) not null auto_increment comment 'Llave Principal - Formato Constancia Empleado',
    fre_id_tpo           int(11) not null comment 'Llave Principal - Tipo de Formato de constancia',
    fre_nombre           varchar(300) not null comment 'Nombre',
    fre_descripcion      varchar(500) comment 'Descripción del registro',
    fre_configuraciones_formato text comment 'Configuraciones diversas al formato(json)',
    fre_archivo          national varchar(300) not null comment 'Nombre archivo php de la vista del formato',
    fre_estado           tinyint(4) not null comment 'Estado del registro (1 - Activo, 0 - Inactivo)',
    fre_usu_creacion     int(11) not null comment 'Auditoria',
    fre_fecha_creacion   datetime not null comment 'Auditoria',
    fre_usu_modificacion int(11) not null comment 'Auditoria',
    fre_fecha_modificacion datetime not null comment 'Auditoria',
    primary key (fre_id)
);
alter table fre_formato_constancia_empleado comment 'Configuración de Formatos de constancias en registro académi';
alter table fre_formato_constancia_empleado add constraint fk_fre_id_tpo foreign key (fre_id_tpo)
      references tpo_tipo_constancia (tpo_id) on delete restrict on update restrict;

/*==============================================================*/
/* Table: txr_tipo_constanciaxempresa                           */
/*==============================================================*/
drop table if exists txr_tipo_constanciaxempresa;
create table txr_tipo_constanciaxempresa(
    txr_id               int(11) not null auto_increment comment 'Llave Principal - Tipo de constancia por empresa',
    txr_id_tpo           int(11) comment 'Llave Principal - Tipo de Formato de constancia',
    txr_id_emr           int(11) comment 'Llave principal de empresa',
    txr_estado           tinyint(4) not null comment 'Estado del registro',
    txr_usu_creacion     int(11) not null comment 'Auditoria',
    txr_fecha_creacion   datetime not null comment 'Auditoria',
    txr_usu_modificacion int(11) not null comment 'Auditoria',
    txr_fecha_modificacion datetime not null comment 'Auditoria',
    primary key (txr_id)
);
alter table txr_tipo_constanciaxempresa comment 'Vínculación de empresas por areas';
alter table txr_tipo_constanciaxempresa add constraint fk_txr_id_emr foreign key (txr_id_emr)
      references emr_empresa (emr_id) on delete restrict on update restrict;
alter table txr_tipo_constanciaxempresa add constraint fk_txr_id_tpo foreign key (txr_id_tpo)
      references tpo_tipo_constancia (tpo_id) on delete restrict on update restrict;


/* AGREGAR LOS TIPOS DE CONSTANCIAS SE DEJAN QUEMADOS LOS PRIMEROS IDs PARA PRUEBAS */
INSERT INTO tpo_tipo_constancia(tpo_id, tpo_nombre, tpo_descripcion, tpo_estado, tpo_usu_creacion, tpo_fecha_creacion, tpo_usu_modificacion, tpo_fecha_modificacion) VALUES (1, 'Constancia de Trabajo Empleados Activos', 'Constancia de Trabajo Empleados Activos', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO tpo_tipo_constancia(tpo_id, tpo_nombre, tpo_descripcion, tpo_estado, tpo_usu_creacion, tpo_fecha_creacion, tpo_usu_modificacion, tpo_fecha_modificacion) VALUES (2, 'Constancia de Trabajo Empleados Inactivos', 'Constancia de Trabajo Empleados Inactivos', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO tpo_tipo_constancia(tpo_id, tpo_nombre, tpo_descripcion, tpo_estado, tpo_usu_creacion, tpo_fecha_creacion, tpo_usu_modificacion, tpo_fecha_modificacion) VALUES (3, 'Constancia de Retención de Renta', 'Constancia de Retención de Renta', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO tpo_tipo_constancia(tpo_id, tpo_nombre, tpo_descripcion, tpo_estado, tpo_usu_creacion, tpo_fecha_creacion, tpo_usu_modificacion, tpo_fecha_modificacion) VALUES (4, 'Constancia de Ingresos, Deducciones y Renta Anual', 'Constancia de Ingresos, Deducciones y Renta Anual', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO tpo_tipo_constancia(tpo_id, tpo_nombre, tpo_descripcion, tpo_estado, tpo_usu_creacion, tpo_fecha_creacion, tpo_usu_modificacion, tpo_fecha_modificacion) VALUES (5, 'Constancia de Recomendación', 'Constancia de Recomendación', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO tpo_tipo_constancia(tpo_id, tpo_nombre, tpo_descripcion, tpo_estado, tpo_usu_creacion, tpo_fecha_creacion, tpo_usu_modificacion, tpo_fecha_modificacion) VALUES (6, 'Constancia de Sueldo según Ficha', 'Constancia de Sueldo según Ficha de empleado', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');


/* CREAR LAS CONFIGURACIONES QUE EL USUARIO PUEDE EDITAR PARA CADA TIPO DE CONSTANCIA */
INSERT INTO fre_formato_constancia_empleado(fre_id_tpo,fre_nombre,fre_archivo,fre_estado,fre_usu_creacion,fre_fecha_creacion,fre_usu_modificacion,fre_fecha_modificacion) VALUES (1, 'Constancia de Trabajo Empleados Activos',' ', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO fre_formato_constancia_empleado(fre_id_tpo,fre_nombre,fre_archivo,fre_estado,fre_usu_creacion,fre_fecha_creacion,fre_usu_modificacion,fre_fecha_modificacion) VALUES (2, 'Constancia de Trabajo Empleados Inactivos',' ', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO fre_formato_constancia_empleado(fre_id_tpo,fre_nombre,fre_archivo,fre_estado,fre_usu_creacion,fre_fecha_creacion,fre_usu_modificacion,fre_fecha_modificacion) VALUES (3, 'Constancia de Retención de Renta',' ', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO fre_formato_constancia_empleado(fre_id_tpo,fre_nombre,fre_archivo,fre_estado,fre_usu_creacion,fre_fecha_creacion,fre_usu_modificacion,fre_fecha_modificacion) VALUES (4, 'Constancia de Ingresos, Deducciones y Renta Anual',' ', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO fre_formato_constancia_empleado(fre_id_tpo,fre_nombre,fre_archivo,fre_estado,fre_usu_creacion,fre_fecha_creacion,fre_usu_modificacion,fre_fecha_modificacion) VALUES (5, 'Constancia de Recomendación',' ', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO fre_formato_constancia_empleado(fre_id_tpo,fre_nombre,fre_archivo,fre_estado,fre_usu_creacion,fre_fecha_creacion,fre_usu_modificacion,fre_fecha_modificacion) VALUES (6, 'Constancia de Sueldo según Ficha',' ', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');


/* CREAR EL REPERTORIO DE POSIBLES VARIABLES A UTILIZAR EN LAS CONSTANCIAS SE DEJAN QUEMADOS LOS PRIMEROS IDs PARA PRUEBAS */
INSERT INTO vao_variable_constancia(vao_id, vao_nombre, vao_descripcion, vao_estado, vao_usu_creacion, vao_fecha_creacion, vao_usu_modificacion, vao_fecha_modificacion) VALUES (1, 'año_actual', 'Fecha actual (date(\'Y\'))', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vao_variable_constancia(vao_id, vao_nombre, vao_descripcion, vao_estado, vao_usu_creacion, vao_fecha_creacion, vao_usu_modificacion, vao_fecha_modificacion) VALUES (2, 'año_fecha_contratacion', 'Año de la fecha de contratacion (date(\'Y\'))', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vao_variable_constancia(vao_id, vao_nombre, vao_descripcion, vao_estado, vao_usu_creacion, vao_fecha_creacion, vao_usu_modificacion, vao_fecha_modificacion) VALUES (3, 'año_letras_actual', 'Año de la fecha actual en letras', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vao_variable_constancia(vao_id, vao_nombre, vao_descripcion, vao_estado, vao_usu_creacion, vao_fecha_creacion, vao_usu_modificacion, vao_fecha_modificacion) VALUES (4, 'dia_actual', 'Dia de la fecha actual (date(\'d\'))', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vao_variable_constancia(vao_id, vao_nombre, vao_descripcion, vao_estado, vao_usu_creacion, vao_fecha_creacion, vao_usu_modificacion, vao_fecha_modificacion) VALUES (5, 'dia_fecha_contratacion', 'Dia de la fecha de contratacion (date(\'d\'))', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vao_variable_constancia(vao_id, vao_nombre, vao_descripcion, vao_estado, vao_usu_creacion, vao_fecha_creacion, vao_usu_modificacion, vao_fecha_modificacion) VALUES (6, 'dia_letras_actual', 'Dia de la fecha actual en letras', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vao_variable_constancia(vao_id, vao_nombre, vao_descripcion, vao_estado, vao_usu_creacion, vao_fecha_creacion, vao_usu_modificacion, vao_fecha_modificacion) VALUES (7, 'fecha_actual', 'Fecha actual (date())', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vao_variable_constancia(vao_id, vao_nombre, vao_descripcion, vao_estado, vao_usu_creacion, vao_fecha_creacion, vao_usu_modificacion, vao_fecha_modificacion) VALUES (8, 'fecha_contratacion', 'Fecha de Contratacion empleado (tabla emp_empleado)', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vao_variable_constancia(vao_id, vao_nombre, vao_descripcion, vao_estado, vao_usu_creacion, vao_fecha_creacion, vao_usu_modificacion, vao_fecha_modificacion) VALUES (9, 'mes_actual', 'Mes de la fecha actual (date(\'m\'))', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vao_variable_constancia(vao_id, vao_nombre, vao_descripcion, vao_estado, vao_usu_creacion, vao_fecha_creacion, vao_usu_modificacion, vao_fecha_modificacion) VALUES (10, 'mes_fecha_contratacion', 'Mes de la fecha de contratacion (date(\'m\'))', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vao_variable_constancia(vao_id, vao_nombre, vao_descripcion, vao_estado, vao_usu_creacion, vao_fecha_creacion, vao_usu_modificacion, vao_fecha_modificacion) VALUES (11, 'mes_letras_actual', 'Mes de la fecha actual en letras', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vao_variable_constancia(vao_id, vao_nombre, vao_descripcion, vao_estado, vao_usu_creacion, vao_fecha_creacion, vao_usu_modificacion, vao_fecha_modificacion) VALUES (12, 'nombre_cargo', 'Nombre de la plaza (tabla plz_plaza)', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vao_variable_constancia(vao_id, vao_nombre, vao_descripcion, vao_estado, vao_usu_creacion, vao_fecha_creacion, vao_usu_modificacion, vao_fecha_modificacion) VALUES (13, 'nombre_empleado', 'Nombre del empleado (tabla emp_empleado)', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vao_variable_constancia(vao_id, vao_nombre, vao_descripcion, vao_estado, vao_usu_creacion, vao_fecha_creacion, vao_usu_modificacion, vao_fecha_modificacion) VALUES (14, 'año_fecha_retiro', 'Año de la fecha de retiro (date(\'Y\'))', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vao_variable_constancia(vao_id, vao_nombre, vao_descripcion, vao_estado, vao_usu_creacion, vao_fecha_creacion, vao_usu_modificacion, vao_fecha_modificacion) VALUES (15, 'dia_fecha_retiro', 'Dia de la fecha de retiro (date(\'d\'))', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vao_variable_constancia(vao_id, vao_nombre, vao_descripcion, vao_estado, vao_usu_creacion, vao_fecha_creacion, vao_usu_modificacion, vao_fecha_modificacion) VALUES (16, 'fecha_retiro', 'Fecha de retiro (tabla emp_empleado)', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vao_variable_constancia(vao_id, vao_nombre, vao_descripcion, vao_estado, vao_usu_creacion, vao_fecha_creacion, vao_usu_modificacion, vao_fecha_modificacion) VALUES (17, 'mes_fecha_retiro', 'Mes de la fecha de retiro (date(\'m\'))', 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');



/* ASIGNAR LAS VARIABLES QUE PUEDE ACCESAR CADA TIPO DE CONSTANCIA */
INSERT INTO vxt_variablextipo_constancia(vxt_id_tpo, vxt_id_vao, vxt_estado, vxt_usu_creacion, vxt_fecha_creacion, vxt_usu_modificacion, vxt_fecha_modificacion) VALUES (1, 1, 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vxt_variablextipo_constancia(vxt_id_tpo, vxt_id_vao, vxt_estado, vxt_usu_creacion, vxt_fecha_creacion, vxt_usu_modificacion, vxt_fecha_modificacion) VALUES (1, 2, 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vxt_variablextipo_constancia(vxt_id_tpo, vxt_id_vao, vxt_estado, vxt_usu_creacion, vxt_fecha_creacion, vxt_usu_modificacion, vxt_fecha_modificacion) VALUES (1, 3, 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vxt_variablextipo_constancia(vxt_id_tpo, vxt_id_vao, vxt_estado, vxt_usu_creacion, vxt_fecha_creacion, vxt_usu_modificacion, vxt_fecha_modificacion) VALUES (1, 4, 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vxt_variablextipo_constancia(vxt_id_tpo, vxt_id_vao, vxt_estado, vxt_usu_creacion, vxt_fecha_creacion, vxt_usu_modificacion, vxt_fecha_modificacion) VALUES (1, 5, 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vxt_variablextipo_constancia(vxt_id_tpo, vxt_id_vao, vxt_estado, vxt_usu_creacion, vxt_fecha_creacion, vxt_usu_modificacion, vxt_fecha_modificacion) VALUES (1, 6, 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vxt_variablextipo_constancia(vxt_id_tpo, vxt_id_vao, vxt_estado, vxt_usu_creacion, vxt_fecha_creacion, vxt_usu_modificacion, vxt_fecha_modificacion) VALUES (1, 7, 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vxt_variablextipo_constancia(vxt_id_tpo, vxt_id_vao, vxt_estado, vxt_usu_creacion, vxt_fecha_creacion, vxt_usu_modificacion, vxt_fecha_modificacion) VALUES (1, 8, 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vxt_variablextipo_constancia(vxt_id_tpo, vxt_id_vao, vxt_estado, vxt_usu_creacion, vxt_fecha_creacion, vxt_usu_modificacion, vxt_fecha_modificacion) VALUES (1, 9, 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vxt_variablextipo_constancia(vxt_id_tpo, vxt_id_vao, vxt_estado, vxt_usu_creacion, vxt_fecha_creacion, vxt_usu_modificacion, vxt_fecha_modificacion) VALUES (1, 10, 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vxt_variablextipo_constancia(vxt_id_tpo, vxt_id_vao, vxt_estado, vxt_usu_creacion, vxt_fecha_creacion, vxt_usu_modificacion, vxt_fecha_modificacion) VALUES (1, 11, 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vxt_variablextipo_constancia(vxt_id_tpo, vxt_id_vao, vxt_estado, vxt_usu_creacion, vxt_fecha_creacion, vxt_usu_modificacion, vxt_fecha_modificacion) VALUES (1, 12, 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vxt_variablextipo_constancia(vxt_id_tpo, vxt_id_vao, vxt_estado, vxt_usu_creacion, vxt_fecha_creacion, vxt_usu_modificacion, vxt_fecha_modificacion) VALUES (1, 13, 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vxt_variablextipo_constancia(vxt_id_tpo, vxt_id_vao, vxt_estado, vxt_usu_creacion, vxt_fecha_creacion, vxt_usu_modificacion, vxt_fecha_modificacion) VALUES (2, 1, 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vxt_variablextipo_constancia(vxt_id_tpo, vxt_id_vao, vxt_estado, vxt_usu_creacion, vxt_fecha_creacion, vxt_usu_modificacion, vxt_fecha_modificacion) VALUES (2, 2, 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vxt_variablextipo_constancia(vxt_id_tpo, vxt_id_vao, vxt_estado, vxt_usu_creacion, vxt_fecha_creacion, vxt_usu_modificacion, vxt_fecha_modificacion) VALUES (2, 3, 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vxt_variablextipo_constancia(vxt_id_tpo, vxt_id_vao, vxt_estado, vxt_usu_creacion, vxt_fecha_creacion, vxt_usu_modificacion, vxt_fecha_modificacion) VALUES (2, 4, 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vxt_variablextipo_constancia(vxt_id_tpo, vxt_id_vao, vxt_estado, vxt_usu_creacion, vxt_fecha_creacion, vxt_usu_modificacion, vxt_fecha_modificacion) VALUES (2, 5, 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vxt_variablextipo_constancia(vxt_id_tpo, vxt_id_vao, vxt_estado, vxt_usu_creacion, vxt_fecha_creacion, vxt_usu_modificacion, vxt_fecha_modificacion) VALUES (2, 6, 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vxt_variablextipo_constancia(vxt_id_tpo, vxt_id_vao, vxt_estado, vxt_usu_creacion, vxt_fecha_creacion, vxt_usu_modificacion, vxt_fecha_modificacion) VALUES (2, 7, 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vxt_variablextipo_constancia(vxt_id_tpo, vxt_id_vao, vxt_estado, vxt_usu_creacion, vxt_fecha_creacion, vxt_usu_modificacion, vxt_fecha_modificacion) VALUES (2, 8, 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vxt_variablextipo_constancia(vxt_id_tpo, vxt_id_vao, vxt_estado, vxt_usu_creacion, vxt_fecha_creacion, vxt_usu_modificacion, vxt_fecha_modificacion) VALUES (2, 9, 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vxt_variablextipo_constancia(vxt_id_tpo, vxt_id_vao, vxt_estado, vxt_usu_creacion, vxt_fecha_creacion, vxt_usu_modificacion, vxt_fecha_modificacion) VALUES (2, 10, 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vxt_variablextipo_constancia(vxt_id_tpo, vxt_id_vao, vxt_estado, vxt_usu_creacion, vxt_fecha_creacion, vxt_usu_modificacion, vxt_fecha_modificacion) VALUES (2, 11, 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vxt_variablextipo_constancia(vxt_id_tpo, vxt_id_vao, vxt_estado, vxt_usu_creacion, vxt_fecha_creacion, vxt_usu_modificacion, vxt_fecha_modificacion) VALUES (2, 12, 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vxt_variablextipo_constancia(vxt_id_tpo, vxt_id_vao, vxt_estado, vxt_usu_creacion, vxt_fecha_creacion, vxt_usu_modificacion, vxt_fecha_modificacion) VALUES (2, 13, 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vxt_variablextipo_constancia(vxt_id_tpo, vxt_id_vao, vxt_estado, vxt_usu_creacion, vxt_fecha_creacion, vxt_usu_modificacion, vxt_fecha_modificacion) VALUES (2, 14, 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vxt_variablextipo_constancia(vxt_id_tpo, vxt_id_vao, vxt_estado, vxt_usu_creacion, vxt_fecha_creacion, vxt_usu_modificacion, vxt_fecha_modificacion) VALUES (2, 15, 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vxt_variablextipo_constancia(vxt_id_tpo, vxt_id_vao, vxt_estado, vxt_usu_creacion, vxt_fecha_creacion, vxt_usu_modificacion, vxt_fecha_modificacion) VALUES (2, 16, 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO vxt_variablextipo_constancia(vxt_id_tpo, vxt_id_vao, vxt_estado, vxt_usu_creacion, vxt_fecha_creacion, vxt_usu_modificacion, vxt_fecha_modificacion) VALUES (2, 17, 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');



/* DEFINIR CUALES TIPOS SE MOSTRARAN EN CADA EMPRESA */
/* ASEGURESE DE VERIFICAR EL ID DE LA EMPRESA EN CASO HAYA MAS DE 1 */
/* CARGA#1 TIPO DE CONSTANCIA 1 Y 2*/
INSERT INTO txr_tipo_constanciaxempresa(txr_id_tpo, txr_id_emr, txr_estado, txr_usu_creacion, txr_fecha_creacion, txr_usu_modificacion, txr_fecha_modificacion) VALUES (1, 1, 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');
INSERT INTO txr_tipo_constanciaxempresa(txr_id_tpo, txr_id_emr, txr_estado, txr_usu_creacion, txr_fecha_creacion, txr_usu_modificacion, txr_fecha_modificacion) VALUES (2, 1, 1, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00');


/* AGREGAR LAS OPCIONES AL MENU */
/* MANTENIMIENTO */
INSERT INTO opc_opcion(opc_nombre, opc_funcion, opc_descripcion, opc_padre, opc_orden, opc_nivel, opc_hijo, opc_icono, opc_color_modulo, opc_icono_personalizado, opc_imagen_personalizada, opc_estado, opc_usu_creacion, opc_fecha_creacion, opc_usu_modificacion, opc_fecha_modificacion, opc_id_mos) 
    VALUES ('Texto Constancias', 'cuerpo_constancia', 'Mantenimiento del texto personalizado de constancias', 194, NULL, 2, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 0);
/* REPORTES */
INSERT INTO opc_opcion(opc_nombre, opc_funcion, opc_descripcion, opc_padre, opc_orden, opc_nivel, opc_hijo, opc_icono, opc_color_modulo, opc_icono_personalizado, opc_imagen_personalizada, opc_estado, opc_usu_creacion, opc_fecha_creacion, opc_usu_modificacion, opc_fecha_modificacion, opc_id_mos) 
    VALUES ('Const. Personalizadas', 'constancia_personalizada', 'Impresion de constancias con texto personalizado', 188, NULL, 2, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 0);