/* ADICIONAR TABLA A LA BASE  */
SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;
-- ----------------------------
-- Table structure for edn_educacion_concurso_plaza
-- ----------------------------
DROP TABLE IF EXISTS `edn_educacion_concurso_plaza`;
CREATE TABLE `edn_educacion_concurso_plaza`  (
	`edn_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Llave primaria - Educacion por concurso Plaza',
	`edn_id_tie` int(11) NOT NULL COMMENT 'Llave primaria - tipo de educación',
	`edn_id_cnp` int(11) NOT NULL COMMENT 'Llave principal de concurso de plaza',
	`edn_estado` int(11) NOT NULL COMMENT 'Estado de registro',
	`edn_usu_creacion` int(11) NOT NULL COMMENT 'Auditoría',
	`edn_fecha_creacion` datetime(0) NOT NULL COMMENT 'Auditoría',
	`edn_usu_modificacion` int(11) NOT NULL COMMENT 'Auditoría',
	`edn_fecha_modificacion` datetime(0) NOT NULL COMMENT 'Auditoría',
	PRIMARY KEY (`edn_id`) USING BTREE,
	INDEX `fk_edn_id_cnp`(`edn_id_cnp`) USING BTREE,
	INDEX `fk_edn_id_tie`(`edn_id_tie`) USING BTREE,
	CONSTRAINT `fk_edn_id_cnp` FOREIGN KEY (`edn_id_cnp`) REFERENCES `cnp_concurso_plaza` (`cnp_id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
	CONSTRAINT `fk_edn_id_tie` FOREIGN KEY (`edn_id_tie`) REFERENCES `tie_tipo_educacion` (`tie_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = latin1 COLLATE = latin1_swedish_ci COMMENT = 'Tabla de Educación por Concurso Plaza' ROW_FORMAT = Compact;

SET FOREIGN_KEY_CHECKS = 1;