/* PORCENTAJE DE PARTICIPACION EN ACCIONISTA NO ES REQUERIDO */
ALTER TABLE acn_accionista MODIFY COLUMN `acn_porcentaje` decimal(19, 2) NULL COMMENT 'Porcentaje de participación' AFTER `acn_nombre`;

/* ESTANDARIZAR NOMBRE DE OPCION ACCIONISTAS */
SET @ID = (SELECT opc_id FROM opc_opcion WHERE opc_funcion = 'registro_accionistas');
UPDATE opc_opcion SET `opc_nombre` = 'Registro de Accionistas', `opc_descripcion` = 'Gestión de accionistas' WHERE `opc_id` = @ID;

/* AGREGAR OPCIONES AL MENU */
INSERT INTO opc_opcion(
	`opc_nombre`, `opc_funcion`, `opc_descripcion`, `opc_padre`, `opc_orden`, `opc_nivel`, `opc_hijo`, 
	`opc_icono`, `opc_color_modulo`, `opc_icono_personalizado`, `opc_imagen_personalizada`, `opc_estado`, 
	`opc_usu_creacion`, `opc_fecha_creacion`, `opc_usu_modificacion`, `opc_fecha_modificacion`, `opc_id_mos`
) VALUES ('Miembros de CCSJ', 'registro_miembro_jd', 'Miembros de CCSJ', 177, 4, 2, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 0);

INSERT INTO opc_opcion(
	`opc_nombre`, `opc_funcion`, `opc_descripcion`, `opc_padre`, `opc_orden`, `opc_nivel`, `opc_hijo`, 
	`opc_icono`, `opc_color_modulo`, `opc_icono_personalizado`, `opc_imagen_personalizada`, `opc_estado`, 
	`opc_usu_creacion`, `opc_fecha_creacion`, `opc_usu_modificacion`, `opc_fecha_modificacion`, `opc_id_mos`
) VALUES ('Miembros J. D.', 'consulta_miembros_jd', 'Consultar Miembros de Junta Directiva', 178, NULL, 2, 0, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 0);

/* AGREGAR LAS NUEVAS TABLAS*/
drop table if exists mij_miembro_junta;

/*==============================================================*/
/* Table: mij_miembro_junta                                     */
/*==============================================================*/
create table mij_miembro_junta
(
   mij_id               int(11) not null auto_increment comment 'Llave principal de Accionista',
   mij_id_emr           int(11) comment 'Llave principal de empresa',
   mij_id_pto           int(11) comment 'Llave principal de puesto',
   mij_nombre           national varchar(300) not null comment 'Nombre del  Titular',
   mij_documento_dui    varchar(300) comment 'Documento dui',
   mij_documento_nit    varchar(300) comment 'Documento nit',
   mij_direccion_contacto varchar(500) comment 'Dirección de Contacto',
   mij_periodo_inicio   datetime comment 'Fecha inicio del miembro',
   mij_periodo_fin      datetime comment 'Fecha Fin del miembro',
   mij_telefono_contacto varchar(100) comment 'Telefono de contacto',
   mij_correo_contacto  varchar(100) comment 'Correo de Contacto',
   mij_estado           tinyint(4) not null comment 'Estado del registro 1=Activo, 0=Inactivo',
   mij_usu_creacion     int(11) not null comment 'auditoria',
   mij_fecha_creacion   datetime not null comment 'auditoria',
   mij_usu_modificacion int(11) not null comment 'auditoria',
   mij_fecha_modificacion datetime not null comment 'auditoria',
   primary key (mij_id)
);

alter table mij_miembro_junta comment 'Accionistas';

alter table mij_miembro_junta add constraint fk_mij_id_emr foreign key (mij_id_emr)
      references emr_empresa (emr_id) on delete restrict on update restrict;

alter table mij_miembro_junta add constraint fk_mij_id_pto foreign key (mij_id_pto)
      references pto_puesto (pto_id) on delete restrict on update restrict;

drop table if exists asm_asistente_miembro;

/*==============================================================*/
/* Table: asm_asistente_miembro                                 */
/*==============================================================*/
create table asm_asistente_miembro
(
   asm_id               int(11) not null auto_increment comment 'Llave principal de Asistente Miembro Junta',
   asm_id_mij           int(11) not null comment 'Llave principal de Accionista',
   asm_nombre           national varchar(300) not null comment 'Nombre del  Titular',
   asm_telefono_contacto varchar(100) comment 'Telefono de contacto',
   asm_estado           tinyint(4) not null comment 'Estado del registro 1=Activo, 0=Inactivo',
   asm_usu_creacion     int(11) not null comment 'auditoria',
   asm_fecha_creacion   datetime not null comment 'auditoria',
   asm_usu_modificacion int(11) not null comment 'auditoria',
   asm_fecha_modificacion datetime not null comment 'auditoria',
   primary key (asm_id)
);

alter table asm_asistente_miembro comment 'Asistente de miembro de junta';

alter table asm_asistente_miembro add constraint fk_asm_id_mij foreign key (asm_id_mij)
      references mij_miembro_junta (mij_id) on delete restrict on update restrict;
