ALTER TABLE
exo_etapaxarticulo_orden
add COLUMN exo_duracion_mano_obra decimal(19,2) comment 'Duración/horas mano de obra' after exo_duracion;


ALTER TABLE mob_mano_obra 
add COLUMN mob_calculado        int(11) comment 'es calculado 1=si, 0 o null = no' after mob_precio;

ALTER TABLE mob_mano_obra
add COLUMN mob_total_hora       decimal(19,2) comment 'Total horas' after mob_calculado;

ALTER table mob_mano_obra
add COLUMN mob_usu_crea         int(11) comment 'Auditoria' after mob_estado;

ALTER TABLE mob_mano_obra
add COLUMN  mob_fecha_crea       datetime comment 'Auditoria' after mob_usu_crea;


drop table if exists dec_detalle_calculo;

/*==============================================================*/
/* Table: dec_detalle_calculo                                   */
/*==============================================================*/
create table dec_detalle_calculo
(
   dec_id               int(11) not null auto_increment comment 'Llave primaria de detalle de calculo',
   dec_id_mob           int(11) not null comment 'Identificador de la Mano de obra',
   dec_nombre           varchar(300) comment 'Nombre',
   dec_monto            decimal(19,6) not null comment 'Precio de mano de obra',
   dec_estado           int(11) not null comment 'Estado de registro',
   dec_usu_creacion     int(11) not null comment 'Auditoria',
   dec_fecha_creacion   datetime not null comment 'Auditoria',
   dec_usu_modificacion int(11) not null comment 'Auditoria',
   dec_fecha_modificacion datetime not null comment 'Auditoria',
   primary key (dec_id)
);

alter table dec_detalle_calculo comment 'Detalle de calculo';

alter table dec_detalle_calculo add constraint fk_dec_id_mob foreign key (dec_id_mob)
      references mob_mano_obra (mob_id) on delete restrict on update restrict;


ALTER table esm_estimacion
add COLUMN esm_calculado        int(11) comment 'es calculado 1=si, 0 o null = no' after esm_tipo_calculo;

ALTER table esm_estimacion
add COLUMN esm_total_hora       decimal(19,6) comment 'total hora' after esm_calculado;



drop table if exists dxe_detallexestimacion;

/*==============================================================*/
/* Table: dxe_detallexestimacion                                */
/*==============================================================*/
create table dxe_detallexestimacion
(
   dxe_id               int(11) not null auto_increment comment 'Llave primaria de detalle de calculo por estimacion',
   dxe_id_esm           int(11) comment 'Identificador de la estimacion',
   dxe_nombre           varchar(300) comment 'Nombre',
   dxe_monto            decimal(19,6) not null comment 'Precio de mano de obra',
   dxe_estado           int(11) not null comment 'Estado de registro',
   dxe_usu_creacion     int(11) not null comment 'Auditoria',
   dxe_fecha_creacion   datetime not null comment 'Auditoria',
   dxe_usu_modificacion int(11) not null comment 'Auditoria',
   dxe_fecha_modificacion datetime not null comment 'Auditoria',
   primary key (dxe_id)
);

alter table dxe_detallexestimacion comment 'Detalle de calculo por  estimacion';

alter table dxe_detallexestimacion add constraint fk_dxe_id_esm foreign key (dxe_id_esm)
      references esm_estimacion (esm_id) on delete restrict on update restrict;


UPDATE opc_opcion SET opc_nombre = 'Gastos Indirectos de Fabricación', opc_funcion = 'estimacion', opc_descripcion = 'Mantenimiento de Gastos Indirectos de Fabricación', opc_padre = 302, opc_orden = 14, opc_nivel = 2, opc_hijo = 1, opc_icono = NULL, opc_icono_personalizado = NULL, opc_imagen_personalizada = NULL, opc_estado = 1, opc_usu_creacion = NULL, opc_fecha_creacion = NULL, opc_usu_modificacion = NULL, opc_fecha_modificacion = NULL, opc_id_mos = 0 WHERE opc_id = 316;