drop table if exists dpp_detalle_programacion_produccion;

/*==============================================================*/
/* Table: dpp_detalle_programacion_produccion                   */
/*==============================================================*/
create table dpp_detalle_programacion_produccion
(
   dpp_id               int(11) not null auto_increment comment 'Llave principal de detalle de planificacion',
   dpp_id_ppd           int(11) not null comment 'Llave principal de Programacion de produccion',
   dpp_id_art           int(11) comment 'Llave principal de articulos',
   dpp_id_cva           int(11) comment 'llave principal de conversin artculo',
   dpp_id_ord           int(11) comment 'Codigo de la orden',
   dpp_fecha_inicio     datetime comment 'Fecha de inicio',
   dpp_prioridad        int(11) comment 'Prioridad',
   dpp_cantidad_orden   decimal(19,6) comment 'Cantidad para la orden',
   dpp_referencia       national varchar(300) comment 'Referencia',
   dpp_observacion      national varchar(500) comment 'Observacion',
   dpp_estado           tinyint(4) not null comment 'estado del registro 1=activo, 0=inactivo',
   dpp_usu_creacion     int(11) not null comment 'Auditoria',
   dpp_fecha_creacion   datetime not null comment 'Auditoria',
   dpp_usu_modificacion int(11) not null comment 'Auditoria',
   dpp_fecha_modificacion datetime not null comment 'Auditoria',
   primary key (dpp_id)
);

alter table dpp_detalle_programacion_produccion comment 'Detalle de programacin produccion';

alter table dpp_detalle_programacion_produccion add constraint fk_dpp_id_art foreign key (dpp_id_art)
      references art_articulo (art_id) on delete restrict on update restrict;

alter table dpp_detalle_programacion_produccion add constraint fk_dpp_id_cva foreign key (dpp_id_cva)
      references cva_conversion_articulo (cva_id) on delete restrict on update restrict;

alter table erpsatelite.dpp_detalle_programacion_produccion add constraint fk_dpp_id_ord foreign key (dpp_id_ord)
      references ord_orden (ord_id) on delete restrict on update restrict;

alter table dpp_detalle_programacion_produccion add constraint fk_dpp_id_ppd foreign key (dpp_id_ppd)
      references ppd_programacion_produccion (ppd_id) on delete restrict on update restrict;


drop table if exists dpp_detalle_programacion_produccion;

/*==============================================================*/
/* Table: dpp_detalle_programacion_produccion                   */
/*==============================================================*/
create table dpp_detalle_programacion_produccion
(
   dpp_id               int(11) not null auto_increment comment 'Llave principal de detalle de planificacion',
   dpp_id_ppd           int(11) not null comment 'Llave principal de Programacion de produccion',
   dpp_id_art           int(11) comment 'Llave principal de articulos',
   dpp_id_cva           int(11) comment 'llave principal de conversin artculo',
   dpp_id_ord           int(11) comment 'Codigo de la orden',
   dpp_fecha_inicio     datetime comment 'Fecha de inicio',
   dpp_prioridad        int(11) comment 'Prioridad',
   dpp_cantidad_orden   decimal(19,6) comment 'Cantidad para la orden',
   dpp_referencia       national varchar(300) comment 'Referencia',
   dpp_observacion      national varchar(500) comment 'Observacion',
   dpp_estado           tinyint(4) not null comment 'estado del registro 1=activo, 0=inactivo',
   dpp_usu_creacion     int(11) not null comment 'Auditoria',
   dpp_fecha_creacion   datetime not null comment 'Auditoria',
   dpp_usu_modificacion int(11) not null comment 'Auditoria',
   dpp_fecha_modificacion datetime not null comment 'Auditoria',
   primary key (dpp_id)
);

alter table dpp_detalle_programacion_produccion comment 'Detalle de programacin produccion';

alter table dpp_detalle_programacion_produccion add constraint fk_dpp_id_art foreign key (dpp_id_art)
      references art_articulo (art_id) on delete restrict on update restrict;

alter table dpp_detalle_programacion_produccion add constraint fk_dpp_id_cva foreign key (dpp_id_cva)
      references cva_conversion_articulo (cva_id) on delete restrict on update restrict;

alter table dpp_detalle_programacion_produccion add constraint fk_dpp_id_ord foreign key (dpp_id_ord)
      references ord_orden (ord_id) on delete restrict on update restrict;

alter table dpp_detalle_programacion_produccion add constraint fk_dpp_id_ppd foreign key (dpp_id_ppd)
      references ppd_programacion_produccion (ppd_id) on delete restrict on update restrict;
drop table if exists dpg_detalle_programacion;

/*==============================================================*/
/* Table: dpg_detalle_programacion                              */
/*==============================================================*/
create table dpg_detalle_programacion
(
   dpg_id               int(11) not null auto_increment comment 'Llave principal de detalle de programacion',
   dpg_id_dpp           int(11) not null comment 'Llave principal de detalle de planificacion',
   dpg_id_etp           int(11) comment 'Codigo de etapa',
   dpg_id_maq           int(11) comment 'llave primaria de maquinas',
   dpg_id_opr           int(11) comment 'llave primaria de operario',
   dpg_fecha            datetime comment 'Fecha',
   dpg_horas            decimal(19,2) comment 'Horas',
   dpg_estado           tinyint(4) not null comment 'estado del registro 1=activo, 0=inactivo',
   dpg_usu_creacion     int(11) not null comment 'Auditoria',
   dpg_fecha_creacion   datetime not null comment 'Auditoria',
   dpg_usu_modificacion int(11) not null comment 'Auditoria',
   dpg_fecha_modificacion datetime not null comment 'Auditoria',
   primary key (dpg_id)
);

alter table dpg_detalle_programacion comment 'Detalle de programacin';

alter table dpg_detalle_programacion add constraint fk_dpg_id_dpp foreign key (dpg_id_dpp)
      references dpp_detalle_programacion_produccion (dpp_id) on delete restrict on update restrict;

alter table dpg_detalle_programacion add constraint fk_dpg_id_etp foreign key (dpg_id_etp)
      references etp_etapa (etp_id) on delete restrict on update restrict;

alter table dpg_detalle_programacion add constraint fk_dpg_id_maq foreign key (dpg_id_maq)
      references maq_maquina (maq_id) on delete restrict on update restrict;

alter table dpg_detalle_programacion add constraint fk_dpg_id_opr foreign key (dpg_id_opr)
      references opr_operario (opr_id) on delete restrict on update restrict;

drop table if exists edp_explosion_detalle_programacion;

/*==============================================================*/
/* Table: edp_explosion_detalle_programacion                    */
/*==============================================================*/
create table edp_explosion_detalle_programacion
(
   edp_id               int(11) not null auto_increment comment 'Llave principal de explosion de detalle de programacion',
   edp_id_ppd           int(11) not null comment 'Llave principal de Programacion de produccion',
   edp_id_rxi           int(11) comment 'Llave principal de la requisicin',
   edp_id_cva           int(11) comment 'llave principal de conversin artculo',
   edp_id_art           int(11) comment 'Llave principal de articulos',
   edp_id_ord           int(11) comment 'Codigo de la orden',
   edp_cantidad_orden   decimal(19,6) comment 'Cantidad para la orden',
   edp_cantidad_requerida decimal(19,6) comment 'Cantidad requerida',
   edp_cantidad_existencia decimal(19,6) comment 'Cantidad existencia',
   edp_cantidad_faltante decimal(19,6) comment 'Cantidad faltante',
   edp_tipo             tinyint(4) not null comment '1=compras, 2=produccion, 3=inventario',
   edp_referencia       national varchar(300) comment 'Referencia',
   edp_observacion      national varchar(500) comment 'Observacion',
   edp_estado           tinyint(4) not null comment 'estado del registro 1=activo, 0=inactivo',
   edp_usu_creacion     int(11) not null comment 'Auditoria',
   edp_fecha_creacion   datetime not null comment 'Auditoria',
   edp_usu_modificacion int(11) not null comment 'Auditoria',
   edp_fecha_modificacion datetime not null comment 'Auditoria',
   primary key (edp_id)
);

alter table edp_explosion_detalle_programacion comment 'Explosin de detalle de programacin.';

alter table edp_explosion_detalle_programacion add constraint fk_edp_id_art foreign key (edp_id_art)
      references art_articulo (art_id) on delete restrict on update restrict;

alter table edp_explosion_detalle_programacion add constraint fk_edp_id_cva foreign key (edp_id_cva)
      references cva_conversion_articulo (cva_id) on delete restrict on update restrict;

alter table edp_explosion_detalle_programacion add constraint fk_edp_id_ord foreign key (edp_id_ord)
      references ord_orden (ord_id) on delete restrict on update restrict;

alter table edp_explosion_detalle_programacion add constraint fk_edp_id_ppd foreign key (edp_id_ppd)
      references ppd_programacion_produccion (ppd_id) on delete restrict on update restrict;

alter table edp_explosion_detalle_programacion add constraint fk_edp_id_rxi foreign key (edp_id_rxi)
      references rxi_requisicion_inventario (rxi_id) on delete restrict on update restrict;
