drop table if exists pyv_pryeccion_venta;

/*==============================================================*/
/* Table: pyv_pryeccion_venta                                   */
/*==============================================================*/
create table pyv_pryeccion_venta
(
   pyv_id               int(11) not null auto_increment comment 'Llave primaria de proyeccion de venta',
   pyv_id_cva           int(11) not null comment 'llave principal de conversin artculo',
   pyv_id_art           int(11) not null comment 'Llave principal de articulos',
   pyv_id_usu           int(11) not null comment 'Llave principal de Usuario.(registro)',
   pyv_anio             int(11) not null comment 'Anio',
   pyv_mes              int(11) comment 'Mes',
   pyv_periodo          int(11) comment 'anio y mes concatenados',
   pyv_cantidad         decimal(19,6) comment 'Cantidad',
   pyv_fecha_registro   datetime not null comment 'fecha registro',
   pyv_estado           tinyint(4) not null comment 'estado del registro 1=activo, 0=inactivo',
   pyv_usu_creacion     int(11) not null comment 'Auditoria',
   pyv_fecha_creacion   datetime not null comment 'Auditoria',
   pyv_usu_modificacion int(11) not null comment 'Auditoria',
   pyv_fecha_modificacion datetime not null comment 'Auditoria',
   primary key (pyv_id)
);

alter table pyv_pryeccion_venta comment 'Entidad - Proyeciones de venta.';

alter table pyv_pryeccion_venta add constraint fk_pyv_id_art foreign key (pyv_id_art)
      references art_articulo (art_id) on delete restrict on update restrict;

alter table pyv_pryeccion_venta add constraint fk_pyv_id_cva foreign key (pyv_id_cva)
      references cva_conversion_articulo (cva_id) on delete restrict on update restrict;

alter table pyv_pryeccion_venta add constraint fk_pyv_id_usu foreign key (pyv_id_usu)
      references users (id) on delete restrict on update restrict;


/*==============================================================*/
/* Opcion de Menu                                               */
/*==============================================================*/

INSERT INTO `opc_opcion` (
`opc_nombre`,
`opc_funcion`,
`opc_descripcion`,
`opc_padre`,
`opc_orden`,
`opc_nivel`,
`opc_hijo`,
`opc_icono`,
`opc_icono_personalizado`,
`opc_imagen_personalizada`,
`opc_estado`,
`opc_usu_creacion`,
`opc_fecha_creacion`,
`opc_usu_modificacion`,
`opc_fecha_modificacion`,
`opc_id_mos` 
)VALUES(
   'Ventas Proyectadas',
   'ventas_proyectadas',
   'Ventas Proyectadas',
   303,
   9,
   2,
   1,
   NULL,
   NULL,
   NULL,
   1,
   '1',
   '2019-12-21 00:00:00',
   '1',
   '2019-12-21 00:00:00',
   15 
   );
