drop table if exists ccr_control_calidad_orden;

/*==============================================================*/
/* Table: ccr_control_calidad_orden                             */
/*==============================================================*/
create table ccr_control_calidad_orden
(
   ccr_id               int(11) not null auto_increment comment 'Llave principal de Programacion de produccion',
   ccr_id_axo           int(11) not null comment 'Llave princpal de orden de producción por artículo',
   ccr_id_usu           int(11) comment 'Llave principal de Usuario.',
   ccr_fecha            datetime comment 'Fecha',
   ccr_hora_inicio      time comment 'Hora inicio',
   ccr_hora_fin         time comment 'Hora fin',
   ccr_descripcion      national varchar(500) comment 'Comentario',
   ccr_fecha_registro   datetime not null comment 'Fecha del registro',
   ccr_estado           tinyint(4) not null comment 'estado del registro 1=activo, 0=inactivo',
   ccr_usu_creacion     int(11) not null comment 'Auditoria',
   ccr_fecha_creacion   datetime not null comment 'Auditoria',
   ccr_usu_modificacion int(11) not null comment 'Auditoria',
   ccr_fecha_modificacion datetime not null comment 'Auditoria',
   primary key (ccr_id)
);

alter table ccr_control_calidad_orden comment 'control de calidad de la orden de produccion';

alter table ccr_control_calidad_orden add constraint fk_ccr_id_axo foreign key (ccr_id_axo)
      references axo_articuloxorden (axo_id) on delete restrict on update restrict;

alter table ccr_control_calidad_orden add constraint fk_ccr_id_usu foreign key (ccr_id_usu)
      references users (id) on delete restrict on update restrict;


drop table if exists atc_anexo_control_calidad;

/*==============================================================*/
/* Table: atc_anexo_control_calidad                             */
/*==============================================================*/
create table atc_anexo_control_calidad
(
   atc_id               int(11) not null auto_increment comment 'Llave primaria de anexo por control de calidad',
   atc_id_ccr           int(11) not null comment 'Llave principal de Programacion de produccion',
   atc_url              varchar(300) not null comment 'Url del anexo',
   atc_nombre           national varchar(300) not null comment 'Nombre o referencia del anexo',
   atc_fecha_registro   datetime not null comment 'Fecha del registro',
   atc_estado           tinyint(4) not null comment 'estado del registro 0=inactivo, 1=activo',
   atc_usu_creacion     int(11) not null comment 'auditoria',
   atc_fecha_creacion   datetime not null comment 'auditoria',
   atc_usu_modificacion int(11) not null comment 'auditoria',
   atc_fecha_modificacion datetime not null comment 'auditoria',
   primary key (atc_id)
);

alter table atc_anexo_control_calidad comment 'Anexos de control de calidad';

alter table atc_anexo_control_calidad add constraint fk_atc_id_ccr foreign key (atc_id_ccr)
      references ccr_control_calidad_orden (ccr_id) on delete restrict on update restrict;


drop table if exists dci_detalle_control_calidad;

/*==============================================================*/
/* Table: dci_detalle_control_calidad                           */
/*==============================================================*/
create table dci_detalle_control_calidad
(
   dci_id               int(11) not null auto_increment comment 'Llave primaria de detalle de control de calidad',
   dci_id_ccr           int(11) not null comment 'Llave principal de Programacion de produccion',
   dci_id_fcc           int(11) not null comment 'Llave primaria de factor de calidad',
   dci_valor            decimal(19,6) comment 'Valor',
   dci_valor_referencia varchar(100) comment 'valor referencia',
   dci_comentario       varchar(500) comment 'comentario',
   dci_estado           tinyint(4) not null comment 'estado del registro 0=inactivo, 1=activo',
   dci_usu_creacion     int(11) not null comment 'auditoria',
   dci_fecha_creacion   datetime not null comment 'auditoria',
   dci_usu_modificacion int(11) not null comment 'auditoria',
   dci_fecha_modificacion datetime not null comment 'auditoria',
   primary key (dci_id)
);

alter table dci_detalle_control_calidad comment 'Detalle de control de calidad';

alter table dci_detalle_control_calidad add constraint fk_dci_id_ccr foreign key (dci_id_ccr)
      references ccr_control_calidad_orden (ccr_id) on delete restrict on update restrict;

alter table dci_detalle_control_calidad add constraint fk_dci_id_fcc foreign key (dci_id_fcc)
      references fcc_factor_calidad (fcc_id) on delete restrict on update restrict;



/*==============================================================*/
/*    Opcion del Menu                                           */
/*==============================================================*/
INSERT INTO `opc_opcion`(
   `opc_nombre`, 
   `opc_funcion`, 
   `opc_descripcion`, 
   `opc_padre`, 
   `opc_orden`, 
   `opc_nivel`, 
   `opc_hijo`, 
   `opc_icono`, 
   `opc_icono_personalizado`, 
   `opc_imagen_personalizada`, 
   `opc_estado`, 
   `opc_usu_creacion`, 
   `opc_fecha_creacion`, 
   `opc_usu_modificacion`, 
   `opc_fecha_modificacion`, 
   `opc_id_mos`
) VALUES (
   'Control de Calidad', 
   'control_calidad', 
   'Control de Calidad', 
   303, 
   10, 
   2, 
   1, 
   NULL, 
   NULL, 
   NULL, 
   1, 
   '1', 
   '2018-12-08 10:13:36', 
   '1', 
   '2018-12-08 10:13:48', 
   15
);
