/*CREAR TABLAS DE PLANIFICACION SI NO EXISTEN EN BASE*/
-- ----------------------------
-- Table structure for plf_planificacion
-- ----------------------------
DROP TABLE IF EXISTS `plf_planificacion`;
CREATE TABLE `plf_planificacion`  (
  `plf_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Llave principal de Planificacion',
  `plf_id_usu` int(11) NOT NULL COMMENT 'Llave principal de Usuario. (quien realiza el registro)',
  `plf_fecha_registro` datetime(0) NOT NULL COMMENT 'Fecha de registro',
  `plf_fecha_inicio` datetime(0) NOT NULL COMMENT 'Fecha inicio',
  `plf_fecha_fin` datetime(0) NOT NULL COMMENT 'Fecha fin',
  `plf_concepto` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'Concepto',
  `plf_observacion` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'Observacion',
  `plf_estado` tinyint(4) NOT NULL COMMENT 'estado del registro 1=activo, 0=inactivo',
  `plf_usu_creacion` int(11) NOT NULL COMMENT 'Auditoria',
  `plf_fecha_creacion` datetime(0) NOT NULL COMMENT 'Auditoria',
  `plf_usu_modificacion` int(11) NOT NULL COMMENT 'Auditoria',
  `plf_fecha_modificacion` datetime(0) NOT NULL COMMENT 'Auditoria',
  PRIMARY KEY (`plf_id`) USING BTREE,
  INDEX `fk_plf_id_usu`(`plf_id_usu`) USING BTREE,
  CONSTRAINT `fk_plf_id_usu` FOREIGN KEY (`plf_id_usu`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 5 CHARACTER SET = latin1 COLLATE = latin1_swedish_ci COMMENT = 'Planificaciones' ROW_FORMAT = Compact;


DROP TABLE IF EXISTS `dpf_detalle_planificacion`;
CREATE TABLE `dpf_detalle_planificacion`  (
  `dpf_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Llave principal de detalle de planificacion',
  `dpf_id_plf` int(11) NOT NULL COMMENT 'Llave principal de Planificacion',
  `dpf_id_art` int(11) NOT NULL COMMENT 'Llave principal de articulos',
  `dpf_id_cva` int(11) NULL DEFAULT NULL COMMENT 'llave principal de conversión artículo',
  `dpf_cantidad_producir` decimal(19, 6) NULL DEFAULT NULL COMMENT 'Cantidad a producir',
  `dpf_inventario_op_anterior` decimal(19, 6) NULL DEFAULT NULL COMMENT 'Cantidad inventario orden de produccion anterior',
  `dpf_inventario_proceso` decimal(19, 6) NULL DEFAULT NULL COMMENT 'Cantidad proceso',
  `dpf_inventario_actual` decimal(19, 6) NULL DEFAULT NULL COMMENT 'Cantidad actual',
  `dpf_ultima_produccion` decimal(19, 6) NULL DEFAULT NULL COMMENT 'Ultima produccion',
  `dpf_fecha_produccion` datetime(0) NULL DEFAULT NULL COMMENT 'Fecha de produccion',
  `dpf_promedio_venta1` decimal(19, 6) NULL DEFAULT NULL COMMENT 'Promedio ventas 1 mes',
  `dpf_promedio_venta2` decimal(19, 6) NULL DEFAULT NULL COMMENT 'Promedio ventas 2 meses',
  `dpf_promedio_venta3` decimal(19, 6) NULL DEFAULT NULL COMMENT 'Promedio ventas 3 meses',
  `dpf_promedio_venta4` decimal(19, 6) NULL DEFAULT NULL COMMENT 'Promedio ventas 6 meses',
  `dpf_promedio_venta5` decimal(19, 6) NULL DEFAULT NULL COMMENT 'Promedio ventas 12 meses',
  `dpf_alcance_actual` decimal(19, 6) NULL DEFAULT NULL COMMENT 'Alcance actual',
  `dpf_alcance_proyectado` decimal(19, 6) NULL DEFAULT NULL COMMENT 'Alcance proyectado',
  `dpf_venta_proyectada1` decimal(19, 6) NULL DEFAULT NULL COMMENT 'Venta proyectada 3 meses',
  `dpf_venta_proyectada2` decimal(19, 6) NULL DEFAULT NULL COMMENT 'Venta proyectada 6 meses',
  `dpf_observacion` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'Observacion',
  `dpf_producir` tinyint(4) NULL DEFAULT NULL COMMENT '1=si, 0 o null=no',
  `dpf_estado` tinyint(4) NOT NULL COMMENT 'estado del registro 1=activo, 0=inactivo',
  `dpf_usu_creacion` int(11) NOT NULL COMMENT 'Auditoria',
  `dpf_fecha_creacion` datetime(0) NOT NULL COMMENT 'Auditoria',
  `dpf_usu_modificacion` int(11) NOT NULL COMMENT 'Auditoria',
  `dpf_fecha_modificacion` datetime(0) NOT NULL COMMENT 'Auditoria',
  PRIMARY KEY (`dpf_id`) USING BTREE,
  INDEX `fk_dpf_id_art`(`dpf_id_art`) USING BTREE,
  INDEX `fk_dpf_id_cva`(`dpf_id_cva`) USING BTREE,
  INDEX `fk_dpf_id_plf`(`dpf_id_plf`) USING BTREE,
  CONSTRAINT `fk_dpf_id_art` FOREIGN KEY (`dpf_id_art`) REFERENCES `art_articulo` (`art_id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_dpf_id_cva` FOREIGN KEY (`dpf_id_cva`) REFERENCES `cva_conversion_articulo` (`cva_id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_dpf_id_plf` FOREIGN KEY (`dpf_id_plf`) REFERENCES `plf_planificacion` (`plf_id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = latin1 COLLATE = latin1_swedish_ci COMMENT = 'Detalle de Planificaciones' ROW_FORMAT = Compact;


/*OPCION DE MENU PLANIFICACION DE PRODUCCION */
INSERT INTO `opc_opcion`(
	`opc_nombre`, 
	`opc_funcion`, 
	`opc_descripcion`, 
	`opc_padre`, 
	`opc_orden`, 
	`opc_nivel`, 
	`opc_hijo`, 
	`opc_icono`, 
	`opc_icono_personalizado`, 
	`opc_imagen_personalizada`, 
	`opc_estado`, 
	`opc_usu_creacion`, 
	`opc_fecha_creacion`, 
	`opc_usu_modificacion`, 
	`opc_fecha_modificacion`, 
	`opc_id_mos`
) VALUES (
	'Planificación', 
	'planificacion_produccion', 
	'Planificación de producción', 
	303,
	7, 
	2, 
	1, 
	NULL, 
	NULL, 
	NULL, 
	1, 
	'1', 
	'2018-12-08 10:13:36', 
	'1', 
	'2018-12-08 10:13:48', 
	15
);

/*NUEVO PARAMETRO PARA CONFIGURACION DE LAS ORDENES DE PRODUCCION DE ARTICULOS INTERMEDIOS*/
INSERT INTO `par_parametro` (
	`par_id_tpr`, 
	`par_tipo`, 
	`par_nombre`, 
	`par_codigo`, 
	`par_valor`, 
	`par_default`, 
	`par_data`, 
	`par_sistema`
) VALUES (
	1,
	'string',
	'Parametro para configuracion de orden de produccion para productos intermedio por la planificacion de produccion. Tipo_Orden = id tio_tipo_orden para planificacion, Cliente = id cli_cliente cliente interno, Automatico = Configuracion Automatica de lotes y etapas 1:Si, 0:No', 
	'SYS_PLANIFICACION_PRODUCCION', 
	'{"TIPO_ORDEN":"1", "CLIENTE":"155", "AUTOMATICO":"1"}', 
	'{"TIPO_ORDEN":"1", "CLIENTE":"1", "AUTOMATICO":"1"}', 
	NULL, 
	1
);