drop table if exists dex_detalle_explosion;

/*==============================================================*/
/* Table: dex_detalle_explosion                                 */
/*==============================================================*/
create table dex_detalle_explosion
(
   dex_id               int(11) not null auto_increment comment 'Llave principal de detalle de planificacion',
   dex_id_plf           int(11) not null comment 'Llave principal de Planificacion',
   dex_id_art           int(11) not null comment 'Llave principal de articulos',
   dex_id_cva           int(11) not null comment 'llave principal de conversin artculo',
   dex_id_rxi           int(11) comment 'Llave principal de la requisicin',
   dex_id_ord           int(11) comment 'Codigo de la orden',
   dex_cantidad_requerida decimal(19,6) comment 'Cantidad requerida',
   dex_cantidad_existencia decimal(19,6) comment 'Cantidad existencia',
   dex_cantidad_faltante decimal(19,6) comment 'Cantidad faltante',
   dex_tipo             tinyint(4) not null comment '1=compras, 2=produccion, 3=inventario',
   dex_referencia       national varchar(300) comment 'Referencia',
   dex_observacion      national varchar(500) comment 'Observacion',
   dex_estado           tinyint(4) not null comment 'estado del registro 1=activo, 0=inactivo',
   dex_usu_creacion     int(11) not null comment 'Auditoria',
   dex_fecha_creacion   datetime not null comment 'Auditoria',
   dex_usu_modificacion int(11) not null comment 'Auditoria',
   dex_fecha_modificacion datetime not null comment 'Auditoria',
   primary key (dex_id)
);

alter table dex_detalle_explosion comment 'Detalle de explosion de Planificaciones';

alter table dex_detalle_explosion add constraint fk_dex_id_art foreign key (dex_id_art)
      references art_articulo (art_id) on delete restrict on update restrict;

alter table dex_detalle_explosion add constraint fk_dex_id_cva foreign key (dex_id_cva)
      references cva_conversion_articulo (cva_id) on delete restrict on update restrict;

alter table dex_detalle_explosion add constraint fk_dex_id_ord foreign key (dex_id_ord)
      references ord_orden (ord_id) on delete restrict on update restrict;

alter table dex_detalle_explosion add constraint fk_dex_id_plf foreign key (dex_id_plf)
      references plf_planificacion (plf_id) on delete restrict on update restrict;

alter table dex_detalle_explosion add constraint fk_dex_id_rxi foreign key (dex_id_rxi)
      references rxi_requisicion_inventario (rxi_id) on delete restrict on update restrict;
