drop table if exists frm_formulario_medico;

/*==============================================================*/
/* Table: frm_formulario_medico                                 */
/*==============================================================*/
create table frm_formulario_medico
(
   frm_id               int(11) not null auto_increment comment 'Llave principal de formulario medico',
   frm_id_ase           int(11) comment 'Llave principal de aseguradora',
   frm_nombre           national varchar(300) not null comment 'Nombre',
   frm_descripcion      national varchar(500) comment 'Descripcion',
   frm_configuraciones_formato national varchar(1000) comment 'Configuraciones diversas al formato de la impresion (json)',
   frm_descripcion_configuracion national varchar(1000) comment 'Descripcion de la configuracion (descripcion del json',
   frm_archivo          national varchar(300) not null comment 'Nombre archivo php de la vista del formato',
   frm_activo           tinyint(4) comment 'Formato activo para la impresion',
   frm_estado           tinyint(4) not null default 1 comment 'estado del registro 1=activo, 0=inactivo',
   frm_usu_creacion     int(11) not null comment 'Auditoria',
   frm_fecha_creacion   datetime not null comment 'Auditoria',
   frm_usu_modificacion int(11) not null comment 'Auditoria',
   frm_fecha_modificacion datetime not null comment 'Auditoria',
   primary key (frm_id)
);

alter table frm_formulario_medico comment 'Formularios Mdicos.';

alter table frm_formulario_medico add constraint fk_frm_id_ase foreign key (frm_id_ase)
      references ase_aseguradora (ase_id) on delete restrict on update restrict;
