drop table if exists fca_factores_calidad_articulo;

/*==============================================================*/
/* Table: fca_factores_calidad_articulo                         */
/*==============================================================*/
create table fca_factores_calidad_articulo
(
   fca_id               int(11) not null auto_increment comment 'Llave primaria de factor de calidad por articulo',
   fca_id_art           int(11) not null comment 'Llave principal de articulos',
   fca_id_fcc           int(11) not null comment 'Llave primaria de factor de calidad',
   fca_referencia       national varchar(300) comment 'Referencia',
   fca_unidad           national varchar(300) comment 'Unidad',
   fca_estado           tinyint(4) not null comment 'estado del registro 1=activo, 0=inactivo',
   fca_usu_creacion     int(11) not null comment 'Auditoria',
   fca_fecha_creacion   datetime not null comment 'Auditoria',
   fca_usu_modificacion int(11) not null comment 'Auditoria',
   fca_fecha_modificacion datetime not null comment 'Auditoria',
   primary key (fca_id)
);

alter table fca_factores_calidad_articulo comment 'Entidad - Factores de Calidad por artculo';

alter table fca_factores_calidad_articulo add constraint fk_fca_id_art foreign key (fca_id_art)
      references art_articulo (art_id) on delete restrict on update restrict;

alter table fca_factores_calidad_articulo add constraint fk_fca_id_fcc foreign key (fca_id_fcc)
      references fcc_factor_calidad (fcc_id) on delete restrict on update restrict;
