ALTER TABLE fac_factura
ADD COLUMN  fac_procesada_comision_venta int  comment 'Factura procesada para comision de venta 1=si, 0 o null = no' after fac_monto_abonado_anulacion;

ALTER TABLE fac_factura
ADD COLUMN  fac_procesada_comision_cobro int comment 'Factura procesada para comision de cobro 1=si, 0 o null = no' after fac_procesada_comision_venta;

drop table if exists cmv_comision_vendedor;

/*==============================================================*/
/* Table: cmv_comision_vendedor                                 */
/*==============================================================*/
create table cmv_comision_vendedor
(
   cmv_id               int(11) not null auto_increment comment 'Llave principal de comisin de vendedores',
   cmv_id_ven           int(11) not null comment 'codigo de vendedor',
   cmv_monto_comision   decimal(19,2) not null comment 'Total comision',
   cmv_monto_abonado    decimal(19,2) not null comment 'Monto abonado a la comisin',
   cmv_monto_pendiente  decimal(19,2) not null comment 'Monto pendiente a la comisin',
   cmv_estado_comision  tinyint(4) not null default 1 comment '1=creada,pendiente, 2=aprobada, 0=anulada/rechazada',
   cmv_estado           tinyint(4) not null comment '0=inactivo, 1=activo',
   cmv_usu_creacion     int(11) not null comment 'Auditoria',
   cmv_fecha_creacion   datetime not null comment 'Auditoria',
   cmv_usu_modificacion int(11) not null comment 'Auditoria',
   cmv_fecha_modificacion datetime not null comment 'Auditoria',
   primary key (cmv_id)
);

alter table cmv_comision_vendedor comment 'Comisn de vendedor';

alter table cmv_comision_vendedor add constraint fk_cmv_id_ven foreign key (cmv_id_ven)
      references ven_vendedor (ven_id) on delete restrict on update restrict;


drop table if exists fxc_facturaxcomision;

/*==============================================================*/
/* Table: fxc_facturaxcomision                                  */
/*==============================================================*/
create table fxc_facturaxcomision
(
   fxc_id               int(11) not null auto_increment comment 'Llave principal de facturas por comisin de vendedores',
   fxc_id_cmv           int(11) not null comment 'Llave principal de comisin de vendedores',
   fxc_id_fac           int(11) not null comment 'Llave  principal de facturacion',
   fxc_id_tia           int(11) not null comment 'Llave princial de tipo de articulo (categoria de articulo)',
   fxc_dias_credito     int(11) not null comment 'Dias de credito',
   fxc_monto_facturado  decimal(19,2) not null comment 'Monto facturado',
   fxc_porcentaje_comision decimal(19,2) not null comment 'Porcentaje aplicado',
   fxc_monto_comision   decimal(19,2) not null comment 'Monto  comisin',
   fxc_estado           tinyint(4) not null comment '0=inactivo, 1=activo',
   fxc_usu_creacion     int(11) not null comment 'Auditoria',
   fxc_fecha_creacion   datetime not null comment 'Auditoria',
   fxc_usu_modificacion int(11) not null comment 'Auditoria',
   fxc_fecha_modificacion datetime not null comment 'Auditoria',
   primary key (fxc_id)
);

alter table fxc_facturaxcomision comment 'Facturas de Comisn de vendedor';

alter table fxc_facturaxcomision add constraint FK_fk_fxc_id_cmv foreign key (fxc_id_cmv)
      references cmv_comision_vendedor (cmv_id) on delete restrict on update restrict;

alter table fxc_facturaxcomision add constraint fk_fxc_id_fac foreign key (fxc_id_fac)
      references fac_factura (fac_id) on delete restrict on update restrict;

alter table fxc_facturaxcomision add constraint fk_fxc_id_tia foreign key (fxc_id_tia)
      references tia_tipo_articulo (tia_id) on delete restrict on update restrict;

/*==============================================================*/
/* Opcion en el menu                                            */
/*==============================================================*/
INSERT INTO `opc_opcion`(`opc_nombre`, `opc_funcion`, `opc_descripcion`, `opc_padre`, `opc_orden`, `opc_nivel`, `opc_hijo`, `opc_icono`, `opc_icono_personalizado`, `opc_imagen_personalizada`, `opc_estado`, `opc_usu_creacion`, `opc_fecha_creacion`, `opc_usu_modificacion`, `opc_fecha_modificacion`, `opc_id_mos`) VALUES ('Comisiones', 'gestion_comisiones', 'Comisiones por Venta o Cobro', 47, 12, 2, 0, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 0);
