SET FOREIGN_key_checks = 0;
drop table if exists pgp_programacion_procedimiento;

/*==============================================================*/
/* Table: pgp_programacion_procedimiento                        */
/*==============================================================*/
create table pgp_programacion_procedimiento
(
   pgp_id               int(11) not null auto_increment comment 'Llave principal de Programacin de procedimiento',
   pgp_id_epp           int(11) not null comment 'Llave principal de Expediente de paciente',
   pgp_id_pcm           int(11) comment 'Llave principal de procedimiento medico',
   pgp_id_med           int(11) comment 'Llave principal de Medico',
   pgp_id_med_anestesia int(11) comment 'Llave principal de Medico',
   pgp_id_med_ayudante  int(11) comment 'Llave principal de Medico',
   pgp_id_luc           int(11) comment 'Llave principal de Lugar de cita',
   pgp_id_tan           int(11) comment 'Llave principal de tipo de anestesia',
   pgp_numero           national varchar(100) not null comment 'Numero/codigo de programacion',
   pgp_tipo             int(11) comment 'Tipo 1=ingreso, 2=ambulatoria',
   pgp_fecha_procedimiento date comment 'Fecha de procedimiento',
   pgp_hora_desde       time comment 'Hora desde',
   pgp_duracion_promedio decimal(19,2) comment 'horas de duracin promedio ',
   pgp_observacion      national varchar(1000) comment 'Observacion',
   pgp_estado_programacion tinyint(4) not null default 1 comment 'estados de la programacion  0=cancelado, 1=pendiente(creada), 2=confirmado, 3=ejecutado.',
   pgp_estado           tinyint(4) not null default 1 comment 'estado del registro 1=activo, 0=inactivo',
   pgp_usu_creacion     int(11) not null comment 'Auditoria',
   pgp_fecha_creacion   datetime not null comment 'Auditoria',
   pgp_usu_modificacion int(11) not null comment 'Auditoria',
   pgp_fecha_modificacion datetime not null comment 'Auditoria',
   primary key (pgp_id)
);

alter table pgp_programacion_procedimiento comment 'Entidad - Programacin de procedimiento';

alter table pgp_programacion_procedimiento add constraint fk_pgp_id_epp foreign key (pgp_id_epp)
      references epp_expediente_paciente (epp_id) on delete restrict on update restrict;

alter table pgp_programacion_procedimiento add constraint fk_pgp_id_luc foreign key (pgp_id_luc)
      references luc_lugar_cita (luc_id) on delete restrict on update restrict;

alter table pgp_programacion_procedimiento add constraint fk_pgp_id_med foreign key (pgp_id_med)
      references med_medico (med_id) on delete restrict on update restrict;

alter table pgp_programacion_procedimiento add constraint fk_pgp_id_med_anestesia foreign key (pgp_id_med_anestesia)
      references med_medico (med_id) on delete restrict on update restrict;

alter table pgp_programacion_procedimiento add constraint fk_pgp_id_med_ayudante foreign key (pgp_id_med_ayudante)
      references med_medico (med_id) on delete restrict on update restrict;

alter table pgp_programacion_procedimiento add constraint fk_pgp_id_pcm foreign key (pgp_id_pcm)
      references pcm_procedimiento_medico (pcm_id) on delete restrict on update restrict;

alter table pgp_programacion_procedimiento add constraint fk_pgp_id_tan foreign key (pgp_id_tan)
      references tan_tipo_anestesia (tan_id) on delete restrict on update restrict;


drop table if exists apg_anexo_programacion;

/*==============================================================*/
/* Table: apg_anexo_programacion                                */
/*==============================================================*/
create table apg_anexo_programacion
(
   apg_id               int(11) not null auto_increment comment 'Llave primaria de anexo por programacin de procedimiento',
   apg_id_pgp           int(11) not null comment 'Llave principal de Programacin de procedimiento',
   apg_url              varchar(300) not null comment 'Url del anexo',
   apg_nombre           national varchar(300) not null comment 'Nombre o referencia del anexo',
   apg_estado           tinyint(4) not null comment 'estado del registro 0=inactivo, 1=activo',
   apg_usu_creacion     int(11) not null comment 'auditoria',
   apg_fecha_creacion   datetime not null comment 'auditoria',
   apg_usu_modificacion int(11) not null comment 'auditoria',
   apg_fecha_modificacion datetime not null comment 'auditoria',
   primary key (apg_id)
);

alter table apg_anexo_programacion comment 'anexos de programacin de procedimiento';

alter table apg_anexo_programacion add constraint fk_apg_id_pgp foreign key (apg_id_pgp)
      references pgp_programacion_procedimiento (pgp_id) on delete restrict on update restrict;


drop table if exists hep_historico_estado_procedimiento_med;

/*==============================================================*/
/* Table: hep_historico_estado_procedimiento_med                */
/*==============================================================*/
create table hep_historico_estado_procedimiento_med
(
   hep_id               int(11) not null auto_increment comment 'Llave principal de historico de estado de procedimiento medico',
   hep_id_pgp           int(11) not null comment 'Llave principal de Programacin de procedimiento',
   hep_id_usu           int(11) not null comment 'Llave principal de Usuario.',
   hep_fecha            datetime not null comment 'Fecha de estado',
   hep_estado_programacion tinyint(4) not null default 1 comment 'estados de la programacion  0=cancelado, 1=pendiente(creada), 2=confirmado, 3=ejecutado.',
   hep_estado           tinyint(4) not null default 1 comment 'estado del registro 1=activo, 0=inactivo',
   hep_usu_creacion     int(11) not null comment 'Auditoria',
   hep_fecha_creacion   datetime not null comment 'Auditoria',
   hep_usu_modificacion int(11) not null comment 'Auditoria',
   hep_fecha_modificacion datetime not null comment 'Auditoria',
   primary key (hep_id)
);

alter table hep_historico_estado_procedimiento_med comment 'Entidad - Historico estado de procedimiento medico';

alter table hep_historico_estado_procedimiento_med add constraint fk_hep_id_pgp foreign key (hep_id_pgp)
      references pgp_programacion_procedimiento (pgp_id) on delete restrict on update restrict;

alter table hep_historico_estado_procedimiento_med add constraint fk_hep_id_usu foreign key (hep_id_usu)
      references users (id) on delete restrict on update restrict;


drop table if exists sgp_seguimiento_programacion_procedimiento;

/*==============================================================*/
/* Table: sgp_seguimiento_programacion_procedimiento            */
/*==============================================================*/
create table sgp_seguimiento_programacion_procedimiento
(
   sgp_id               int(11) not null auto_increment comment 'Llave principal de seguimiento programacin procedimiento',
   sgp_id_pgp           int(11) not null comment 'Llave principal de Programacin de procedimiento',
   sgp_id_usu           int(11) not null comment 'Llave principal de Usuario.',
   sgp_fecha            datetime not null comment 'Fecha de seguimiento',
   sgp_hora             time not null comment 'Hora de seguimiento',
   sgp_comentario       national varchar(1000) comment 'Comentario',
   sgp_url_anexo        varchar(300) comment 'Url del anexo',
   sgp_nombre_anexo     national varchar(300) comment 'Nombre o referencia del anexo',
   sgp_estado           tinyint(4) not null default 1 comment 'estado del registro 1=activo, 0=inactivo',
   sgp_usu_creacion     int(11) not null comment 'Auditoria',
   sgp_fecha_creacion   datetime not null comment 'Auditoria',
   sgp_usu_modificacion int(11) not null comment 'Auditoria',
   sgp_fecha_modificacion datetime not null comment 'Auditoria',
   primary key (sgp_id)
);

alter table sgp_seguimiento_programacion_procedimiento comment 'Entidad - Seguimiento programacin proced';

alter table sgp_seguimiento_programacion_procedimiento add constraint fk_sgp_id_pgp foreign key (sgp_id_pgp)
      references pgp_programacion_procedimiento (pgp_id) on delete restrict on update restrict;

alter table sgp_seguimiento_programacion_procedimiento add constraint fk_sgp_id_usu foreign key (sgp_id_usu)
      references users (id) on delete restrict on update restrict;

SET FOREIGN_key_checks = 1;