drop table if exists rte_ruta_entrega;

/*==============================================================*/
/* Table: rte_ruta_entrega                                      */
/*==============================================================*/
create table rte_ruta_entrega
(
   rte_id               int(11) not null auto_increment comment 'Llave primaria de ruta entrega',
   rte_id_mot           int(11) not null comment 'llave principal - motoristas',
   rte_id_rtc           int(11) not null comment 'Llave principal de rutas de cobro.',
   rte_fecha_entrega    date comment 'Fecha entrega',
   rte_hora_salida      time comment 'hora de salida',
   rte_estado           tinyint(4) not null comment 'estado del registro 0=inactivo, 1=activo',
   rte_usu_creacion     int(11) not null comment 'auditoria',
   rte_fecha_creacion   datetime not null comment 'auditoria',
   rte_usu_modificacion int(11) not null comment 'auditoria',
   rte_fecha_modificacion datetime not null comment 'auditoria',
   primary key (rte_id)
);

alter table rte_ruta_entrega comment 'Ruta de entrega del motorista';

alter table rte_ruta_entrega add constraint fk_rte_id_mot foreign key (rte_id_mot)
      references mot_motorista (mot_id) on delete restrict on update restrict;

alter table rte_ruta_entrega add constraint fk_rte_id_rtc foreign key (rte_id_rtc)
      references rtc_ruta_cobro (rtc_id) on delete restrict on update restrict;

drop table if exists dre_detalle_ruta_entrega;

/*==============================================================*/
/* Table: dre_detalle_ruta_entrega                              */
/*==============================================================*/
create table dre_detalle_ruta_entrega
(
   dre_id               int(11) not null auto_increment comment 'Llave primaria de detalle de ruta entrega',
   dre_id_rte           int(11) not null comment 'Llave primaria de ruta entrega',
   dre_id_fac           int(11) not null comment 'Llave  principal de facturacion',
   dre_descripcion      varchar(500) comment 'Descripcin del registro',
   dre_estado           tinyint(4) not null comment 'estado del registro 0=inactivo, 1=activo',
   dre_usu_creacion     int(11) not null comment 'auditoria',
   dre_fecha_creacion   datetime not null comment 'auditoria',
   dre_usu_modificacion int(11) not null comment 'auditoria',
   dre_fecha_modificacion datetime not null comment 'auditoria',
   primary key (dre_id)
);

alter table dre_detalle_ruta_entrega comment 'Detalle de Ruta de entrega del motorista';

alter table dre_detalle_ruta_entrega add constraint fk_dre_id_fac foreign key (dre_id_fac)
      references fac_factura (fac_id) on delete restrict on update restrict;

alter table dre_detalle_ruta_entrega add constraint fk_dre_id_rte foreign key (dre_id_rte)
      references rte_ruta_entrega (rte_id) on delete restrict on update restrict;

/*==============================================================*/
/* Opcion del ERP                                               */
/*==============================================================*/
INSERT INTO `opc_opcion`(`opc_nombre`, `opc_funcion`, `opc_descripcion`, `opc_padre`, `opc_orden`, `opc_nivel`, `opc_hijo`, `opc_icono`, 
   `opc_icono_personalizado`, `opc_imagen_personalizada`, `opc_estado`, `opc_usu_creacion`, `opc_fecha_creacion`, `opc_usu_modificacion`, 
   `opc_fecha_modificacion`, `opc_id_mos`) 
VALUES ('Control Rutas de Entrega', 'rutas_entrega', 'Control Rutas de Entrega', 96, 12, 2, 0, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 0);
