drop table if exists dfv_detalle_finanza_activo;

/*==============================================================*/
/* Table: dfv_detalle_finanza_activo                            */
/*==============================================================*/
create table dfv_detalle_finanza_activo
(
   dfv_id               int(11) not null auto_increment comment 'Llave principal de detalle finanza del activo fijo',
   dfv_id_act           int(11) not null comment 'Identificacin Unica de Activo Fijo',
   dfv_id_cec           int(11) not null comment 'llave primaria centro de costos',
   dfv_id_tcn           int(11) comment 'Llave principal  - Tipos de cuentas',
   dfv_id_cnt           int(11) comment 'Llave principal  - Cuenta contable',
   dfv_porcentaje       decimal(19,2) comment 'Porcentaje',
   dfv_estado           tinyint(4) not null comment '1=activo, 0=inactivo',
   dfv_usu_creacion     int(11) not null comment 'auditoria',
   dfv_fecha_creacion   datetime not null comment 'auditoria',
   dfv_usu_modificacion int(11) not null comment 'auditoria',
   dfv_fecha_modificacion datetime not null comment 'auditoria',
   primary key (dfv_id)
);

alter table dfv_detalle_finanza_activo comment 'Detalles de finanzas del activo';

alter table dfv_detalle_finanza_activo add constraint fk_dfv_id_act foreign key (dfv_id_act)
      references act_activo_fijo (act_id) on delete restrict on update restrict;

alter table dfv_detalle_finanza_activo add constraint fk_dfv_id_cec foreign key (dfv_id_cec)
      references cec_centro_costo (cec_id) on delete restrict on update restrict;

alter table dfv_detalle_finanza_activo add constraint fk_dfv_id_cnt foreign key (dfv_id_cnt)
      references cnt_cuenta_contable (cnt_id) on delete restrict on update restrict;

alter table dfv_detalle_finanza_activo add constraint fk_dfv_id_tcn foreign key (dfv_id_tcn)
      references tcn_tipo_cuenta (tcn_id) on delete restrict on update restrict;
