drop table if exists pcm_procedimiento_medico;

/*==============================================================*/
/* Table: pcm_procedimiento_medico                              */
/*==============================================================*/
create table pcm_procedimiento_medico
(
   pcm_id               int(11) not null auto_increment comment 'Llave principal de procedimiento medico',
   pcm_nombre           national varchar(300) not null comment 'Nombre',
   pcm_duraccion_aprox  decimal(19,2) comment 'Duracin aproximada',
   pcm_descripcion      national varchar(500) comment 'Descripcion',
   pcm_estado           tinyint(4) not null default 1 comment 'estado del registro 1=activo, 0=inactivo',
   pcm_usu_creacion     int(11) not null comment 'Auditoria',
   pcm_fecha_creacion   datetime not null comment 'Auditoria',
   pcm_usu_modificacion int(11) not null comment 'Auditoria',
   pcm_fecha_modificacion datetime not null comment 'Auditoria',
   primary key (pcm_id)
);

alter table pcm_procedimiento_medico comment 'Entidad - Procedimientos medicos.';

