drop table if exists ain_anexo_incapacidad;

/*==============================================================*/
/* Table: ain_anexo_incapacidad                                 */
/*==============================================================*/
create table ain_anexo_incapacidad
(
   ain_id               int(11) not null auto_increment comment 'Llave primaria de anexo por incapacidad',
   ain_id_inc           int(11) not null comment 'llave primaria del registro de incapacidad',
   ain_url              varchar(300) not null comment 'Url del anexo',
   ain_nombre           national varchar(300) not null comment 'Nombre o referencia del anexo',
   ain_estado           tinyint(4) not null comment 'estado del registro 0=inactivo, 1=activo',
   ain_usu_creacion     int(11) not null comment 'auditoria',
   ain_fecha_creacion   datetime not null comment 'auditoria',
   ain_usu_modificacion int(11) not null comment 'auditoria',
   ain_fecha_modificacion datetime not null comment 'auditoria',
   primary key (ain_id)
);

alter table ain_anexo_incapacidad comment 'anexos de la incapacidad';

alter table ain_anexo_incapacidad add constraint fk_ain_id_inc foreign key (ain_id_inc)
      references inc_incapacidad (inc_id) on delete restrict on update restrict;
