drop table if exists czf_cotizacionxfacturacion;

/*==============================================================*/
/* Table: czf_cotizacionxfacturacion                            */
/*==============================================================*/
create table czf_cotizacionxfacturacion
(
   czf_id               int(11) not null auto_increment comment 'Llave principal de cotizaciones por facturacion',
   czf_id_fac           int(11) not null comment 'Llave  principal de facturacion',
   czf_id_cot           int(11) not null comment 'Codigo de la cotizacion',
   czf_estado           tinyint(4) not null comment '0=inactivo, 1=activo',
   czf_usu_creacion     int(11) not null comment 'Auditoria',
   czf_fecha_creacion   datetime not null comment 'Auditoria',
   czf_usu_modificacion int(11) not null comment 'Auditoria',
   czf_fecha_modificacion datetime not null comment 'Auditoria',
   primary key (czf_id)
);

alter table czf_cotizacionxfacturacion comment 'Cotizacin por facturacin';

alter table czf_cotizacionxfacturacion add constraint fk_czf_id_cot foreign key (czf_id_cot)
      references cot_cotizacion (cot_id) on delete restrict on update restrict;

alter table czf_cotizacionxfacturacion add constraint fk_czf_id_fac foreign key (czf_id_fac)
      references fac_factura (fac_id) on delete restrict on update restrict;
