drop table if exists cpg_configuracion_pago_grupo;

/*==============================================================*/
/* Table: cpg_configuracion_pago_grupo                          */
/*==============================================================*/
create table cpg_configuracion_pago_grupo
(
   cpg_id               int(11) not null auto_increment comment 'Llave principal de configuracin pago grupo',
   cpg_id_gra           int(11) not null comment 'codigo de grupo academica',
   cpg_id_tpl           int(11) not null comment 'Id tipo de planilla',
   cpg_id_tbe           int(11) comment 'Llave primaria de tabla de escalafon',
   cpg_id_usu           int(11) not null comment 'Llave principal de Usuario. (quien hace el registro)',
   cpg_fecha_registro   datetime not null comment 'Fecha de Registro',
   cpg_tipo_pago        tinyint(4) comment 'Tipo de pago 0 o null = no pago (docente de planta), 1=Segn grupo, 2=Segn Escalafn de docente',
   cpg_valor_hora       decimal(19,2) comment 'Valor de hora para el grupo',
   cpg_observacion      varchar(500) comment 'Observacion',
   cpg_estado           tinyint(4) not null comment 'Estado del registro 1=activo, 0=inactivo',
   cpg_usu_creacion     int(11) not null comment 'auditoria',
   cpg_fecha_creacion   datetime not null comment 'auditoria',
   cpg_usu_modificacion int(11) not null comment 'auditoria',
   cpg_fecha_modificacion datetime not null comment 'auditoria',
   primary key (cpg_id)
);

alter table cpg_configuracion_pago_grupo comment 'Configuracin de pago al grupo';

alter table cpg_configuracion_pago_grupo add constraint fk_cpg_id_gra foreign key (cpg_id_gra)
      references gra_grupo_academico (gra_id) on delete restrict on update restrict;

alter table cpg_configuracion_pago_grupo add constraint fk_cpg_id_tbe foreign key (cpg_id_tbe)
      references tbe_tabla_escalafon (tbe_id) on delete restrict on update restrict;

alter table cpg_configuracion_pago_grupo add constraint fk_cpg_id_tpl foreign key (cpg_id_tpl)
      references tpl_tipo_planilla (tpl_id) on delete restrict on update restrict;

alter table cpg_configuracion_pago_grupo add constraint fk_cpg_id_usu foreign key (cpg_id_usu)
      references users (id) on delete restrict on update restrict;
