drop table if exists pmp_promocion_producto;

/*==============================================================*/
/* Table: pmp_promocion_producto                                */
/*==============================================================*/
create table pmp_promocion_producto
(
   pmp_id               int(11) not null auto_increment comment 'Llave principal de promocion de producto',
   pmp_id_mep           int(11) comment 'Codigo de la medida de producto',
   pmp_codigo           varchar(100) not null comment 'Codigo',
   pmp_nombre           varchar(300) not null comment 'nombre',
   pmp_fecha_inicio     datetime comment 'Fecha inicio',
   pmp_fecha_fin        datetime comment 'Fecha fin',
   pmp_cantidad_desde   decimal(19,6) not null comment 'Cantidad desde',
   pmp_cantidad_hasta   decimal(19,6) not null comment 'Cantidad hasta',
   pmp_tipo             tinyint(4) not null default 1 comment '1=precio fijo, 2=porcentaje de descuento',
   pmp_porcentaje       decimal(19,6) comment 'Porcentaje de descuento',
   pmp_precio           decimal(19,6) comment 'precio',
   pmp_descripcion      varchar(500) not null comment 'Descripcin del registro',
   pmp_estado           tinyint(4) not null comment '0=inactivo, 1=activo',
   pmp_usu_creacion     int(11) not null comment 'Auditoria',
   pmp_fecha_creacion   datetime not null comment 'Auditoria',
   pmp_usu_modificacion int(11) not null comment 'Auditoria',
   pmp_fecha_modificacion datetime not null comment 'Auditoria',
   primary key (pmp_id)
);

alter table pmp_promocion_producto comment 'Promocin de productos';

alter table pmp_promocion_producto add constraint fk_pmp_id_mep foreign key (pmp_id_mep)
      references mep_medida_producto (mep_id) on delete restrict on update restrict;

drop table if exists pma_promocion_articulo;

/*==============================================================*/
/* Table: pma_promocion_articulo                                */
/*==============================================================*/
create table pma_promocion_articulo
(
   pma_id               int(11) not null auto_increment comment 'Llave principal de promocion por articulo/ producto',
   pma_id_pmp           int(11) not null comment 'Llave principal de promocion de producto',
   pma_id_art           int(11) not null comment 'Llave principal de articulos',
   pma_estado           tinyint(4) not null comment '0=inactivo, 1=activo',
   pma_usu_creacion     int(11) not null comment 'Auditoria',
   pma_fecha_creacion   datetime not null comment 'Auditoria',
   pma_usu_modificacion int(11) not null comment 'Auditoria',
   pma_fecha_modificacion datetime not null comment 'Auditoria',
   primary key (pma_id)
);

alter table pma_promocion_articulo comment 'Promocin de Artculos/productos';

alter table pma_promocion_articulo add constraint fk_pma_id_art foreign key (pma_id_art)
      references art_articulo (art_id) on delete restrict on update restrict;

alter table pma_promocion_articulo add constraint fk_pma_id_pmp foreign key (pma_id_pmp)
      references pmp_promocion_producto (pmp_id) on delete restrict on update restrict;

