ALTER table mot_motorista
add COLUMN mot_descripcion_vehiculo varchar(300) comment 'Descripcin de vehiculo' after mot_fecha_venci;

ALTER table mot_motorista
add COLUMN mot_posee_ayudante   int(11) not null default 0 comment 'flag para determinar si posee ayudante 1=si, 0=no' after mot_descripcion_vehiculo;

drop table if exists anm_anexo_motorista;

/*==============================================================*/
/* Table: anm_anexo_motorista                                   */
/*==============================================================*/
create table anm_anexo_motorista
(
   anm_id               int(11) not null auto_increment comment 'Llave primaria de anexo del motorista',
   anm_id_mot           int(11) not null comment 'llave principal - motoristas',
   anm_url              varchar(300) not null comment 'Url del anexo',
   anm_nombre           national varchar(300) not null comment 'Nombre o referencia del anexo',
   anm_estado           tinyint(4) not null comment 'estado del registro 0=inactivo, 1=activo',
   anm_usu_creacion     int(11) not null comment 'auditoria',
   anm_fecha_creacion   datetime not null comment 'auditoria',
   anm_usu_modificacion int(11) not null comment 'auditoria',
   anm_fecha_modificacion datetime not null comment 'auditoria',
   primary key (anm_id)
);

alter table anm_anexo_motorista comment 'anexos del motorista';

alter table anm_anexo_motorista add constraint fk_anm_id_mot foreign key (anm_id_mot)
      references mot_motorista (mot_id) on delete restrict on update restrict;


drop table if exists exm_empleadoxmotorista;

/*==============================================================*/
/* Table: exm_empleadoxmotorista                                */
/*==============================================================*/
create table exm_empleadoxmotorista
(
   exm_id               int(11) not null auto_increment comment 'Llave primaria de empleados por motorista',
   exm_id_emp           int(11) not null comment 'Id de Empleado',
   exm_id_mot           int(11) not null comment 'llave principal - motoristas',
   exm_estado           tinyint(4) not null comment 'estado del registro 0=inactivo, 1=activo',
   exm_usu_creacion     int(11) not null comment 'auditoria',
   exm_fecha_creacion   datetime not null comment 'auditoria',
   exm_usu_modificacion int(11) not null comment 'auditoria',
   exm_fecha_modificacion datetime not null comment 'auditoria',
   primary key (exm_id)
);

alter table exm_empleadoxmotorista comment 'empleados por motorista';

alter table exm_empleadoxmotorista add constraint fk_exm_id_emp foreign key (exm_id_emp)
      references emp_empleado (emp_id) on delete restrict on update restrict;

alter table exm_empleadoxmotorista add constraint fk_exm_id_mot foreign key (exm_id_mot)
      references mot_motorista (mot_id) on delete restrict on update restrict;
