ALTER TABLE trp_traslado_pendiente
add COLUMN trp_motivo_prestamo  national varchar(1000) comment 'Motivo de prestamo' after trp_descripcion;

ALTER TABLE trp_traslado_pendiente
add COLUMN trp_fecha_prestamo   datetime comment 'Fecha de prestamo' after trp_motivo_prestamo; 


drop table if exists sxd_saldo_artxdetalle_pendiente;

/*==============================================================*/
/* Table: sxd_saldo_artxdetalle_pendiente                       */
/*==============================================================*/
create table sxd_saldo_artxdetalle_pendiente
(
   sxd_id               int(11) not null auto_increment comment 'Llave principal de saldo articulo por detalle traslado pendiente',
   sxd_id_dtr           int(11) not null comment 'Llave principal de detalle de traslado',
   sxd_id_sar           int(11) not null comment 'Id de saldo',
   sxd_cantidad         decimal(19,10) comment 'cantidad',
   sxd_precio           decimal(19,10) comment 'Precio',
   sxd_subtotal         decimal(19,10) comment 'Sub-total',
   sxd_fecha_caducidad  datetime comment 'Fecha de caducidad/vencimiento',
   sxd_estado           tinyint(4) not null default 1 comment 'Estado del Registro',
   sxd_usu_creacion     int(11) not null comment 'auditoria',
   sxd_fecha_creacion   datetime not null comment 'auditoria',
   sxd_usu_modificacion int(11) not null comment 'auditoria',
   sxd_fecha_modificacion datetime not null comment 'auditoria',
   primary key (sxd_id)
);

alter table sxd_saldo_artxdetalle_pendiente comment 'Detalle de traslado pendiente';

alter table sxd_saldo_artxdetalle_pendiente add constraint fk_sxd_id_dtr foreign key (sxd_id_dtr)
      references dtr_detalle_traslado_pendiente (dtr_id) on delete restrict on update restrict;

alter table sxd_saldo_artxdetalle_pendiente add constraint fk_sxd_id_sar foreign key (sxd_id_sar)
      references sar_saldo_articulo (sar_id) on delete restrict on update restrict;
