-- AGREGAR TABLA NUEVA
CREATE TABLE scc_seguimiento_cxc (
	scc_id int NOT NULL AUTO_INCREMENT COMMENT 'ID',
	scc_id_cli int NOT NULL COMMENT 'Llave con cliente',
	scc_id_fac int NULL COMMENT 'Llave con la factura cuando es a detalle',
	scc_id_tsg int NOT NULL COMMENT 'Llave con Tipo de seguimiento',
	scc_fecha datetime NOT NULL COMMENT 'Fecha que se realizo',
	scc_fecha_proximo date NOT NULL COMMENT 'Fecha proximo contacto',
	scc_comentario text NOT NULL COMMENT 'Comentarios del seguimiento',
	scc_estado tinyint NOT NULL COMMENT 'Estado 1=activo, 0=inactivo',
	scc_usu_creacion int NOT NULL COMMENT 'Usuario creo',
	scc_fecha_creacion datetime NOT NULL COMMENT 'Fecha creo',
	scc_usu_modificacion int NOT NULL COMMENT 'Usuario modifica',
	scc_fecha_modificacion datetime NOT NULL COMMENT 'Fecha modifica',
	PRIMARY KEY (scc_id),
	CONSTRAINT fk_scc_id_cli FOREIGN KEY (scc_id_cli) REFERENCES cli_cliente (cli_id) ON DELETE RESTRICT ON UPDATE RESTRICT,
	CONSTRAINT fk_scc_id_fac FOREIGN KEY (scc_id_fac) REFERENCES fac_factura (fac_id) ON DELETE RESTRICT ON UPDATE RESTRICT,
	CONSTRAINT fk_scc_id_tsg FOREIGN KEY (scc_id_tsg) REFERENCES tsg_tipo_seguimiento (tsg_id) ON DELETE RESTRICT ON UPDATE RESTRICT
)

-- PASAR LOS DATOS A LA TABLA
INSERT INTO scc_seguimiento_cxc (scc_id_cli, scc_id_fac, scc_id_tsg, scc_fecha, scc_fecha_proximo, scc_comentario, scc_estado, 
	scc_usu_creacion, scc_fecha_creacion, scc_usu_modificacion, scc_fecha_modificacion)
SELECT cli, fac, 1 AS tsg, fecha, DATE(prox), coment, 1 AS st, um, fm, um, fm FROM (SELECT fac_id fac, fac_id_cli AS cli, 
	fac_fecha_prox_cobro AS prox, fac_fecha_seguimiento_cobro AS fecha, fac_comentario_seguimiento AS coment, fac_usu_mod AS um, 
	fac_fecha_mod AS fm FROM fac_factura WHERE fac_fecha_seguimiento_cobro IS NOT NULL ORDER BY fac_id_cli, fac_fecha_seguimiento_cobro ASC) AS a;