/**
 * Descripcion: Utilidades Basicas de javaScript implementada en la plantilla azul, con el
 *              objetivo de agilizar el desarrollo de las aplicaciones web.
 * @author:     Alan Alvarenga.
 * @version:    0.3 2013-07-19
 * @since:      2013-07-19
 * @package:    Grupo Satelite Blue (plantilla azul)
 * @type {Object}
 * =================================================================================================
 * Nomenclatura:
 * + AGREGADO
 * - ELIMINADO
 * * ACTUALIZADO
 * -------------------------------------------------------------------------------------------------
 * Bitacora:
 * 2013-07-19
 * + baseUrl    -   genera la URL base de el proyecto.
 * + jsSelect   -   convierte todos las etiquetas de tipo select a select2
 * + jsDatePicker   - convierte todos los input de tipo text que posean en el name la palabra fecha
 * por Alan Alvarenga.
 * -------------------------------------------------------------------------------------------------
 */
window.gSateliteWhite = {
    baseUrl: function (path) {
        //Set default value, si no es definido
        path = typeof path !== 'undefined' ? path : '';

        //Set default value, si no es definido
        path = typeof path !== 'undefined' ? path : '';

        //Set default value, si no es definido
        path = typeof path !== 'undefined' ? path : '';

        //Magic ;)
        return satelite.base_url() + path; // debe existir en la masterpage.
    },
    jsSelect: function () {
        //Obtiene todos las etiquetas de tipo select.
        var $select = $("select");
        //A traves de la propiedad prototype, adjudica a cada select la funcion select2
        return $select.select2();
    },
    jsDatePicker: function () {
        $("input[name*='fecha']").datepicker({
            showButtonPanel: true,
            changeMonth: true,
            changeYear: true,
            dateFormat: 'yy-mm-dd',
            monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
            dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
            nextText: "Siguiente",
            prevText: "Anterior"
        }).click(function () {
            $('button.ui-datepicker-current')
                .removeClass('ui-priority-secondary')
                .addClass('ui-priority-primary');
        });
        $('button.ui-datepicker-current').live('click', function () {
            $.datepicker._curInst.input.datepicker('setDate', new Date()).datepicker('hide').blur();
        });
    },
    jsSelectFilter: function (options) {
        var url = gSateliteBlue.baseUrl('utils/ajax/call/get_dropdown_filter');
        $.ajax({
            url: url,
            dataType: 'json',
            data: options,
            type: 'GET',
            success: function (data) {

                var rows = data.message;
                var $selector = $('[name="' + options.insert + '"]');

                gSateliteBlue.fn.doList($selector, rows);
            }
        });
    },
    jsUnsetDateTimePicker: function (formato) {
        if (formato == '' || formato == null) {
            formato = 'dd-mm-yy';
        }
        $('.datetime-input').datetimepicker('destroy');
        $('.datetime-input').next().remove();

        $('.datetime-input').each(function () {
            var parent = $(this).parent();
            var children = parent.children();
            parent.html('');
            parent.append(children);
        });

        $('.datetime-input').datetimepicker({
            //timeFormat: '',
            separator: '',
            dateFormat: formato,
            showButtonPanel: true,
            changeMonth: true,
            changeYear: true,
            showTimepicker: false,
            autoClose: true,
            onSelect: function () {
                //$("#ui-datepicker-div").fadeOut('200');
                $(".ui-datepicker-close").trigger('click');
            }
        });
    },
    fn: {
        doList: function ($selector, rows) {
            //Limpiar opciones antiguas
            $selector.empty();

            //iniciarlizar listado de opciones
            var optionList = '';

            //Generar listado de opciones
            $.each(rows, function (index, element) {
                optionList += '<option value="' + element.id + '">' + element.value + '</option>';
            });

            return $selector.append(optionList);
        }
    }
};


////funion js que hace los mismo que number_format
///INICIO DE FUNCIÓN number_format
function number_format(number, decimals, dec_point, thousands_sep) {
    //  discuss at: http://phpjs.org/functions/number_format/
    // original by: Jonas Raoni Soares Silva (http://www.jsfromhell.com)
    // improved by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
    // improved by: davook
    // improved by: Brett Zamir (http://brett-zamir.me)
    // improved by: Brett Zamir (http://brett-zamir.me)
    // improved by: Theriault
    // improved by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
    // bugfixed by: Michael White (http://getsprink.com)
    // bugfixed by: Benjamin Lupton
    // bugfixed by: Allan Jensen (http://www.winternet.no)
    // bugfixed by: Howard Yeend
    // bugfixed by: Diogo Resende
    // bugfixed by: Rival
    // bugfixed by: Brett Zamir (http://brett-zamir.me)
    //  revised by: Jonas Raoni Soares Silva (http://www.jsfromhell.com)
    //  revised by: Luke Smith (http://lucassmith.name)
    //    input by: Kheang Hok Chin (http://www.distantia.ca/)
    //    input by: Jay Klehr
    //    input by: Amir Habibi (http://www.residence-mixte.com/)
    //    input by: Amirouche
    //   example 1: number_format(1234.56);
    //   returns 1: '1,235'
    //   example 2: number_format(1234.56, 2, ',', ' ');
    //   returns 2: '1 234,56'
    //   example 3: number_format(1234.5678, 2, '.', '');
    //   returns 3: '1234.57'
    //   example 4: number_format(67, 2, ',', '.');
    //   returns 4: '67,00'
    //   example 5: number_format(1000);
    //   returns 5: '1,000'
    //   example 6: number_format(67.311, 2);
    //   returns 6: '67.31'
    //   example 7: number_format(1000.55, 1);
    //   returns 7: '1,000.6'
    //   example 8: number_format(67000, 5, ',', '.');
    //   returns 8: '67.000,00000'
    //   example 9: number_format(0.9, 0);
    //   returns 9: '1'
    //  example 10: number_format('1.20', 2);
    //  returns 10: '1.20'
    //  example 11: number_format('1.20', 4);
    //  returns 11: '1.2000'
    //  example 12: number_format('1.2000', 3);
    //  returns 12: '1.200'
    //  example 13: number_format('1 000,50', 2, '.', ' ');
    //  returns 13: '100 050.00'
    //  example 14: number_format(1e-8, 8, '.', '');
    //  returns 14: '0.00000001'

    number = (number + '')
        .replace(/[^0-9+\-Ee.]/g, '');
    var n = !isFinite(+number) ? 0 : +number,
        prec = !isFinite(+decimals) ? 0 : Math.abs(decimals),
        sep = (typeof thousands_sep === 'undefined') ? ',' : thousands_sep,
        dec = (typeof dec_point === 'undefined') ? '.' : dec_point,
        s = '',
        toFixedFix = function (n, prec) {
            var k = Math.pow(10, prec);
            return '' + (Math.round(n * k) / k)
                .toFixed(prec);
        };
    // Fix for IE parseFloat(0.55).toFixed(0) = 0;
    s = (prec ? toFixedFix(n, prec) : '' + Math.round(n))
        .split('.');
    if (s[0].length > 3) {
        s[0] = s[0].replace(/\B(?=(?:\d{3})+(?!\d))/g, sep);
    }
    if ((s[1] || '')
        .length < prec) {
        s[1] = s[1] || '';
        s[1] += new Array(prec - s[1].length + 1)
            .join('0');
    }
    return s.join(dec);
}

///FIN DE FUNCION number_format

/**
 * @author René Castaneda
 * Como usar?: unicamente hacer un: $("#input_nombre").addClass('soloLetras');
 * Si se quiere que permita otro(s) caracter(es) hacer lo siguiente
 * $("#input_nombre").attr('extras', 'OTROS_CARACTERES');
 * $("#input_nombre").attr('extras', '-+/');
 */
///FUNCIONES PARA VALIDAR CARACTERES


//1-Función para permitir ingresar solo letras en un input
function soloLetras(e, masCaracteres) {
    key = e.keyCode || e.which;
    tecla = String.fromCharCode(key).toLowerCase();
    if (tecla == '\'' || tecla == '%' || tecla == '"') {
        return false;
    }
    letras = " áéíóúabcdefghijklmnñopqrstuvwxyz" + masCaracteres;
    especiales = [8, 37, 39, 46, 13, 9];
    // especiales = [13];

    tecla_especial = false
    for (var i in especiales) {
        if (key == especiales[i]) {
            tecla_especial = true;
            break;
        }
    }

    if (letras.indexOf(tecla) == -1 && !tecla_especial) {
        return false;
    }
}

//2-Función para permitir ingresar solo numeros en un input
function soloNumeros(e, masCaracteres) {
    key = e.keyCode || e.which;
    tecla = String.fromCharCode(key).toLowerCase();

    letras = "0123456789" + masCaracteres;
    if (masCaracteres.indexOf('.') != -1) {
        if (tecla == '\'' || tecla == '%' || tecla == '"') {
            return false;
        }
    } else {
        if (tecla == '\'' || tecla == '%' || tecla == '"' || tecla == '.') {
            return false;
        }
    }
    especiales = [8, 37, 39, 46, 13, 9];
    // especiales = [13];

    tecla_especial = false
    for (var i in especiales) {
        if (key == especiales[i]) {
            tecla_especial = true;
            break;
        }
    }

    if (letras.indexOf(tecla) == -1 && !tecla_especial) {
        return false;
    }
}

//3-Función para permitir ingresar solo letras y numeros
function soloNumerosLetras(e, masCaracteres) {
    key = e.keyCode || e.which;
    tecla = String.fromCharCode(key).toLowerCase();
    letras = " áéíóúabcdefghijklmnñopqrstuvwxyz0123456789" + masCaracteres;
    if (tecla == '\'' || tecla == '%' || tecla == '"') {
        return false;
    }
    especiales = [8, 37, 39, 46, 13, 9];
    //especiales = [13];

    tecla_especial = false
    for (var i in especiales) {
        if (key == especiales[i]) {
            tecla_especial = true;
            break;
        }
    }

    if (letras.indexOf(tecla) == -1 && !tecla_especial) {
        return false;
    }
}

//4-Función para permitir ingresar solo letras y numeros
function soloPermitidos(e) {
    key = e.keyCode || e.which;
    tecla = String.fromCharCode(key).toLowerCase();
    letras = " áéíóúabcdefghijklmnñopqrstuvwxyz0123456789-/+*#@$%?¿=_.,[{}];:()!¡";
    if (tecla == '\'' || tecla == '"') {
        return false;
    }
    especiales = [8, 37, 39, 46, 13, 9];
    //especiales = [13];

    tecla_especial = false
    for (var i in especiales) {
        if (key == especiales[i]) {
            tecla_especial = true;
            break;
        }
    }

    if (letras.indexOf(tecla) == -1 && !tecla_especial) {
        return false;
    }
}

/////APLICACION DE LAS FUNCIONES ANTERIORES MEDIANTE UNA CLASE
/////AL INPUT SE PUEDE AÑADIR UNA ETIQUETA LLAMA EXTRA, PARA ACEPTAR MAS CARACTERES

$("body").on('keypress', '.soloLetras', function (e) {
    if ($(this).attr('extras')) {
        var masC = $(this).attr('extras');
        return soloLetras(e, masC);
    } else {
        return soloLetras(e, '');
    }
});

$("body").on('keypress', '.soloNumeros', function (e) {
    if ($(this).attr('extras')) {
        var masC = $(this).attr('extras');
        return soloNumeros(e, masC);
    } else {
        return soloNumeros(e, '');
    }
});

$("body").on('keypress', '.soloNumerosLetras', function (e) {
    if ($(this).attr('extras')) {
        var masC = $(this).attr('extras');
        return soloNumerosLetras(e, masC);
    } else {
        return soloNumerosLetras(e, '');
    }
});

$("body").on('keypress', '.soloPermitidos', function (e) {
    return soloPermitidos(e);
});

//@author René Castaneda
function crear_alerta(tipo, titulo, texto) {
    icono = 'picon icon16 entypo-icon-warning white';
    if ($.trim(tipo) == 'warning') {
        icono = 'picon icon16 entypo-icon-warning white';
    }
    if ($.trim(tipo) == 'info') {
        icono = 'picon icon16 brocco-icon-info white';
    }
    if ($.trim(tipo) == 'success') {
        icono = 'picon icon16 iconic-icon-check-alt white';
    }
    if ($.trim(tipo) == 'error') {
        icono = 'picon icon24 typ-icon-cancel white';
    }
    // $(".ui-pnotify").remove();
    $(".icon-remove").trigger('click');
    //if(!$("div").hasClass('ui-pnotify'))
    $.pnotify({
        type: tipo,
        title: titulo,
        text: texto,
        icon: icono,
        opacity: 0.95,
        history: false,
        sticker: false
    });
}

//@Melbin Cruz
// Se utiliza en el manejo de errores de las peticiones Ajax
function exportarError(error) {
    wait.close();
    var url = window.location.pathname; // Returns path only
    icono = 'picon icon24 typ-icon-cancel white';
    if (!$("div").hasClass('ui-pnotify'))
        $.pnotify({
            type: "error",
            title: "Error",
            text: "Hubo un error en la operación<br><a id='printError' href='#' style='color: rgb(127, 255, 0); padding-left:20%; font-size:15px; '><b> &LT;&LT;Exportar Error&GT;&GT; </b></a>",
            icon: icono,
            opacity: 0.95,
            history: false,
            sticker: false
        });

    $("<form method='POST' target='_blank' action='" + window.gSateliteWhite.baseUrl('inicio/imprimirError') + "' id='formError' name='formError' style='display:none;'><input type='text' id='textoError' name='textoError'> <input type='text' id='urlError' name='urlError'></form>").appendTo('body');
    $("#urlError").val(url);
    $("#textoError").val(error);
    $("#printError").on('click', function () {
        $("#formError").submit();
    });

}

//@author René Castaneda 
//crear un confirm de jquery  (modal dialog)

/*
COMO USAR?
 $(".eliminar_registro").click(function(event) {
            event.preventDefault();
alerta_confirm(base_url + '/mantenimientos/eliminar_registro/52'
                ,'Realmente desea eliminar el registro?',
                'Es posible que se pierda información importante'
                );
  });
*/

function alerta_confirm(url_action, titulo, mensaje) {
    $("body").append('<div id="dialog_alerta_confirm" style="display:none;" title="Confirmar"><p><span class="icon16  icomoon-icon-warning black" style="float:left; margin:0 7px 20px 0;"></span><span id="dialog_alerta_confirm_text"></span></p></div>');
    $("#dialog_alerta_confirm_text").html(mensaje);
    $("#dialog_alerta_confirm").dialog({
        resizable: false,
        position: 'top',
        draggable: false,
        title: titulo,
        show: {
            effect: "slideDown",
            duration: 400
        }, hide: {
            effect: "slideUp",
            duration: 300
        },
        modal: true,
        close: function (event, ui) {
            setTimeout(function () {
                $("#dialog_alerta_confirm").remove();
            }, 300);
        },
        height: 150,
        width: 250,
        overlay: {backgroundColor: "#000", opacity: 0.5},
        buttons: {
            "Aceptar": function () {
                $(this).dialog("close");
                window.location.href = url_action;
                $("#dialog_alerta_confirm").remove();
            },
            "Cancelar": function () {
                $(this).dialog("close");
                setTimeout(function () {
                    $("#dialog_alerta_confirm").remove();
                }, 300);
            }
        }
    });

}

/**
 *@author René Castaneda
 * la funcion es siminar pero con la diferencia que no hace un redirect a una url
 * si no que manda a llamar a una funcion (como primer parametro),
 * dicha funcion recibe un parametro (como segundo parametro de la funcion si son varios se puede hacer en un array)
 * y despues el titulo y en mensaje como los dos ultimos parametros de la funcion.
 * ejemplo de uso:
 data[0]=id;
 data[1]=p5
 alerta_confirm_ajax(eliminar_registro_ajax,data,'Confirmar eliminar registro','¿Realmente desea eliminar el registro seleccionado?');

 **/
function alerta_confirm_ajax(funcion_action, parametro, titulo, mensaje) {
    $("body").append('<div id="dialog_alerta_confirm" style="display:none;" title="Confirmar"><p><span class="icon16  icomoon-icon-warning black" style="float:left; margin:0 7px 20px 0;"></span><span id="dialog_alerta_confirm_text"></span></p></div>');
    $("#dialog_alerta_confirm_text").html(mensaje);
    $("#dialog_alerta_confirm").dialog({
        resizable: false,
        position: 'top',
        draggable: false,
        title: titulo,
        show: {
            effect: "slideDown",
            duration: 400
        }, hide: {
            effect: "slideUp",
            duration: 300
        },
        modal: true,
        close: function (event, ui) {
            setTimeout(function () {
                $("#dialog_alerta_confirm").remove();
            }, 300);
        },
        height: 150,
        width: 250,
        overlay: {backgroundColor: "#000", opacity: 0.5},
        buttons: {
            "Aceptar": function () {
                $(this).dialog("close");
                funcion_action(parametro);
                $("#dialog_alerta_confirm").remove();
            },
            "Cancelar": function () {
                $(this).dialog("close");
                setTimeout(function () {
                    $("#dialog_alerta_confirm").remove();
                }, 300);
            }
        }
    });

}

//para ir a un tab(pestaña) especifico unicamente se pasa el id del tab (id del link del tab)
function saltar_tab(id_tab, tiempo) {
    event.preventDefault();
    setTimeout(function () {
        $("#" + id_tab).trigger("click");
    }, tiempo);
}

//anadir a un link la clase "ver_en_modal" para mostrar su contenido en un fancybox
jQuery(document).ready(function ($) {
    /*$(".ver_en_modal").fancybox({
        openEffect: 'elastic',
        closeEffect: 'elastic',
        href: $(this).attr('href'),
        type: 'iframe'
    });

    $(".ver_en_modal_ajax_").fancybox({
        openEffect: 'elastic',
        closeEffect: 'elastic',
        href: $(this).attr('href')
    });


    $(".ver_en_modal_ajax_").live('mouseover', function (event) {
        event.preventDefault();
        padre = $(this).parent().parent();
        codigo_fancy = 'jQuery(document).ready(function($) { $(".ver_en_modal_ajax_").fancybox({ openEffect  : "elastic", closeEffect : "elastic", href: $(this).attr("href") }); });';
        script_java = '<script type="text/javascript">' + codigo_fancy + '</script>';
        div_fancy = '<div id="div_contenedor_fancy_script" style="display:none;" >' + script_java + '</div>';
        if ($("#div_contenedor_fancy_script").length <= 0) {
            $(padre).append(div_fancy);
        }
    });

    $(".ver_en_modal_ajax2").live('click', function (event) {

        event.preventDefault();
        url = $(this).attr('href');
        wait.start();
        $.ajax({
            url: url
        }).done(function (html) {
            wait.close();
            $.fancybox(html);
        });

    });*/

//   $("#DataTables_Table_0_wrapper .tools .delete-row").live('click',function(event) {
//     setTimeout(function(){
//     $('.ui-dialog-buttonset button:first').attr('onclick',"esperar_error();");
//     }, 1000);
//   });


    $('.btniframe').click(function (event) {
        event.preventDefault();
        $.fancybox({
            'width': '70%',
            'height': '80%',
            'autoScale': true,
            'transitionIn': 'fade',
            'transitionOut': 'fade',
            'href': $(this).attr('href'),
            'type': 'iframe'
        });

    });
// Codigo para controlar el panel de menu con la tecla "Alt"
    //   $(document).keyup(function(e){
    //   if($('#sidebar div').length>1){
    //     e.preventDefault();
    //     if(e.which==18){
    //       $(".collapseBtn > .tipR").trigger('click');
    //     }
    //   }
    // });

    /*$('.hora').timeEntry({
        show24Hours: false,
        ampmPrefix: ' ',
        spinnerImage: urlj + 'media/images/spinner.png',
        spinnerSize: [30, 30, 0],
        spinnerBigSize: [70, 50, 0],
        spinnerIncDecOnly: true,
        spinnerTexts: ['', '', '', 'Incrementar', 'Disminuir']

    });
    $('.hora24').timeEntry({
        show24Hours: true,
        ampmPrefix: ' ',
        spinnerImage: urlj + 'media/images/spinner.png',
        spinnerSize: [30, 30, 0],
        spinnerBigSize: [70, 50, 0],
        spinnerIncDecOnly: true,
        spinnerTexts: ['', '', '', 'Incrementar', 'Disminuir']

    });*/

// Para los proyectos de Asamblea

    $('.hora').css({'margin-bottom': '25px', 'width': '85px', 'height': '28px'});
    $('.timeEntry_control').css({'position': 'absolute', 'margin-left': '-20px'});

}); // End document.ready

//function esperar_error() {
//  setTimeout(function(){
//    crear_alerta('error','NOTA','Otros registros dependen de este,<br />&nbsp;Por lo tanto No podrá ser eliminado.');
//}, 1701);
//}

function goToList2() {
    // alert(list_url );
    alerta_confirm(list_url, 'Alerta confirmación',
        'Los datos que insertaste no han sido guardados.<br /> ¿Éstas seguro que quieres regresar a la lista?'
    );
}


/*
@author René Castaneda
id_fecha_inicio=id del input de la fecha inicio
id_fecha_fin=id del input de la fecha fin
texto_alerta=texto a mostrar al usuario (opcional)
forma de uso:  $("#fecha_inicio,#fecha_fin").change(function(event) {  validar_fecha_inicio_fin('fecha_inicio','fecha_fin'); });
*/
function validar_fecha_inicio_fin(id_fecha_inicio, id_fecha_fin, texto_alerta) {
    texto_alerta = typeof texto_alerta !== 'undefined' ? texto_alerta : 'La fecha de inicio debe ser menor a la fecha fin';
    if ($("#" + id_fecha_inicio).length > 0 && $("#" + id_fecha_fin).length > 0) {
        var fecha_inicio = $("#" + id_fecha_inicio).val();
        var fecha_fin = $("#" + id_fecha_fin).val();
        if (fecha_inicio != '' && fecha_fin != '') {
            f_1 = fecha_inicio.split('-');
            f_2 = fecha_fin.split('-');
            var f1 = new Date(f_1[2], f_1[1], f_1[0]);
            var f2 = new Date(f_2[2], f_2[1], f_2[0]);

            if ((f2 < f1)) {
                crear_alerta("info", texto_alerta, '');
                $("#" + id_fecha_inicio).val('');
                $("#" + id_fecha_fin).val('');
            }
        }

    }
}