class LandingPage {
    constructor() {
        $(document).ready(() => {
            this.loadBlock();
            this.loadMenu();
            this.loadSlider();
            this.swiper_horizontal();
            this.swiper_vertical();
        });
    }
    swiper_horizontal() {
        new Swiper('.swiper_horizontal', {
            direction: 'horizontal',
            loop: true,
            pagination: {
                el: '.swiper-pagination',
            },
            navigation: {
                nextEl: '.swiper-button-next',
                prevEl: '.swiper-button-prev',
            },
            scrollbar: {
                el: '.swiper-scrollbar',
            },
        });
    }
    swiper_vertical() {
        new Swiper('.swiper_vertical', {
            direction: 'vertical', // Dirección vertical
            loop: true, // Permite un bucle infinito
            pagination: {
                el: '.swiper-pagination',
                clickable: true, // Permite hacer clic en la paginación
            },
            navigation: {
                nextEl: '.swiper-button-next',
                prevEl: '.swiper-button-prev',
            },
            scrollbar: {
                el: '.swiper-scrollbar',
            },
            mousewheel: true, // Permite desplazamiento con el scroll del mouse
        });

    }
    loadBlock() {
        fetch(`${host}landing_page/controller_landing_page/get_detail_block_init`).then(response => {
            if (!response.ok) {
                throw new Error(`Error en la solicitud: ${response.statusText}`);
            }
            return response.json();
        }).then(data => {
            let table = data.table;
            let container = '';
            let rowOpen = false; 
            let pairCount = 0; 
            table.sort((a, b) => a.gpi_orden - b.gpi_orden);
            table.forEach((value, index) => {
                let bgUrl = '';
                let imgB = '';
                let val = '';
                // Si tiene imagen principal
                if (value.gpi_theme === "BG-IMG" || value.gpi_theme === "BG-IMG-FIXED") {
                    bgUrl = `style="background-image: url('${host}uploads/sistema/gestion_contenido/${value.gpi_url_bloque}')"`
                }
                if (value.gpi_url_principal != null && value.gpi_url_principal != "") {
                    imgB = `<img class="mb-4" src="${host}uploads/sistema/gestion_contenido/${value.gpi_url_principal}" height="${value.gpi_alto}" width="${value.gpi_ancho}" />`;
                }
                // Si tiene valor, lo mostramos
                let class_text = "justify-text";
                let show = value.gpi_valor;
                value.gpi_valor.length < 55 ? class_text = "center-text" : class_text = class_text;
                value.gpi_valor.length < 55 ? show = `<center>${show}</center>` : show = show;
                if (value.gpi_valor) {
                    val = `<div class="align-items-center">
                                <span class="txt-block FONT-WEIT-500 ${class_text} mt-4 text-block-body mt--2">
                                    ${show}
                                </span>
                            </div>`;
                }
                let clase = "col-md-12";
                value.gpi_presentacion === '2' ? clase = "col-md-6 thisCenter" : clase = clase;
                let blockContent = `
                    <div id="${value.gpi_div_id}" class="${clase} block-custom mt-4">
                        <div ${bgUrl} class="${value.gpi_theme} div-content-block">

                            <div class="container pt-5">
                                <div class="row">
                                    <div class="col-md-12">
                                        <center>
                                            ${imgB} 
                                        </center>
                                    </div>
                                </div>
                            </div>

                            <div class="title-block FONT-WEIT-MAX"> 
                                <h3 align="center">
                                    ${value.gpi_nombre}
                                </h3>
                            </div>
                            <div class="container ">
                                <div class="row">
                                    <div class="col-md-12 pl-5 pr-5">
                                        <div class="container">
                                            ${val}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                        </div>
                    </div>`;
                if (value.gpi_presentacion === '2') {
                    if (pairCount % 2 === 0) {
                        container += `<div class="row">`;
                        rowOpen = true;
                    }
                    container += blockContent;
                    pairCount++;
                    if (pairCount % 2 === 0) {
                        container += `</div>`;
                        rowOpen = false;
                    }
                } else {
                    if (rowOpen) {
                        container += `</div>`; 
                        rowOpen = false;
                    }
                    container += `<div class="row">${blockContent}</div>`;
                }
            });
            if (rowOpen) {
                container += `<div class="col-md-6"></div></div>`;
            }
            $(".divContainerBlockCustom").html(container);
            setTimeout(() => {
                if (window.location.hash) {
                    const target = document.querySelector(window.location.hash);
                    if (target) {
                        target.scrollIntoView({
                            behavior: 'smooth'
                        });
                    }
                }
            }, 100);
        }).catch(error => {
            console.error('Error:', error);
        });
    }
    loadMenu() {};
    loadSlider() {};
}
new LandingPage();
$(document).ready(function() {
    ! function($) {
        "use strict";
        var CalendarPage = function() {};
        CalendarPage.prototype.init = function() {
                var addEvent = $("#event-modal");
                var modalTitle = $("#modal-title");
                var formEvent = $("#form-event");
                var selectedEvent = null;
                var newEventData = null;
                var forms = document.getElementsByClassName('needs-validation');
                var selectedEvent = null;
                var newEventData = null;
                var eventObject = null;
                var date = new Date();
                var d = date.getDate();
                var m = date.getMonth();
                var y = date.getFullYear();
                var calendarEl = document.getElementById('calendar');
                var calendar = new FullCalendar.Calendar(calendarEl, {
                    plugins: ['bootstrap', 'interaction', 'dayGrid', 'timeGrid'],
                    editable: true,
                    locale: 'es',
                    droppable: true,
                    selectable: true,
                    defaultView: 'dayGridMonth',
                    themeSystem: 'bootstrap',
                    header: {
                        left: 'prev,next today',
                        center: 'title',
                        right: 'dayGridMonth,timeGridWeek,timeGridDay,listMonth'
                    },
                    events: $registros,

                });
                calendar.render();
            },
            $.CalendarPage = new CalendarPage, $.CalendarPage.Constructor = CalendarPage
    }(window.jQuery),
    function($) {
        "use strict";
        $.CalendarPage.init()
    }(window.jQuery);


    
});

function verificar_eventos() {
    $(".fc-content a").addClass("ver_evento");
    $(".fc-content a").attr("target", "_blank");
}

$(".datatable").DataTable({  
            scrollY: "400px", // Altura máxima para el scroll
            scrollCollapse: true,
            fixedHeader: true,
            stateSave: false,
            ordering: true,
            order: [],
            destroy: true,
            drawCallback: function () {
                $('.dataTables_paginate > .pagination').addClass('pagination-rounded');
            },
             language: {
                    decimal: "",
                    emptyTable: "No hay datos disponibles en la tabla",
                    info: "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                    infoEmpty: "Mostrando 0 a 0 de 0 entradas",
                    infoFiltered: "(filtrado de _MAX_ entradas totales)",
                    infoPostFix: "",
                    thousands: ",",
                    lengthMenu: "Mostrar _MENU_ entradas",
                    loadingRecords: "Cargando...",
                    processing: "Procesando...",
                    search: "Buscar:",
                    zeroRecords: "No se encontraron registros coincidentes",
                    paginate: {
                        first: "Primero",
                        last: "Último",
                        next: "Siguiente",
                        previous: "Anterior"
                    },
                }
});


$(document).on('click', '.fc-event', function(event) {
            event.preventDefault();
           Fancybox.show([
                {
                    src:  $(this).attr('href'),
                    type: "iframe",
                    preload: true,
                },
                ]);
        
    });

$(document).on("click", ".btn_arch", function(e) {
    e.preventDefault();

    let uba_id = $(this).attr("data-uba");
    let btn = $(this);
    let originalText = btn.html();

    $(".btn_arch").removeClass('btn-primary').addClass('btn-light').prop('disabled', false).html(function() {
        return $(this).attr("data-uba") === uba_id 
            ? '<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Cargando...' 
            : $(this).html();
    });

    btn.prop('disabled', true).removeClass('btn-light').addClass('btn-primary')
       .html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Cargando...');

    let formData = new FormData();
    formData.append('uba_id', uba_id);

    fetch(`${host}landing_page/public_controller/load_arch_x_uba`, {
        method: "POST",
        body: formData
    })
    .then(response => {
        if (!response.ok) {
            throw new Error(`Error en la solicitud: ${response.statusText}`);
        }
        return response.json();
    })
    .then(data => {
        let table = data.archivos;
        let div = '';

        table.forEach((value, index) => {
            div += `
            <div class="document-card">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <div class="document-title">${value.arh_nombre}</div>
                        <div class="document-info">${value.arh_descripcion} - ${value.arh_fecha} 
                            - <small style='color:#833B79'><b>${value.arh_size}</b></small>
                        </div>
                    </div>
                    <button class="btn btn-descargar" data-url="${host}${value.url}" data-filename="${value.arh_nombre}">
                        Descargar
                    </button>
                </div>
            </div>`;
        });

        $(".archivos_container").html(div);
        
        btn.removeClass('btn-primary').addClass('btn-primary').prop('disabled', false).html(originalText);
    })
    .catch(error => {
        console.error('Error:', error);
        btn.removeClass('btn-primary').addClass('btn-danger').prop('disabled', false).html(originalText);
    });
});

$(document).on("click", ".btn-descargar", function(e) {
    e.preventDefault();

    let btn = $(this);
    let fileUrl = btn.data("url");
    let fileName = btn.data("filename");
    let originalText = btn.html();

    btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Descargando...');

    fetch(fileUrl)
        .then(response => {
            if (!response.ok) {
                throw new Error(`Error al descargar: ${response.statusText}`);
            }
            return response.blob(); 
        })
        .then(blob => {
            let link = document.createElement('a');
            link.href = window.URL.createObjectURL(blob);
            link.download = fileName; 
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);

            btn.prop('disabled', false).html(originalText);
        })
        .catch(error => {
            console.error('Error:', error);
            btn.removeClass('btn-primary').addClass('btn-danger').html('Error al descargar');
            setTimeout(() => {
                btn.removeClass('btn-danger').addClass('btn-primary').prop('disabled', false).html(originalText);
            }, 2000);
        });
});


$(document).on('click', '.btn.news-btn-custom', function(event) {
    event.preventDefault();
    var targetModal = $(this).attr('href');    
    Fancybox.show([{
       modal: false,
        width: '100%',
        height: 'auto',
        autoSize: true,
        closeClick: false,
        type: 'inline',
        src: targetModal,
        afterLoad: function() {
        },
        beforeClose: function() {}
    }]);
});




