$(document).on('click', '.carpeta', function (e) {
    e.preventDefault();

    const carpetaSeleccionada = $(this).data('carpeta');
    // Solicitud AJAX para obtener documentos
    $.ajax({
        url: `${host}landing_page/public_controller/get_documentos`,
        type: 'GET',
        data: { carpeta: carpetaSeleccionada },
        dataType: 'json',
        success: function (data) {
            const tabla = $('#documentosTabla');
            tabla.empty(); // Limpiar la tabla

            if (data.documentos && data.documentos.length > 0) {
                data.documentos.forEach((doc, index) => {
                    const fila = `
                        <tr>
                            <td>${index + 1}</td>
                            <td>${doc}</td>
                            <td>
                                <a href="${host}uploads/documentos_intranet/${carpetaSeleccionada}/${doc}" class="btn btn-sm" download>
                                    ➡️ Descargar
                                </a>
                            </td>
                        </tr>
                    `;
                    tabla.append(fila);
                });
            } else {
                tabla.html('<tr><td colspan="3" class="text-center">No se encontraron documentos en esta carpeta.</td></tr>');
            }

        },
        error: function (xhr, status, error) {
            console.error('Error al obtener los documentos:', error);
            const tabla = $('#documentosTabla');
            tabla.html('<tr><td colspan="3" class="text-center">Error al cargar los documentos.</td></tr>');
        }
    });
});
