$(document).ready(function () {

    $('select').select2({placeholder: "Seleccione una opción"});

    $(".txtFechas").datepicker('destroy');
    $(".txtFechas").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".txtFechas").mask("99-99-9999");
    $("#txt_fecha_inicio,#txt_fecha_fin").change(function(event){ 
        validar_fecha_inicio_fin('txt_fecha_inicio','txt_fecha_fin','La fecha de desde debe ser menor a la fecha hasta'); 
    });

    $("#slcTipoCuenta").change(function () {
        $("#slcTipoCuenta option:selected").each(function () {
            tipo_cnt = $('#slcTipoCuenta').val();
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: '<?php echo base_url(); ?>utm/transacciones/mostrar_cuentas',
                data: {tipo: tipo_cnt},
                success: function (data) {
                    $("#slcCuenta").html(data.drop);

                }
            });
        });
    });

    $("#btnConsultar").trigger('click');

    /*Busqueda*/
    $("#btnConsultar").click(function () {
        $("#txt_conciliar").val(0);
        var tipo_cuenta     = $("#slcTipoCuenta").val();
        var cuenta          = $("#slcCuenta").val();
        var estado          = $("#slcEstado").val();
        var fecha_inicio    = $("#txt_fecha_inicio").val();
        var fecha_fin       = $("#txt_fecha_fin").val();

        if (estado == '' || cuenta == '') {
            crear_alerta('info', 'Filtros', 'Complete los filtros requeridos.');
            return false;
        }

        if ( fecha_inicio != "" || fecha_fin  != "") {
            if ( fecha_inicio == "" ) {
                crear_alerta('error', 'Filtros', 'Ingrese fecha de desde.');
                return false;
            }

            if ( fecha_fin == "") {
                crear_alerta('error', 'Filtros', 'Ingrese fecha hasta.');
                return false;
            }
        } 

        $("#dv_contenedor_listado").hide('slide', {
            direction: 'right'
        },
                400, function () {
                    $.ajax({
                        url: window.gSateliteWhite.baseUrl('utm/cuentas/conciliacion/1'),
                        data: {
                            tipo_cuenta: tipo_cuenta, 
                            cuenta: cuenta, 
                            estado: estado,
                            fecha_inicio: fecha_inicio,
                            fecha_fin: fecha_fin
                        },
                        type: "post",
                        beforeSend: function () {
                            wait.start();
                            calcular_saldo_banco();
                        },
                        success: function (result) {
                            var oTabla = $("#tblListado").dataTable();

                            oTabla.fnDestroy();
                            $("#tbContenedorListado").html(result);

                            $("#dv_contenedor_listado").show("slide", {
                                direction: 'left'
                            }, 500);

                            var tipo_cuenta = $("#slcTipoCuenta").val();
                            var cuenta = $("#slcCuenta").val();
                            var estado = $("#slcEstado").val();

                            $("#filtro_tipo").val(tipo_cuenta);
                            $("#filtro_cuenta").val(cuenta);
                            $("#filtro_estado").val(estado);
                            $("#dvAcciones").show('500');
                            $(".soloNumeros").numeric();
                            setTimeout(function () {
                                aplicarEstiloCheckbox();
                                aplidarDataTable('tblListado');
                                wait.close();
                            }, 500);

                        }
                    });
                }
        );
    });

    $("#btnCrear").click(function () {
        wait.start();
        var oTabla = $("#tblListado").dataTable();
        oTabla.fnDestroy();
        localStorage.clear();
        if ($("#tbContenedorListado > tr .error").length > 0) {
            wait.close();
            crear_alerta('error', 'Agenda de pagos', 'Verifique los montos a pagar.');
            aplidarDataTable('tblListado');
            return false;
        }
    });

    $("#btnLimpiarAgenda").click(function () {
        wait.start();
        $(".montoPagar").val('');
        $("[name='tipoPagos[]'] option:selected").removeAttr('selected');
        $("[name='tipoPagos[]']").select2({placeholder: "Seleccione una opción"});

        setTimeout(function () {
            wait.close();
        }, 500);

    });

    $(".btnLimpiar").live('click', function () {
        var parent = $(this).parent().parent();

        var data_id = $("#" + parent[0].id).attr('data-id');

        $("#txtPagar_" + data_id).val('');
        $("#slcTipo_" + data_id + " option:selected").removeAttr('selected');
        $("#slcTipo_" + data_id + "").select2({placeholder: "Seleccione una opción"});
    });

    $(".montoPagar").live('keyup', function () {

        var montoPago = $(this).val();
        if (montoPago != '') {
            montoPago = parseFloat(montoPago);

            var parent = $(this).parent().parent();

            var data_id = $("#" + parent[0].id).attr('data-id');

            var saldo = $("#txtSaldoTotal_" + data_id).val().replace("$", "").replace(/,/g, "");

            saldo = parseFloat(saldo);

            if (saldo < montoPago) {
                $(this).addClass('error');
            } else {
                $(this).removeClass('error');
            }
        }
    });

    $(".ver-accion-modal").live('click', function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            width: '100%',
            closeBtn: true
        });
    });

    $(document).on('click','#enviar_excel', function(){
        var formData = new FormData(document.getElementById("form_carga_marcacion"));
            formData.append("dato", "valor");
        var file = $('#excel_plantilla').val();
        if (validar_archivo()) {


        if(file.length>0){
             $.ajax({
            url: window.gSateliteWhite.baseUrl('utm/cuentas/conciliacion_excel'),
            type: 'post',
            dataType: "html",
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            beforeSend: function(){
                wait.start();
            },
            success: function (response){
                wait.close();
                $("#cargar_data").html(response);
            }
        });
         }else{
            crear_alerta('error','Error al cargar','Selecciona un archivo.');
         }
        }
       
    });

    function validar_archivo() {
        valor = $("#excel_plantilla").val();
        if(valor!="") {
            extension = (valor.substring(valor.lastIndexOf("."))).toLowerCase(); 
              if(extension=='.xls'){
                return true;
              } else {
                $("#muestra_error_file").text('Debe ser un archivo excel con extención .xls');
               return false;
              }
        }
        else {
          $("#muestra_error_file").text('Archivo excel requerido');
          return false;
        }
      //compruebo si la extensión está entre las permitidas 
  }

    $(document).on('click','#enviar_data',function(){
                var procesados    = 0;
                var elemntos      = $('.valores_to_compare').length;
                // recorremos todos los elementos de la tabla que viene del excel
                $('.valores_to_compare').each(function(element){
                    // capturamos el valor del elemnto en la iteracion
                    find = $(this).val();
                    //recorremos la tabla principal en busca de este elemntos
                    $('.valoresx').each(function(element){
                        // capturamos el valor del elemento y la posicion de este
                        valor     = $(this).val();
                        posicion  = $(this).data('position');
                        if (valor == find) {
                            procesados ++;
                            id = $('.check_x'+posicion).attr('id');
                            $('#'+id).attr('checked',true);
                            $('#'+id).iButton("repaint");

                        }
                    }); 
                    
                });
                crear_alerta('success','Registros seleccionados','Total Procesados: '+ procesados+'\n Sin Prcesar: '+ (elemntos - procesados));
                $("#conciliacion_plantilla").modal('hide');
            });
});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 10,
        "bLengthChange": false,
        "bDestroy": true,
        "bStateSave": true,
        "fnStateSave" : function(oSettings, oData){
            console.log(oData);
            fnSaveTableLocalStorage(oData);
        },
        "fnStateLoad": function (oSettings) {
            var data = fnGetTableLocalStorage();
            return data;
        },
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function aplicarEstiloCheckbox() {
    $(".chkConciliar").iButton({
        'labelOn': 'Si',
        'labelOff': 'No',
        change: function (element) {
            var data_id = $("#" + element[0].id).attr('data-id');
            if (element.is(':checked')) {
                $("#hdnConciliar_" + data_id).val(1);
                $("#hdnAplicar_" + data_id).val(1);
            } else {
                $("#hdnConciliar_" + data_id).val(0);
                $("#hdnAplicar_" + data_id).val(0);
            }
        }
    });
}

function calcular_saldo_banco(){
    var banco = $("#slcCuenta").val();
    var fecha_inicio = $("#txt_fecha_inicio").val();
    var fecha_fin = $("#txt_fecha_fin").val();
    
    if ( banco != "" ) {
        $.ajax({
            url: window.gSateliteWhite.baseUrl('utm/cuentas/calcular_saldo_banco'),
            data: {
                banco: banco,
                fecha_inicio: fecha_inicio,
                fecha_fin: fecha_fin
            },
            type: "post",
            beforeSend: function () {
                wait.start();
            },
            success: function (result) {
                if ( result.trim() != "" ){
                    $("#txt_saldo_banco").val(result);
                } else {
                    $("#txt_saldo_banco").val(0);
                }
                diferencia();
            }
        });
    } else {
        $("#txt_saldo_banco").val(0);
    }

}

$( "#tblListado" ).on( "change", ".chkConciliar", function() {
    sumar_concilacion();
});

$( "#txt_saldo_final" ).keyup(function() {
    diferencia();
});

function sumar_concilacion(){
    wait.start();
    $("#tblListado").dataTable().fnDestroy(); 

    var suma = 0;
    $( ".chkConciliar" ).each(function( index ) {
        if ( $(this).is(':checked') ) {
            var id = $( this ).data("id");      
            valor = $( "#valor_conciliacion_" + id ).val();    
            suma = suma + parseFloat(valor.replace(',', "")); 
                 
        } 
    });
    //setTimeout(function() {
        wait.close();
    //}, 500);
    
    //$("#tblListado").dataTable();
    aplidarDataTable("tblListado");
    aplicarEstiloCheckbox();
    $("#txt_conciliar").val(round_number(suma,2));
    diferencia();
}

function diferencia(){
    var saldo_final = $("#txt_saldo_final").val();
    var saldo_banco = parseFloat($("#txt_saldo_banco").val());
    var concilacion = parseFloat($("#txt_conciliar").val());
    var diferencia  = 0;

    if ( saldo_final != "" && $.isNumeric(saldo_final) ) {
        saldo_final = parseFloat(saldo_final);
    } else {
        saldo_final = 0;
    }

    diferencia = saldo_final - (saldo_banco + concilacion);
    diferencia = number_format(diferencia,2,'.','')
    $("#txt_diferencia").val(diferencia);
}

function fnGetTableLocalStorage(){
    var data = localStorage.getItem("tblListado_state");
    if(data!=null){
        return JSON.parse(data)
    }
    return null;
}

function fnSaveTableLocalStorage(data){
    localStorage.setItem("tblListado_state", JSON.stringify(data));
}