$(document).ready(function () { 
    $(".datePicker").datepicker({
            showButtonPanel: true,
            changeMonth: true,
            changeYear: true,
            dateFormat: 'dd-mm-yy',
            monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
            dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
            nextText: "Siguiente",
            prevText: "Anterior",
            closeText: 'Cerrar',
            currentText: 'Hoy'
    });
    $(".datePicker").mask("99-99-9999");
   
    //Consultar los datos
    $("#btnConsultar").click(function() {
        var fecha_inicio   = $("#txtFechaIni").val();
        var fecha_fin      = $("#txtFechaFin").val();
        var proveedor      = $("#proveedor").val();
        var tp             = $("#tipo_retencion").val();
        var tipo           = $("#tipo_reporte").val();
        
        //Asignacion de valores a los campos ocultos para pdf        
        $("#htxtFechaIni").val(fecha_inicio);
        $('#htxtFechaFin').val(fecha_fin);
        $("#hslcProveedor").val(proveedor);
        $("#hslcTipoRetencion").val(tp);
        $('#hslcTipo').val(tipo);
                
        if(fecha_inicio != '' &&  fecha_fin != ''){
            $.ajax({
              dataType: 'text',
              type: 'POST',          
              url: urlj + 'utm/reporteria/generar_reporte_retension_pagos/',
              data: {fecha_inicio: fecha_inicio, fecha_fin: fecha_fin, proveedor:proveedor, tipo: tipo,tp:tp},              
              beforeSend: function () {
                wait.start();
              },
              success: function (data) {
                //var oTable = $('#tblListado').dataTable();
                //oTable.fnDestroy();

                $("#dv_contenedor_listado").html(data);
                aplidarDataTable('tblListado');

                $("#pdf").css("display", "");
                $("#excel").css("display", "");

                //$('#cuenta').html(data.options);
                
                //$('#cuenta').select2();            
                wait.close();            
              }                       
            });
        }else{            
            crear_alerta('error', 'Campos requeridos', 'Campos con asterisco son requeridos');
        }                
    });
        
    //Aplicar estilo a los select a algunos tab de ficha general
    $("#slcSeguimientoPor, #slcCliente").select2();

    //Ajax para carga de clientes
    $("#slcSeguimientoPor").change(function() {
        var seguimientopor = $("#slcSeguimientoPor").val();                
                
        if(seguimientopor > 0 ){
          $.ajax({
            dataType: 'text',
            type: 'POST',          
            url: urlj + 'cotizaciones/consultas/get_cliente_con_seguimiento',
            data: {seguimientopor: seguimientopor},
            beforeSend: function () {
              wait.start();
            },
            success: function (data) {                
              $('#slcCliente').html(data);                              
              wait.close();            
            }                       
          });
        }else{                        
          $('#slcCliente').html('');
          $('#slcCliente').select2('destroy');
          $('#slcCliente').select2();
        }                
    });

    $("#slcDepartamento").change(function(event) {
      
      if ($(this).val() > 0 ) {
        url_ajax = window.satelite.base_url('expediente_personal/empleado/filtrar_municipio_option');
         $.ajax({
             url: url_ajax,
             type: 'POST',
             dataType: 'json',
             data: {
                 slcDepartamento: $("#slcDepartamento").val()
             },
             beforeSend: function () {
                 wait.start('Cargando municipios...');
             },
             error: function (xhr, status, error){
              exportarError(xhr.responseText);
              wait.close();
          },
          success: function (json) {
              $("#slcMunicipio").html(json.options);
              $("#slcMunicipio").select2();
              wait.close();

          }
      });
       } else {
          $("#slcMunicipio").html('<option value=""></option>');
          $("#slcMunicipio").select2();
       }

    });
    
});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "aaSorting": [],
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

$('select').select2();