$(document).ready(function () {
    gSateliteWhite.jsSelect();
    $('select option[value=0]').val('');

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $("#slcBodega").select2();

    $("#form-cuentas_bancarias").validate({
        ignore:"",
        rules: {
            slcBanco:{ required:true, min:1}
        }, 
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre=$(element).attr("id");
            $('#'+nombre+'_error').text('Campo requerido');
        },
        submitHandler: function(form) {
            form.submit();
        }
    });

    $("#slcBanco").live('change', function(){
        var banco = $(this).val();
        if(banco != ''){
            $.ajax({
                type: 'POST',
                url: urlj + 'utm/reporteria/get_cuentas_banco',
                dataType: 'json',
                data: {banco: banco},
                beforeSend: function () {
                    wait.start();
                    $("#slcCuenta").attr("placeholder", "Cargando...");
                    $("#slcCuenta").select2();
                },
                success: function (data) {
                    $("#slcCuenta").attr("placeholder", "Seleccione");
                    $("#slcCuenta").html(data.cuentas);
                    $("#slcCuenta").select2();
                    wait.close();
                }
            });
        } else{
            $("#slcCuenta").html('<option value=""></option>');
            $("#slcCuenta").select2();
        }
    })

    //PDF o Excel
    $(".print").live('click',function(event){
        var tipo = $(this).val();
        $("#rpt_tipo").val(tipo);
        $("#form-cuentas_bancarias").submit();
    })

    /*Busqueda*/
    $("#btnConsultar").click(function(){
        var banco = $("#slcBanco").val();
        var cuenta = $("#slcCuenta").val();

        if(!$("#form-cuentas_bancarias").valid()){
          crear_alerta('error','Alerta','Campos con * son requeridos.');
          return false;
        }

        $("#dv_contenedor_reg").hide('slide',{
                direction:'right'
            },
            400,function(){
                $.ajax({
                   type:'post',
                   url:window.gSateliteWhite.baseUrl('utm/reporteria/resumen_cuentas_bancarias/1'),
                   data:{banco:banco, cuenta:cuenta},
                   beforeSend:function(){
                       wait.start();
                   },
                   success:function(result){
                        $('#rpt_slcBanco').val(banco)
                        $('#rpt_slcCuenta').val(cuenta)

                        $('#encabezado').show();
                        $("#dv_contenedor_reg").html(result);
                        aplidarDataTable('datagried')
                        $(".btn-info").show();
                        wait.close();
                        $("#dv_contenedor_reg").show("slide", {
                           direction: 'left'
                        }, 500);
                   }
                });
            }
        );

   });
   
}); //fin jquery

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}    
aplidarDataTable('datagried');