$(document).ready(function () {
    $('select option[value=0]').text('');
    $('select option[value=0]').val('');
    $('select').select2({placeholder: "Seleccione una opción"});
    //gSateliteWhite.jsSelect();

    $("#frm-reporte").validate({
        rules: {
            txtFechaIni: {required: true},
            txtFechaFin: {required: true},
            slcCuenta: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error', 'Campos necesarios', 'Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form) {
            if (!validarPeriodo($("#txtFechaIni").val(), $("#txtFechaFin").val())) {
                crear_alerta('error', 'Reporte de cheques emitidos', 'Verifique el período de las fechas.');
                return false;
            }
            $("#filtro_inicio").val($("#txtFechaIni").val());
            $("#filtro_fin").val($("#txtFechaFin").val());

            var banco = ($("#slcBanco").val() > 0) ? $("#slcBanco").val() : "";
            $("#filtro_banco").val(banco);

            form.submit();
        }
    });


    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask("99-99-9999");
    /*Busqueda*/
    $("#btnConsultar").click(function () {

        var cuenta = ($("#slcCuenta").val() > 0) ? $("#slcCuenta").val() : "";

        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        var aplicadas = ($('#aplicadas').prop('checked')===true)?1:0;

        if (cuenta == '' || fecha_ini == '' || fecha_fin == '') {
            crear_alerta('error', 'Filtros', 'Verifique los filtros de búsqueda.');
            return false;
        }

        if (!validarPeriodo(fecha_ini, fecha_fin)) {
            crear_alerta('error', 'Filtros', 'Verifique el período de las fechas.');
            return false;
        }


        $("#dv_contenedor_listado").hide('slide', {
            direction: 'right'
        },
                400, function () {
                    $.ajax({
                        type: 'post',
                        url: window.gSateliteWhite.baseUrl('utm/reporteria/reporte_libro_bancos/1'),
                        data: {cuenta: cuenta, fecha_ini: fecha_ini, fecha_fin: fecha_fin, aplicadas: aplicadas},
                        beforeSend: function () {
                            wait.start();
                        },
                        success: function (result) {
                            wait.close();
                            $(".print").show();
                            var cuenta = ($("#slcCuenta").val() > 0) ? $("#slcCuenta").val() : "";
                            var fecha_ini = $("#txtFechaIni").val();
                            var fecha_fin = $("#txtFechaFin").val();

                            $("#filtro_cuenta").val(cuenta);
                            $("#filtro_inicio").val(fecha_ini);
                            $("#filtro_fin").val(fecha_fin);
                            $('#aplica').val(aplicadas);
                            var oTable = $('#tblListado').dataTable();
                            oTable.fnDestroy();

                            $("#tbContenedorListado").html(result);
                            aplidarDataTable('tblListado');

                            $("#dv_contenedor_listado").show("slide", {
                                direction: 'left'
                            }, 500);

                        }
                    });
                }
        );
    });


    $(".ver-accion-modal").live('click', function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            //width:'100%',
            closeBtn: true
        });
    });
});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 10,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    if (Date.parse(fecha_i) == Date.parse(fecha_f)) {
        $("#fecha_fin_error").text('');
        return true;
    }

    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        $("#fecha_fin").addClass('error');
        $("#fecha_fin_error").text("Verifique las fechas del período");
        return false;
    }

    if (Date.parse(fecha_i) < Date.parse(fecha_f)) {
        $("#fecha_fin").removeClass('error');
        $("#fecha_fin_error").text('');
        return true;
    }
}