$(document).ready(function () {
    $('select option[value=0]').text('');
    $('select option[value=0]').val('');
    $('select').select2({placeholder: "Seleccione una opción"});

    $("#frm-reporte").validate({
        rules: {
            txtFechaIni: {required: true},
            txtFechaFin: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error', 'Campos necesarios', 'Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form) {
            if (!validarPeriodo($("#txtFechaIni").val(), $("#txtFechaFin").val())) {
                crear_alerta('error', 'Reporte de cheques emitidos', 'Verifique el período de las fechas.');
                return false;
            }
            $("#filtro_inicio").val($("#txtFechaIni").val());
            $("#filtro_fin").val($("#txtFechaFin").val());
            var banco = ($("#slcBanco").val() > 0) ? $("#slcBanco").val() : "";
            var cuenta = ($("#slcCuenta").val() > 0) ? $("#slcCuenta").val() : "";
            $("#filtro_banco").val(banco);
            $("#filtro_cuenta").val(cuenta);
            form.submit();
        }
    });


    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask("99-99-9999");

    $(document).on('change','#slcBanco', function() {
        if($('#slcBanco').val()>0) {
            $.ajax({
                type: "POST",
                dataType:'json',
                async: false,
                url: urlj+'utm/reporteria/get_bancos_cuentas',
                data: {banco:$('#slcBanco').val()},
                success: function(data){
                    $('#slcCuenta').html(data.html);
                }
            });
        }
    });

    $(document).on('change', '#slcCuenta', function(){
        $('#filtro_cuenta').val($(this).val());
    });

    /*Busqueda*/
    $("#btnConsultar").click(function () {
        var proveedor = $('#slcProveedor').val() > 0 ? $('#slcProveedor').val() : "";
        var banco = ($("#slcBanco").val() > 0) ? $("#slcBanco").val() : "";
        var cuenta = ($("#slcCuenta").val() > 0) ? $("#slcCuenta").val() : "";
        var estado =  ($("#slcEstado").val() !== '') ? $("#slcEstado").val() : "";
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        if (fecha_ini == '' || fecha_fin == '') {
            crear_alerta('error', 'Reporte de cheques emitidos', 'Fechas son obligatorias.');
            return false;
        }
        if (!validarPeriodo(fecha_ini, fecha_fin)) {
            crear_alerta('error', 'Reporte de cheques emitidos', 'Verifique el período de las fechas.');
            return false;
        }
        $("#dv_contenedor_listado").hide('slide', { direction: 'right' }, 400, function () {
            $.ajax({
                type: 'post',
                dataType:'json',
                url: window.gSateliteWhite.baseUrl('utm/reporteria/reporte_cheques_emitidos/1'),
                data: {
                    proveedor: proveedor, 
                    banco: banco, 
                    cuenta:cuenta, 
                    fecha_ini: fecha_ini, 
                    fecha_fin: fecha_fin,
                    estado:estado
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (result) {
                    wait.close();
                    $(".print").show();
                    var banco = ($("#slcBanco").val() > 0) ? $("#slcBanco").val() : "";
                    var fecha_ini = $("#txtFechaIni").val();
                    var fecha_fin = $("#txtFechaFin").val();
                    var prove = $("#slcProveedor").val(); 
                    var estado = $("#slcEstado").val();
                    $("#filtro_banco").val(banco);
                    $("#filtro_inicio").val(fecha_ini);
                    $("#filtro_fin").val(fecha_fin);
                    $("#filtro_proveedor").val(prove);
                    var oTable = $('#tblListado').dataTable();
                    oTable.fnDestroy();
                    $("#tbContenedorListado").html(result.tabla);
                    $("#tbFoot").html(result.pie);
                    aplidarDataTable('tblListado');
                    $("#dv_contenedor_listado").show("slide", { direction: 'left' }, 500);
                }
            });
                }
        );
    });


    $(".ver-accion-modal").live('click', function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            //width:'100%',
            closeBtn: true
        });
    });
});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    if (Date.parse(fecha_i) == Date.parse(fecha_f)) {
        $("#fecha_fin_error").text('');
        return true;
    }

    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        $("#fecha_fin").addClass('error');
        $("#fecha_fin_error").text("Verifique las fechas del período");
        return false;
    }

    if (Date.parse(fecha_i) < Date.parse(fecha_f)) {
        $("#fecha_fin").removeClass('error');
        $("#fecha_fin_error").text('');
        return true;
    }
}