$(document).ready(function () {
	$("#slcBanco, #slcCuenta").select2();    

    $("#slcCuenta").select2({placeholder: "Seleccione un Banco"});

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask("99-99-9999");

    $("#frm_cash_flow").validate({
        rules: {
            txtFechaIni: {required: true},
            txtFechaFin: {required: true},
            slcBanco: 	 {required: true},
            slcCuenta:   {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error', 'Campos necesarios', 'Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form){
            if (!validarPeriodo($("#txtFechaIni").val(), $("#txtFechaFin").val())) {
            	crear_alerta('error', 'Reporte Flujo de Efectivo', 'Verifique el período de las fechas.');
            	return false;
            }
            form.submit();
        }
    });


    $("#slcBanco").change(function (){
        var id_banco = $(this).val();
        if (id_banco != '' ) {
            $.ajax({
                dataType: 'text',
                type: 'post',
                data: {id_banco: id_banco},
                url: urlj + 'utm/reporteria/cuentas_x_bancos',
                success: function (data) {
                    $("#slcCuenta").html("");
                    $("#slcCuenta").html(data);
                    $("#slcCuenta").select2({placeholder: 'Seleccione'});        
                }
            });          
        } else {
        	$("#slcCuenta").html('<option value=""></option>');
        	$("#slcCuenta").select2({placeholder: "Seleccione un Banco"});            
        }
    });
    

    $("#btnConsultar").click(function() {
		event.preventDefault();
		$("#excel").css("display", "none");//ocultar los botones
		$("#pdf").css("display", "none");
        var txtFechaIni   	= $("#txtFechaIni").val();
        var txtFechaFin   	= $("#txtFechaFin").val();
        var slcBanco     	= $("#slcBanco").val();//id
        var slcCuenta    	= $("#slcCuenta").val();//id
        var slcBanco_text 	= $("#slcBanco option:selected").text();
        var slcCuenta_text 	= $("#slcCuenta option:selected").text();

        if (txtFechaIni == "" || txtFechaFin == "") {
			crear_alerta('error', 'Flujo de Efectivo', 'Por favor ingrese el rango de fechas.');
			return false;
		}
		if (!validarPeriodo(txtFechaIni, txtFechaFin)) {
			crear_alerta('error', 'Flujo de Efectivo', 'Verifique el período de fechas.');
			return false;
		}
		if (slcBanco == "" || slcCuenta == 0) {
			crear_alerta('error', 'Flujo de Efectivo', 'Por favor verifique la cuenta bancaria.');
			return false;
		}

		$("#h_txtFechaIni").val(txtFechaIni);
        $("#h_txtFechaFin").val(txtFechaFin);
        $("#h_slcBanco").val(slcBanco);
        $('#h_slcCuenta').val(slcCuenta);  
        $('#h_banco_txt').val(slcBanco_text);        
        $('#h_cuenta_txt').val(slcCuenta_text);

        $.ajax({
        	dataType: 'text',
        	type: 'POST',          
        	url: urlj + 'utm/reporteria/flujo_efectivo/1',
        	data: {
        		txtFechaIni: txtFechaIni, 
        		txtFechaFin: txtFechaFin, 
        		slcBanco: 	 slcBanco, 
        		slcCuenta: 	 slcCuenta, 
        		tipo_reporte: ""
        	},
        	beforeSend: function () {
        		wait.start();
        	},
        	success: function (data) {
                $("#dv_contenedor_listado").html(data);
                $("#pdf").css("display", "");
                $("#excel").css("display", "");                
                wait.close();            
            }                       
        });
        
    });

});