$(document).ready(function () {
    //gSateliteWhite.jsSelect();
    $('select option[value=0]').text('');
    $('select option[value=0]').val('');
    $('select').select2({placeholder: "Seleccione una opción"});

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask("99-99-9999");

    /*Busqueda*/
    $("#btnConsultar").click(function () {

        var cuenta = $("#slcCuenta").val();
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();


        if (fecha_ini == '' || fecha_fin == '') {
            crear_alerta('error', 'Notas de abono', 'Verifique el período de las fechas.');
            return false;
        }

        if (fecha_ini != '' && fecha_fin != '') {
            if (!validarPeriodo(fecha_ini, fecha_fin)) {
                crear_alerta('error', 'Notas de abono', 'Verifique el período de las fechas.');
                return false;
            }
        }

        $("#dv_contenedor").hide('slide', {
            direction: 'right'
        },
                400, function () {
                    $.ajax({
                        type: 'post',
                        url: window.gSateliteWhite.baseUrl('utm/cuentas/notas_abono/1'),
                        data: {cuenta: cuenta, fecha_ini: fecha_ini, fecha_fin: fecha_fin},
                        beforeSend: function () {
                            wait.start();
                        },
                        success: function (result) {
                            wait.close();
                            var oTabla = $("#tblListado").dataTable();

                            oTabla.fnDestroy();
                            $("#tbContenedorListado").html(result);

                            $("#dv_contenedor").show("slide", {
                                direction: 'left'
                            }, 500);
                            aplicarDataTable('tblListado');
                        }
                    });
                }
        );
    });

    $(".ver-accion-modal").live('click', function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            //width:'100%',
            closeBtn: true
        });
    });
});

function aplicarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}