$(document).ready(function () {
    $("select option[value='0']").text('');
    $("select option[value='0']").val('');
    $('select').select2({placeholder: "Seleccione una opción"});

    $(".txtFechas").datepicker('destroy');
    $(".txtFechas").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    $(".fecha").datepicker({dateFormat: 'dd-mm-yy', changeMonth: true, changeYear: true});
    $("#txtMonto").numeric();
    $(".txtFechas").mask('99-99-9999');

    var factura = "";
    var j = 1;
    var docs = [];
    var ediciones_pendientes = 0;

    $("#chkAplicarTrans").iButton({
        'labelOn': 'Si',
        'labelOff': 'No',
        change: function (element) {
            if (element.is(':checked')) {
                $("#hdnAplicarTrans").val(1);
            } else {
                $("#hdnAplicarTrans").val(0);
            }
        }
    });

    $(".anticipo_caja_chica").iButton({
        allowRadioUncheck: true,
        'resizeHandle': false,
        'resizeContainer': false,
        'labelOn': 'Si',
        'labelOff': 'No',
        change: function (element) {
            if (element.is(':checked') && element[0].id == 'cch_radio') {
                $("#caja_chica").show();
            } else {
                $("#caja_chica").hide();
            }
        }
    });

    //$("#frmAgregarCheque").validate({
    $("#frm-orden").validate({
        ignore: "",
        rules: {
            // txtOdenDe: {required: true},
            txtFechaNota: {required: true},
            slcBanco: {required: true},
            slcCuenta: {required: true},
            txtNumero: {required: true},
            txtConcepto: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html('Campo requerido');
        },

        submitHandler: function (form) {
            error = "";
            if ($("#tblDetalles .trDetalle").length == 0) {
                crear_alerta('error', 'Transferencia Bancaria', 'Debe agregar al menos un registro');
                return false;
            }
            if (ediciones_pendientes != 0) {
                crear_alerta('error', 'Transferencia Bancaria', 'Posee documentos sin guardar');
                return false;
            }
            if ($('#hnd_txtOdenDe').val() == "") {
                crear_alerta('error', 'Transferencia Bancaria', 'No ha agregado beneficiario');
                return false;
            }
            form.submit();
        }
    });

    /*$(".btn-success").click(function () {
     event.preventDefault();
     $("#valor").val($(this).val());
     if ($("#txtNumero").val() != "") {
     consultar_numero();
     } else {
     $("#frmAgregarCheque").submit();
     }
     });*/


    $("#slcBanco").change(function () {
        ban_id = $(this).val();
        if (ban_id > 0) {
            $.ajax({
                url: urlj + "utm/cuentas/obtener_cuenta",
                type: 'POST',
                dataType: 'json',
                data: {ban_id: ban_id},
                beforeSend: function () {
                    wait.start();
                },
                success: function (json) {
                    wait.close();
                    $('#slcCuenta').html(json.cuentas);
                    $('#slcCuenta').select2({placeholder: "Seleccione una opción"});
                    $("#lblSaldo").text('');
                    $("#mostrar_saldo").hide();
                    if (json.many_ctas == 1) {
                        $('#slcCuenta').trigger('change');
                    }
                }
            });
        } else {
            $('#slcCuenta').val('').trigger('change');
            $("#lblSaldo").text('');
            $("#mostrar_saldo").hide();
        }
    });


    $('#slcCuenta').live('change', function(event) {
        if ($(this).val()>0) {
            $.ajax({
               url: urlj + "utm/cuentas/obtener_cuenta",
                 type: 'POST',
                 data: { cuenta: $(this).val() },
                 dataType: 'json',
                 beforeSend: function () {
                     wait.start('Cargando...');
                },
                 error: function (xhr, status, error){
                  wait.close();
                },
                success: function (json) {
                    wait.close();
                    // DATOS para chequeras
                    $("#lblSaldo").text(json.saldo);
                    $("#mostrar_saldo").show('slow');
                }
            });
        } else {
            $("#lblSaldo").text('');
            $("#mostrar_saldo").hide('slow');
        }
    });

    $('#slcDocumento').select2('disable');
    $('#slc_cta_prv').select2('disable');

    $("#slcProveedor").change(function () {
        $("#slcDocumento").select2('data', null);
        $('#slc_cta_prv').select2('data', null);
        var ntp = $('#hdnNotaPendiente').val();
        if ($("#slcProveedor").val() == "") {
            $("#txtOdenDe").val('');
            $("#slcDocumento").select2('disable');
            $('#slc_cta_prv').select2('disable');
            $("#slcCuentaCont").select2('data', null);
            $("#slcCuentaCont").select2('enable');
        } else {
            var proveedor_text = $("#slcProveedor option:selected").text();
            proveedor_text = proveedor_text.split("-");
            $("#txtOdenDe").val(proveedor_text.pop());
            var proveedor = $("#slcProveedor").val();
            $.ajax({
                url: urlj + "utm/cuentas/get_cuentas_cuenta_proveedor",
                type: 'POST',
                dataType: 'json',
                data: {proveedor: proveedor, tipo: 'CUENTA_POR_PAGAR'},
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    wait.close();
                    $("#slcCuentaCont").select2('data', {id: data.cuenta, text: data.cuenta_nombre});
                    $("#slcCuentaCont").select2('disable');
                }
            });
            //traemos los dpv y las cuentas
            $.ajax({
                url: urlj + "utm/cuentas/get_dpvsx",
                type: 'POST',
                dataType: 'json',
                data: {prv: proveedor},
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    wait.close();
                    $("#slc_cta_prv").html(data.bancos);
                    $("#slc_cta_prv").select2();
                    if (ntp == '') {
                        $("#slcDocumento").html(data.options);
                        $("#slcDocumento").select2();
                    }                    
                }
            });
            $("#slc_cta_prv").select2('enable');
            if (ntp == '') {
                $("#slcDocumento").select2('enable');
            }            
        }
    });

    $("#slc_cta_prv").change(function () {
        var ntp = $('#hdnNotaPendiente').val();
        if (ntp != '') {
            html = '';
            if ($(this).val() != '') {
                var nombre_cta_banco_proveedor  = $("#slc_cta_prv option:selected").text();
                var id_dbp_banco_proveedor      = $("#slc_cta_prv").val();
                var id_banco_proveedor          = $("#slc_cta_prv option:selected").data("banco");
                html += '<input type="hidden" id="ban_prov_' + row + '" name="hdn_ban_prv[]" class="tables-input" value="' + id_banco_proveedor + '" />';
                html += '<input type="hidden" id="dbp_prov_' + row + '" name="hdn_dbp_prv[]" class="tables-input" value="' + id_dbp_banco_proveedor + '" />';
                html += '<label id="txt_name_cuenta_prov_' + row + '" class="text tables-input">' + nombre_cta_banco_proveedor + '</label>';
                $("#cta_prv").append(html   );
            }else{
                $("#cta_prv").html('');
            }            
        }
    });

    $("#slcCuentaCont").select2({
        placeholder: "Buscar Cuenta Contable",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'utm/cuentas/get_cuentas_contables_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (cuenta) {
                return {
                    cuenta: cuenta
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.cuenta,
                        'text': item.cuenta_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });


    $(".myModal").fancybox({
        width: '40%',
        height: 'auto',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        beforeLoad: function () {

        },
        beforeClose: function () {

        }
    });

    $("body").on('keypress', '.numero', function (event) {
        $(this).numeric();
        var text = $(this).val();
        if ((text.indexOf('.') != -1) && (text.substring(text.indexOf('.')).length > 2) && (event.which != 0 && event.which != 8) && ($(this)[0].selectionStart >= text.length - 2)) {
            event.preventDefault();
        }
    });
    $("#slcDocumento").select2('disable');

    var row = 0;
    if ($('#tbDetalles .trDetalle').length > 0) {
        row = $("#tbDetalles .trDetalle").length;
    }

    $("#btnAgregar").live("click", function (event) {
        event.preventDefault();
        var tipo = $("#txtTipo").val();
        var serie = $("#txtSerie").val();
        var factura = "";
        var txt_factura = "";
        var slcDocumento = $("#slcDocumento").val();
        var monto = $.trim($("#txtMonto").val());
        monto = monto.replace('$', '').replace(',', '');
        var monto_sujeto = 0.00;
        var retencion = 0.00;
        var total = monto;
        var repetido = false;
        var proveedor = "";
        var monto_pendiente = $("#txtTmpMontoPendiente").val();
        var cuenta = $("#slcCuentaCont").val();
        if (cuenta > 0) {
            var txtCuenta = $('#slcCuentaCont').next().text();
        } else {
            var txtCuenta = '';
        }
        var proyecto_id                 = $("#slc_proyecto").val();
        var presupuesto                 = $("#slc_presupuesto").val();
        var actividad_general           = $("#slc_actividad_general").val();
        var actividad_especifica        = $("#slc_actividad_espeficifica").val();
        var txt_actividad_espeficifica  = $("#slc_actividad_espeficifica option:selected").data("nombre");
        var nombre_cta_banco_proveedor  = $("#slc_cta_prv option:selected").text();
        var id_dbp_banco_proveedor      = $("#slc_cta_prv").val();
        var id_banco_proveedor          = $("#slc_cta_prv option:selected").data("banco");
        id_banco_proveedor              = (typeof id_banco_proveedor == 'undefined') ? '' : id_banco_proveedor;
        var descripcion = $('#txtOdenDe').val();
        var prov_nombre = $('#txtOdenDe').val();
        descripcion += ($("#txtDescripcion").val().trim() != '') ? ' (' + $("#txtDescripcion").val() + ')' :'';

        if (monto <= 0 || monto == "") {
            crear_alerta('error', 'Transferencia Bancaria', 'Favor agregue un monto');
            $('#txtMonto').focus();
            return false;
        }
        if (!($.isNumeric(monto))) {
            crear_alerta('error', 'Transferencia Bancaria', 'Favor ingrese un monto válido');
            $('#txtMonto').focus();
            return false;
        }
        if (slcDocumento != '') {
            if (parseFloat(monto) > parseFloat(monto_pendiente)) {
                crear_alerta('error', 'Transferencia Bancaria', 'El monto no puede ser mayor a la deuda de la factura (' + monto_pendiente + ')');
                $('#txtMonto').focus();
                return false;
            }
        }
        if (slcDocumento != '') {
            if ($.inArray(slcDocumento, docs) < 0) {
                docs.push(slcDocumento);
            } else {
                crear_alerta('error', 'Transferencia Bancaria', 'Factura ya fue agregada');
                $("#slcProveedor").val('').trigger('change');
                $("#txtTipo").val('');
                $("#txtSerie").val('');
                return false;
            }
            // if ($(".facturaDetalle option[value='" + slcDocumento + "']").length > 0) {
            //     crear_alerta('error', 'Cheques', 'Factura ya fue agregada');
            //     $("#txtTipo").val('');
            //     $("#txtSerie").val('');
            //     return false;
            // }
            txt_factura = $("#slcDocumento").next('div').text();
            proveedor = $('#slcProveedor').val();
        }


        monto = parseFloat(monto);
        total = parseFloat(total);
        var html = '<tr id="tr_Detalle_' + row + '" class="trDetalle">';

        html += '<td>';
            html += '<label id="txtTablaTipo_' + row + '" class="text tables-input select-text">' + tipo + '</label>';
            
            html += '<input id="txt_tabla_proyecto' + row + '" name="txt_tabla_proyecto[]" type="hidden" class="text " value="' + proyecto_id + '" style="display: none;"/>';
            html += '<input id="txt_presupuesto' + row + '" name="txt_presupuesto[]" type="hidden" class="text tables-input" readonly="readonly" value="' + presupuesto + '" />';
            html += '<input id="txt_actividad_general' + row + '" name="txt_actividad_general[]" type="hidden" class="text tables-input" readonly="readonly" value="' + actividad_general + '" />';
            html += '<input id="txt_actividad_especifica' + row + '" name="txt_actividad_especifica[]" type="hidden" class="text tables-input" readonly="readonly" value="' + actividad_especifica + '" />';
            html += '<input id="txt_actividad_espeficifica_text' + row + '" name="txt_actividad_espeficifica_text[]" type="hidden" class="text tables-input" readonly="readonly" value="' + txt_actividad_espeficifica + '" />';
            html += '<input type="hidden" class="destinatario" value="'+proveedor+'" data-nombre="'+prov_nombre+'">';

        html += '</td>';

        html += '<td>';
        html += '<label id="txtTablaSerie_' + row + '" class="text tables-input select-text">' + serie + '</label>';
        html += '</td>';

        html += '<td>';
        html += '<label id="txtTablaTextoFactura_' + row + '" class="text tables-input select-text">' + txt_factura + '</label>';
        html += '<input id="txtTablaProveedor_' + row + '" name="txtTablaProveedor[]" type="hidden" value="' + proveedor + '" />';
        html += '<input type="hidden" id="txtTablaFactura_' + row + '" name="hdnFactura[]" class="tables-input facturaDetalle" value="' + slcDocumento + '" />';
        html += '</td>';

        html += '<td>';
        html += '<textarea id="txtTablaDescripcion_' + row + '" name="txtTablaDescripcion[]" type="text" class="text tables-input-show tables-input" readonly="readonly" maxlength="300" style="resize:none;">' + descripcion + '</textarea>';
        html += '</td>';

        html += '<td>';
        html += '<input type="hidden" id="ban_prov_' + row + '" name="hdn_ban_prv[]" class="tables-input" value="' + id_banco_proveedor + '" />';
        html += '<input type="hidden" id="dbp_prov_' + row + '" name="hdn_dbp_prv[]" class="tables-input" value="' + id_dbp_banco_proveedor + '" />';
        html += '<label id="txt_name_cuenta_prov_' + row + '" class="text tables-input">' + nombre_cta_banco_proveedor + '</label>';
        html += '</td>';

        html += '<td style="width:auto;">';
        html += '<input id="txtTablaCuenta' + row + '" name="txtTablaCuenta[]" type="hidden" class="text tables-input tables-input" readonly="readonly" value="' + cuenta + '"  maxlength="10"/>';
        html += '<textarea id="TablaCuenta' + row + '" style="width:auto !important;resize: none;" type="text" class="text tables-input tables-input" readonly="readonly" >' + txtCuenta + '</textarea>';
        html += '</td>';

        html += '<td>';
        html += '<input id="txtTablaMonto' + row + '" name="txtTablaMonto[]" type="text" class="text tables-input-show tables-input soloNumeros  monto numeric numero" extras="." readonly="readonly" value="' + monto.toFixed(2) + '"  maxlength="19"/>';
        html += '</td>';

        html += '<td>';
        html += '<input id="txtTablaMontoSujeto' + row + '" name="txtTablaMontoSujeto[]" type="text" class="text tables-input monto_sujeto" readonly="readonly" value="' + monto_sujeto.toFixed(2) + '" maxlength="19" />';
        html += '<input id="txtTablaMontoPendiente' + row + '" name="txtTablaMontoPendiente[]" type="hidden" readonly="readonly" value="' + monto_pendiente + '" maxlength="19" />';
        html += '</td>';

        html += '<td>';
        html += '<input id="txtTablaRetenciones_id' + row + '" name="txtTablaRetenciones_id[]" type="hidden" class="text tables-input" readonly="readonly" value="" />';
        html += '<input id="txtTablaRetenciones_porcentaje' + row + '" name="txtTablaRetenciones_porcentaje[]" type="hidden" class="text tables-input" readonly="readonly" value=""  maxlength="19"/>';
        html += '<input id="txtTablaRetencion' + row + '" name="txtTablaRetencion[]" type="text" class="text tables-input" readonly="readonly" value="' + retencion.toFixed(2) + '"  maxlength="19" />';
        html += '</td>';

        html += '<td>';
        html += '<input id="txtTablaTotal' + row + '" name="txtTablaTotal[]" type="text" class="text tables-input subtotal" readonly="readonly" value="' + total.toFixed(2) + '"  maxlength="19"/>';
        html += '</td>';

        html += '<td>';
        html += '<button type="button" id="btnTablaGuardar' + row + '" class="btn btn-primary btn-mini btnGuardarChe" style="margin-right: 5px;float: left; height: 30px; width: 50px;display: none;" value="' + row + '">Guardar</button>';
        html += '<button type="button" id="btnTablaEditar' + row + '" class="btn btn-primary btn-mini btnEditChe" style="margin-right: 5px;float: left; height: 30px; width: 50px; display: block;" value="' + row + '">Editar</button>';
        html += '<button type="button" data-fact="'+slcDocumento+'" class="btn btn-danger btn-mini btnDelChe" style="float:left; /*margin-left:5%;*/ height:30px;width:50px;">Eliminar</button>';
        html += '<a href="#myModal" style="margin-left: 10px;" class="myModal icon-table btnRetChe" id="' + row + '"><span class="icon16 icomoon-icon-list-view-2" value="' + row + '"></span></a>';
        html += '</td>';

        html += '</tr>';

        var oTable = $('#tblDetalles').dataTable();
        row++;
        content += html;
        //Se destruye el datatable para luego volver a crearla
        oTable.fnDestroy();

        $("#tbDetalles").append(html);
        aplicarDataTable('#tblDetalles');

        $("#slcFactura option:selected").removeAttr('selected');

        $("#txtDescripcion").val('');
        $("#txtMonto").val('');

        $("#txtTipo").val('');
        $("#txtSerie").val('');
        $("#txtTmpMontoPendiente").val('0');

        $("#slcDocumento").select2('data', null);

        total_monto();
        total_monto_sujeto();
        sumatoria_monto();

        var disponible = $("#lblSaldo").text();
        var monto_total = parseFloat($("#txt_valor_monto").val());
        if(disponible!=''){
            disp = parseFloat(disponible);
        }else{
            disp = 0;
        }

        if(monto_total > disp){
            crear_alerta('error', 'Monto superior', 'El monto ingresado es mayor que el disponible.');
        }
        // $("#slcProveedor").select2('disable');
        destinatarios();
        $("#slcProveedor").val('').trigger('change');
    });

    //Guardar cheque
    $(".btnGuardarChe").live('click', function () {
        event.preventDefault();
        var parent = $(this).parent().parent();
        var tr_id = $(this).val();

        if ($('#txtTablaMonto' + tr_id).val() == "" || $('txtTablaMonto' + tr_id).val() <= 0) {
            $('#txtTablaMonto' + tr_id).focus();
            crear_alerta('error', 'Transferencia Bancaria', 'EL monto debe ser mayor a 0');
            return false;
        }

        if (parseFloat($('#txtTablaMonto' + tr_id).val()) < parseFloat($('#txtTablaMontoSujeto' + tr_id).val())) {
            crear_alerta('error', 'Transferencia Bancaria', 'Monto no puede ser menor al monto sujeto');
            $('#txtTablaMonto' + tr_id).focus();
            return false;
        }

        if ($("#txtTablaFactura" + tr_id).val() != '') {
            if (parseFloat($('#txtTablaMonto' + tr_id).val()) > parseFloat($('#txtTablaMontoPendiente' + tr_id).val())) {
                crear_alerta('error', 'Transferencia Bancaria', 'El monto no puede ser mayor a la deuda de la factura (' + $('#txtTablaMontoPendiente' + tr_id).val() + ')');
                $('#txtTablaMonto' + tr_id).focus();
                return false;
            }
        }
        var monto = $.trim($('#txtTablaMonto' + tr_id).val());
        monto = parseFloat(monto.replace('$', '').replace(',', ''));

        $('#txtTablaMonto' + tr_id).val(monto.toFixed(2));
        //txtTablaMonto[]

        var total = parseFloat($('#txtTablaMonto' + tr_id).val() - $('#txtTablaRetencion' + tr_id).val());
        $('#txtTablaTotal' + tr_id).val(total.toFixed(2));

        $("#" + parent[0].id + " .tables-input-show").addClass('tables-input');
        $("#" + parent[0].id + " .tables-input-show").attr('readonly', 'readonly');

        $(this).hide();
        $("#" + parent[0].id + " .btnEditChe").show();
        total_monto();
        total_monto_sujeto();
        sumatoria_monto();
        ediciones_pendientes = ediciones_pendientes - 1;

        var newID = $(this).val();
        $("#" + newID).show();
    });

    //Editar cheque
    $(".btnEditChe").live('click', function () {
        ediciones_pendientes++;
        var parent = $(this).parent().parent();

        $("#" + parent[0].id + " .tables-input-show").removeClass('tables-input');
        $("#" + parent[0].id + " .tables-input-show").removeAttr('readonly');

        $(this).hide();
        $("#" + parent[0].id + " .btnGuardarChe").show();

        var newID = $(this).val();
        $("#" + newID).hide();
    });

    //Retencion de cheque
    $(".btnRetChe").live('click', function () {
        event.preventDefault();

        var id = $(this).attr('id');
        $("#btnTablaDet" + id).show();

        var nota_pendiente = $("#hdnNotaPendiente").val();

        $('#sujeto').val('');
        $("#slcRetenciones").select2('data', null);
        $('#slcRetenciones').select2();

        var seleccionados = $('#txtTablaRetenciones_id' + id).val();
        var seleccionados_array = seleccionados.split(',');

        $('#sujeto').val($('#txtTablaMontoSujeto' + id).val());

        if (seleccionados != "") {
            $("#slcRetenciones option").each(function () {
                if (jQuery.inArray($(this).val(), seleccionados_array) != -1) {
                    $(this).attr("selected", "selected");
                }
            });
            $("#slcRetenciones").select2();
        }
        $('#txtTmpRetencion').val(id);

        if (nota_pendiente > 0) {
            $('#sujeto').attr('readonly', 'readonly');
            $("#slcRetenciones").select2('disable');
            $("#guardar_modal").hide();
        }
    });

    //eliminar
    $('#tblDetalles tbody').on('click', '.btnDelChe', function () {
        //Eliminar la factura del array de documentos
        var fac = $(this).data('fact').toString();;
        id = $.inArray(fac, docs);
        docs.splice(id, 1);
        //Eliminar la fila
        var table = $('#tblDetalles').DataTable();
        var parent = $(this).parent().parent();
        var nRow = $(parent).attr("id");
        table.fnDeleteRow(parent[0], null, true);
        destinatarios();
        total_monto();
        contar_filas();
        total_monto_sujeto();
        sumatoria_monto();
    });

    $("#slcDocumento").change(function () {
        get_datos_factura();
    });

    $("#guardar_modal").live("click", function () {
        event.preventDefault();

        var id = $('#txtTmpRetencion').val();
        var error = false;
        var porcentaje = 0;
        var retenciones = "";
        var porcentaje_tabla = "";
        var cantidad_seleccionados = 0;

        if ($('#sujeto').val() == "") {
            crear_alerta('error', 'Transferencia Bancaria', 'Ingrese el valor sujeto a retención');
            $('#sujeto').focus();
            error = true;
            return false;
        }

        if ($('#slcRetenciones').val() == "") {
            crear_alerta('error', 'Retención', 'Seleccione un tipo de retención');
            $('#sujeto').focus();
            error = true;
            return false;
        }

        if (parseFloat($('#sujeto').val()) > parseFloat($('#txtTablaMonto' + id).val())) {
            crear_alerta('error', 'Retención', 'Valor sujeto a retención es mayor que el monto, ($' + $('#txtTablaMonto' + id).val() + ')');
            $('#sujeto').focus();
            error = true;
            return false;
        }

        $('#slcRetenciones :selected').each(function (i, selected) {
            retenciones = retenciones + $(selected).val() + ",";
            porcentaje = porcentaje + $(selected).data("valor");
            porcentaje_tabla = porcentaje_tabla + $(selected).data("valor") + ",";
            cantidad_seleccionados++;
        });

        /*if ($('#sujeto').val() <= 0) {
         crear_alerta('error', 'Retención', 'Valor sujeto debe ser mayor a 0');
         $('#sujeto').focus();
         error = true;
         return false;
         }*/

        if (cantidad_seleccionados <= 0 && $('#sujeto').val() > 0) {
            crear_alerta('error', 'Retención', 'Debe seleccionar una retención');
            error = true;
            return false;
        }

        if (cantidad_seleccionados > 0 && $('#sujeto').val() <= 0) {
            crear_alerta('error', 'Retención', 'Valor sujeto debe ser mayor a 0');
            error = true;
            return false;
        }

        retenciones = retenciones.substring(0, retenciones.length - 1);
        porcentaje_tabla = porcentaje_tabla.substring(0, porcentaje_tabla.length - 1);

        $('#txtTablaRetenciones_id' + id).val(retenciones);
        $('#txtTablaRetenciones_porcentaje' + id).val(porcentaje_tabla);

        var sujeto = parseFloat($('#sujeto').val());

        calculo_retencion(porcentaje, sujeto.toFixed(2), id);

        if (error == false) {
            $.fancybox.close();
        }
    });

    $(document).on('click', '.fancy_detalle_partida', function(event) {                
        $.fancybox({
            modal: false,
            closeClick: false,
            width: '100%',
            height: '100%',
            autoSize: false,            
            closeBtn: false,
            helpers:{
                overlay:{closeClick:false}
            },
            type: 'inline',                        
            href: $(this).attr('href'),         
            afterLoad: function () {
                //Cargar valores sugeridos para concepto y fecha de la partida
                $('#concepto_gral').val(($('#txtNumero').val() === undefined) ? 'Transferencia #' : 'Transferencia #'+$('#txtNumero').val());
                if($('#fecha').val()==''){
                    $('#fecha').val($('#txtFechaNota').val());    
                }
                setTimeout(function() {
                    $('.fancybox-outer .fancy_detalle_partida').select2();    
                }, 500);
                wait.close();
            },
            beforeClose: function () {
                var rowCount = $('#contenedor_detalle tr').length;
                var fe = $('#fecha').val();
                var co = $('#concepto_gral').val();
                var ti = $('#tipo').val();
                if(rowCount > 0){
                    if(fe && co && ti){//Tiene Fecha
                        return true;
                    }else{//No tiene Fecha
                        crear_alerta('error', 'Transferencia Bancaria', 'Debe agregar concepto, tipo, fecha');
                        return false;
                    }  
                }
                $('.fancybox-outer .fancy_detalle_partida').select2('destroy');
            }        
        });        
    });

    $(document).on('change', '#slcProveedor', function() {
        val = $(this).val();
        if(val.length > 0){
            $('#link_modal').css('display', 'none');
            $('#contenedor_detalle').html('');
        }else{
            $('#link_modal').css('display', '');
        }
    });

    $("#slc_proyecto").change(function (){
        var proyecto = $(this).val();
        if ( proyecto != "" ) {
            $.ajax({
                dataType: 'text',
                type: 'post',
                data: {proyecto: proyecto},
                url: urlj + 'utm/cuentas/get_presupuestoxproyecto',
                success: function (data) {
                    $("#slc_presupuesto").html("");
                    $("#slc_presupuesto").html(data);
                    $("#slc_presupuesto").select2({placeholder: 'Seleccione una opción'});
                }
            });
        } else {
            $("#slc_presupuesto").html('<option value=""></option>');
            $("#slc_presupuesto").select2({placeholder: 'Seleccione una opción'});
        }
    });

    $("#slc_presupuesto").change(function (){
        var presupuesto = $(this).val();
        if ( presupuesto != "" ) {
            $.ajax({
                dataType: 'text',
                type: 'post',
                data: {presupuesto: presupuesto},
                url: urlj + 'utm/cuentas/get_actividades_generalesxpresupusto',
                success: function (data) {
                    $("#slc_actividad_general").html("");
                    $("#slc_actividad_general").html(data);
                    $("#slc_actividad_general").select2({placeholder: 'Seleccione una opción'});
                }
            });
        } else {
            $("#slc_actividad_general").html('<option value=""></option>');
            $("#slc_actividad_general").select2({placeholder: 'Seleccione una opción'});
        }
    });

    $("#slc_actividad_general").change(function (){
        var general     = $(this).val();
        var presupuesto = $("#slc_presupuesto").val();
        if ( general != "" ) {
            $.ajax({
                dataType: 'text',
                type: 'post',
                data: {general: general,presupuesto:presupuesto},
                url: urlj + 'utm/cuentas/get_actividades_especificas_x_actividad_general',
                success: function (data) {
                    $("#slc_actividad_espeficifica").html("");
                    $("#slc_actividad_espeficifica").html(data);
                    $("#slc_actividad_espeficifica").select2({placeholder: 'Seleccione una opción'});
                }
            });
        } 
    });

});

function aplicarDataTable(idTabla) {
    $(idTabla).dataTable({
        "bPaginate": false,
        "bInfo": false,
        "bSort": false,
        "bFilter": false,
    });
}

function get_datos_factura() {
    var result = null;
    if ($('#slcDocumento').val() != "") {
        var id_factura = $('#slcDocumento').val();
        $.ajax({
            url: urlj + "utm/cuentas/get_datos_factura",
            type: 'POST',
            dataType: 'json',
            data: {id_factura: id_factura},
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                wait.close();
                $("#txtTipo").val(data[0].tif_abreviacion);
                $("#txtSerie").val(data[0].dpv_serie_documento);
                var pendiente = parseFloat(data[0].dpv_monto_pendiente).toFixed(2);
                var descripcion = data[0].dpv_descripcion;

                $("#txtDescripcion").val(descripcion);
                $("#txtMonto").val(pendiente);
                $("#txtTmpMontoPendiente").val(pendiente);
            }
        });
    } else {
        ("#txtDescripcion").val('');
        $("#txtMonto").val('');
        $("#txtTmpMontoPendiente").val('');
    }
}

function consultar_numero() {
    numero = $("#txtNumero").val();
    id_chequera = $("#slcChequera").val();
    $.ajax({
        url: urlj + "utm/cuentas/validar_num_cheque",
        type: 'POST',
        dataType: 'json',
        data: {id_chequera: id_chequera, numero: numero},
        success: function (data) {
            if (data.resp == 1) {
                crear_alerta('error', 'Informaci&oacute;n', 'El número de cheque fuera del rango');
                $("#txtNumero").val('');

            }
            if (data.resp == 2) {
                crear_alerta('error', 'Informaci&oacute;n', 'El número de cheque ya fue usado');
                $("#txtNumero").val('');
            }
            $("#frmAgregarCheque").submit();
        }
    });
}

function calculo_retencion(porcentaje, valor_sujeto, id) {
    var retencion = 0;
    var sub_total = 0;

    retencion = (valor_sujeto * porcentaje) / 100;
    sub_total = $('#txtTablaMonto' + id).val() - retencion;
    $('#txtTablaMontoSujeto' + id).val(number_format(valor_sujeto, 2));
    $('#txtTablaRetencion' + id).val(number_format(retencion, 2));
    $('#txtTablaTotal' + id).val(number_format(sub_total, 2));

    $('#sujeto').val('');
    $("#slcRetenciones").select2('data', null);
    total_monto();
    total_monto_sujeto();
    sumatoria_monto();
    $.fancybox.close();
}

//subtotal
function total_monto() {
    suma = 0;
    celda = "";
    $('.subtotal').each(function () {
        celda = $(this).val();
        suma += parseFloat(celda || 0, 10);
    });
    suma = suma.toFixed(2);
    $('#txt_valor_monto').val(suma);
}

function total_monto_sujeto() {
    suma = 0;
    celda = "";
    $('.monto_sujeto').each(function () {
        celda = $(this).val();
        suma += parseFloat(celda || 0, 10);
    });
    suma = suma.toFixed(2);
    $('#txt_total_monto_sujeto').val(number_format(suma, 2));
}

function contar_filas() {
    var suma = 0;
    $(".tr_cheque").each(function () {
        suma++;
    });

    if (suma == 0) {
        $("#slcProveedor").select2('enable');
    }
}

//sumataria de monto
function sumatoria_monto() {
    suma = 0;
    celda = "";
    $('.monto').each(function () {
        celda = $(this).val();
        suma += parseFloat(celda || 0, 10);
    });
    suma = suma.toFixed(2);
    $('#txt_total_monto').val(suma);
}

function destinatarios() {
    var ids = [];
    var nombre = '';
    $('.destinatario').each(function () {
        actual = $(this).val();
        if ($.inArray(actual, ids) < 0) {
            ids.push(actual);
            if (ids.length == 1) {
                nombre = $(this).data('nombre');
            }
        }else{
            nombre = $(this).data('nombre');
        }
    });
    if (ids.length > 1) {
        nombre = 'Varios Proveedores';
    }
    $('#hnd_txtOdenDe').val(nombre);
}

$('#guardar_detalles_ptda').on('click',function(event){
    event.preventDefault();
    var debe  = (isNaN(parseFloat($('#total_debe').val()))) ? 0 : parseFloat($('#total_debe').val());
    var haber  = (isNaN(parseFloat($('#total_haber').val()))) ? 0 : parseFloat($('#total_haber').val());
    if (debe > 0 && haber >0){
        if (parseFloat(debe) != parseFloat(haber)) {
            crear_alerta('error','Error al Procesar','Revisa los datos ingresados, Debe y Haber no coniciden');
        }else{
            $.fancybox.close();
        }
    }else{
        crear_alerta('info','Error al procesar','Revisa los datos ingresados');
    }
    return false;
});