$(document).ready(function() {
    $("#slcBanco, #slcTipoCuenta, #slcOrigenFondos, #centro_costo_cec, #tipo_cuenta_tcn, #slcEstado, #slcChequeDefecto").select2();

    // $(".ibutton-label-on span:first label").text("SI");
    // $(".ibutton-label-off span:first label").text("NO");
    // Clase Fecha
    $(".fecha").datepicker('destroy');
    $(".fecha").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'yy-mm-dd',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy',
        //minDate: 0
    });

    // Campos requeridos
    $("#frmCuentaBancaria").validate({
        ignore:"",
        rules: {
            slcBanco:           { required:true },
            txtNumeroCuenta:    { required:true },
            txtSaldoActual:     { required:true },
            slcEstado:          { required:true },
            slcTipoCuenta:      { required:true },
            txtNombreCuenta:    { required:true },
            txtSaldInicial:     { required:true }
        }, 
        
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre=$(element).attr("id");
            $('#'+nombre+'_error').html(error);
        },
        submitHandler: function(form) {
            form.submit();
        }
    });

    $("#chkPermiteSobregiro").iButton({
        'labelOn': 'Si',
        'labelOff': 'No',
        change: function (element) {
            if (element.is(':checked')) {
                $('#div_monto_sg').show();
            }else{
                $('#txtMontoSobgiro').val('');
                $('#div_monto_sg').hide();
            } 
        }
    });

    $(document).on("change", "#txtNumeroCuenta", function() {
        if ($(this).val()>0) {
            $.ajax({
               url: urlj + "utm/cuentas/validar_numero_cuenta_bancaria",
                 type: 'POST',
                 data: { numero_cuenta: $(this).val() },
                 dataType: 'json',
                 beforeSend: function () {
                     wait.start('Cargando..');
                },
                 error: function (xhr, status, error){
                  // exportarError(xhr.responseText);
                  wait.close();
                },
                success: function (json) {
                    // console.log(json);
                    wait.close();
                    if(json.cantidad_cub>0) {
                        crear_alerta('error', 'Error Número de Cuenta Bancaria', 'El campo Número de Cuenta debe ser único.');
                        $("#txtNumeroCuenta").val('');
                    }
                }
            });
        }
    });

    $(document).on("change", "#slcChequeDefecto", function() {
        if ($(this).val()<1) {
            $(this).val(1).trigger('change');
            $(this).select2();
        }
    });
    

    $("#cuenta_contable_cnt").select2({
        placeholder: "Buscar Cuenta Contable",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'utm/cuentas/get_cuentas_contables_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (cuenta) {
                return {
                    cuenta: cuenta
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.cuenta,
                        'text': item.cuenta_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        }
    });

    // Ficha de Finanzas
    $('#add_finanza').live('click', function (event) {
        event.preventDefault();

        var cantidad_tr = $("#documento_finanza").find("tr").length;

        var centro_costo_cec = $("#centro_costo_cec").val().trim();
        var centro_costo_cec_select = $("#centro_costo_cec option:selected").text();

        var cuenta_contable_cnt = $("#cuenta_contable_cnt").val().trim();
        var cuenta_contable_cnt_select = $("#cuenta_contable_cnt").next().text().trim();

        var tipo_cuenta_tcn = $("#tipo_cuenta_tcn").val().trim();
        var tipo_cuenta_tcn_select = $("#tipo_cuenta_tcn option:selected").text();

        var repetido = false;
        var tipo_cuenta = false;

        var mensaje = "";
        var type_msg = "";
        
        if (tipo_cuenta_tcn != "" && cuenta_contable_cnt != "" && centro_costo_cec != "" ) {
            type_msg = "error";

            var configuracion = centro_costo_cec+"-"+tipo_cuenta_tcn+"-"+cuenta_contable_cnt;
            
            if ($("#documento_finanza .tr_finanzas").length > 0) {
                $("#documento_finanza .tr_finanzas").each(function () {
                    if ($(this).attr("name") == ("tr_configuracion_" + configuracion)) {
                        repetido = true;
                    }
                    // Verificar si ya existe un tipo de cuenta en especifico
                    tcn_tipo_cuenta = $(this).children('td').eq(1).attr("id").split('tcn');
                    // console.log(tcn_tipo_cuenta);
                    if (tcn_tipo_cuenta[1] == tipo_cuenta_tcn) {
                        tipo_cuenta = true;
                    }
                });
            }

            if (repetido == true) {
                crear_alerta('info', 'Configuración contable', 'Detalle ya fue agregado');
                return false;
            }

            if (tipo_cuenta == true) {
                crear_alerta('info', 'Configuración contable', 'Ya se agregó el tipo de cuenta '+tipo_cuenta_tcn_select);
                return false;
            }
            
            if (cantidad_tr >= 1 && $("#contador_finanza").val() != cantidad_tr) {
                $("#contador_finanza").val((cantidad_tr + 1));
            }
            id_correlativo      = $("#contador_finanza").val(); //crear un id unico para anexos de documentos
            id_centro_costo_cec = '<input type="hidden" id="centro_costo_cec' + centro_costo_cec + cuenta_contable_cnt + tipo_cuenta_tcn + '" name="centro_costo_cec[]" value="' + centro_costo_cec + '" />';
            id_cuenta_contable_cnt = '<input type="hidden" id="cuenta_contable_cnt' + centro_costo_cec + cuenta_contable_cnt + tipo_cuenta_tcn + '" name="cuenta_contable_cnt[]" value="' + cuenta_contable_cnt + '" />';
            id_tipo_cuenta_tcn  = '<input type="hidden" id="tipo_cuenta_tcn' + centro_costo_cec + cuenta_contable_cnt + tipo_cuenta_tcn + '" name="tipo_cuenta_tcn[]" value="' + tipo_cuenta_tcn + '" />';
            
            eliminar = '<a id="del_doc" valor="' + id_correlativo + '" thead="titlefinanza" tbody="documento_finanza" class="btn btn-borrar btn-danger btn-mini minia-icon-trashcan white"> Eliminar</a>';

            var oTable = $('#tblCuentasContables').dataTable();
            //Se destruye el datatable para luego volver a crearla
            oTable.fnDestroy();

            $("#documento_finanza").append(
                    '<tr id="filatitlefinanza' + id_correlativo + '" name="tr_configuracion_'+configuracion+'" class="tr_finanzas">' +
                    '<td id="id_cec'+centro_costo_cec+'">' + id_centro_costo_cec + centro_costo_cec_select + '</td>' +
                    '<td id="id_tcn'+tipo_cuenta_tcn+'">' + id_tipo_cuenta_tcn + tipo_cuenta_tcn_select + '</td>' +
                    '<td id="id_cnt'+cuenta_contable_cnt+'">' + id_cuenta_contable_cnt + cuenta_contable_cnt_select + '</td>' +
                    '<td>' + eliminar + '</td>' +
                    '</tr>');

            aplicarDataTable('#tblCuentasContables');
            $('#tblCuentasContables').css('width', '100%');
            
            var NC = parseInt($("#contador_finanza").val()) + 1;
            $("#contador_finanza").val(NC);

            $("#centro_costo_cec option").removeAttr("selected");
            $("#centro_costo_cec").select2();

            $("#cuenta_contable_cnt").select2('data', null);

            $("#tipo_cuenta_tcn option").removeAttr("selected");
            $("#tipo_cuenta_tcn").select2();

            $("#centro_costo_cec_error").text('');
            $("#cuenta_contable_cnt_error").text('');
            $("#tipo_cuenta_tcn_error").text('');

        } else {
            type_msg = "error";
            mensaje = "Los campos son requeridos";
            if (tipo_cuenta_tcn == "") {
                $("#tipo_cuenta_tcn_error").text('Campo requerido');
                if (cuenta_contable_cnt == "") {
                    $("#cuenta_contable_cnt_error").text('Campo requerido');
                }
                if (centro_costo_cec == "") {
                    $("#centro_costo_cec_error").text('Campo requerido');
                }
            } else if (cuenta_contable_cnt == "") {
                $("#cuenta_contable_cnt_error").text('Campo requerido');
                if (tipo_cuenta_tcn == "") {
                    $("#tipo_cuenta_tcn_error").text('Campo requerido');
                }
                if (centro_costo_cec == "") {
                    $("#centro_costo_cec_error").text('Campo requerido');
                }
            } else if (centro_costo_cec == "") {
                $("#centro_costo_cec_error").text('Campo requerido');
                if (tipo_cuenta_tcn == "") {
                    $("#tipo_cuenta_tcn_error").text('Campo requerido');
                }
                if (cuenta_contable_cnt == "") {
                    $("#cuenta_contable_cnt_error").text('Campo requerido');
                }
            }
        }
        if (mensaje != "") {
            $.pnotify({
                type: type_msg,
                title: 'Informaci&oacute;n',
                text: mensaje,
                icon: 'ui-icon ui-icon-info',
                opacity: 0.95,
                history: false,
                sticker: false
            });
        }
        //}
    });

    $('.btn-borrar').live('click', function (event) {
        event.preventDefault();
        //Eliminar Gasto Indirectos
        var parent = $(this).parent().parent();
        var oTable = $('#tblCuentasContables').dataTable();
        oTable.fnDeleteRow(parent[0]);
    });
});

function aplicarDataTable(idTabla) {
    $(idTabla).dataTable({
        "bPaginate": false,
        "bInfo": false,
        "bSort": false,
        "bFilter": false,
    });
}