$(document).ready(function () {
    $('select').select2({placeholder: "Seleccione"});
    //$('#slcProveedor,#slcChequera,#slcBanco,#slcRetenciones').select2();
    $(".fecha").datepicker({dateFormat: 'dd-mm-yy', changeMonth: true, changeYear: true});
    $("#txtMonto").numeric();

    var factura = "";
    var j = 1;

    var ediciones_pendientes = 0;

    $("#chkAplicarTrans").iButton({
        'labelOn': 'Si',
        'labelOff': 'No',
        'resizeHandle': false,
        'resizeContainer': false,
        change: function (element) {
            if (element.is(':checked')) {
                $("#hdnAplicarTrans").val(1);
            } else {
                $("#hdnAplicarTrans").val(0);
            }
        }
    });

    $("#chkCajaChica").iButton({
        'labelOn': 'Si',
        'labelOff': 'No',
        'resizeHandle': false,
        'resizeContainer': false,
        change: function (element) {
            if (element.is(':checked')) {
                $("#hdnCajaChica").val(1);
                $("#slcFactura").select2("val", "");
                $("#caja_chica").show();
            } else {
                $("#hdnCajaChica").val(0);
                $("#slcCajaChica").select2("val", "");
                $("#caja_chica").hide();
            }
        }
    });

    $("#cuenta_cont").select2({
        placeholder: "Buscar Cuenta Contable",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'utm/cuentas/get_cuentas_contables_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (cuenta) {
                return {
                    cuenta: cuenta
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.cuenta,
                        'text': item.cuenta_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });

    $("#cuenta_cont").select2({
        placeholder: "Buscar Cuenta Contable",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'utm/cuentas/get_cuentas_contables_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (cuenta) {
                return {
                    cuenta: cuenta
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.cuenta,
                        'text': item.cuenta_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });

    $(".slcCuentaContable").select2('disable');


    $("#frmAgregarCheque").validate({
        ignore: "",
        rules: {
            txtOrden: {required: true},
            txtFecha: {required: true},
            slcBanco: {required: true},
            slcChequera: {required: true},
            txtNumero: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html('Campo requerido');
        },

        submitHandler: function (form) {
            error = "";

            if ($("#tlbCheque .tr_cheque").length == 0) {
                crear_alerta('error', 'Cheques', 'Debe agregar al menos un registro');
                return false;
            }

            if (ediciones_pendientes != 0) {
                crear_alerta('error', 'Cheques', 'Posee documentos sin guardar');
                return false;
            }

            wait.start();
            var tiene_partida = $('#contenedor_detalle tr').length;
            var proveedor = $("#slcProveedor").val();
            if (tiene_partida == 0) {
                if (proveedor > 0) {
                    form.submit();
                } else {
                    if ($("#ha_confirmado").val() > 0) {
                        form.submit();
                    } else {
                        wait.close();
                        alerta_confirm_ajax(enviar_sin_ptda, 1, 'No ha creado una partida personalizada.', '¿Está seguro que desea realizar esta transacción sin una partida personalizada?');
                    }
                }
            }else{
                //  var debe     = (!isNaN(parseFloat($('#total_debe').val())))?parseFloat($('#total_debe').val()):0;
                //  var haber    = (!isNaN(parseFloat($('#total_haber').val())))?parseFloat($('#total_haber').val()):0;
                //  var cheque   = (!isNaN(parseFloat($('#txt_valor_monto').val())))?parseFloat($('#txt_valor_monto').val()):0;
                // if (((debe + haber)/2) == cheque) {
                    form.submit();
                // }else{
                //     crear_alerta('error','Error al procesar','Monto cheque no es igual al monto de la partida contable');
                //     wait.close();
                // }
            }            
        }
    });

    function enviar_sin_ptda() {
        $("#ha_confirmado").val(1);
        $("#frmAgregarCheque").submit();
    }



    $(".btn-success").click(function () {
        event.preventDefault();
        $("#valor").val($(this).val());
        if ($("#txtNumero").val() != "") {
            consultar_numero();
        } else {
            $("#frmAgregarCheque").submit();
        }
    });

    $("#btnAgregarCheque").live("click", function (event) {
        event.preventDefault();
        i = $("#slcFactura").val();
        var tipo = $("#txtTipo").val();
        var serie = $("#txtSerie").val();
        var factura = "";
        var txt_factura = "";
        var descripcion = $("#txtDescripcion").val();
        var monto = ($("#txtMonto").val() != '') ? parseFloat($("#txtMonto").val()) : null;
        var monto_sujeto = 0.00;
        var retencion = 0.00;
        var total = monto;
        var repetido = false;
        var proveedor = "";
        var monto_pendiente = $("#txtTmpMontoPendiente").val();
        var cuenta      = $("#cuenta_cont").val();
        var proyecto    = $("#slc_proyecto option:selected").text();
        var proyecto_id = $("#slc_proyecto").val();
        var presupuesto                 = $("#slc_presupuesto").val();
        var actividad_general           = $("#slc_actividad_general").val();
        var actividad_especifica        = $("#slc_actividad_espeficifica").val();
        var txt_actividad_espeficifica  = $("#slc_actividad_espeficifica option:selected").data("nombre");
        var numero_documento            = ($("#slcFactura").val() > 0) ? $("#slcFactura option:selected").data("documento") : 0;
        var banco = $("#slcBanco").val();
        var cuenta = $("#slcCuentaBancaria").val();
        var sobregira = $('#slcCuentaBancaria option:selected').data("sobregiro");
        var monto_sobregiro = $('#slcCuentaBancaria option:selected').data("monto_sg");
        var disponible = $('#lblSaldo').text();
        var aplica_cch = $('#hdnCajaChica').val();
        var caja_chica = $('#slcCajaChica').val();
        var nombre_cch = $('#slcCajaChica option:selected').text();
        var txtCuenta = (cuenta > 0) ? $('#cuenta_cont').next().text() : '';

        if ( proyecto_id != ""){
            descripcion = descripcion + " (" + proyecto + ")";
        }
        if ($("#slcProveedor").val() != "") {
            if (!($("#slcFactura").val() != "")) {
                if ($.trim(monto) == "" || monto <= 0) {
                    crear_alerta('error', 'Atención', 'Favor especificar el monto o el Documento del proveedor.');
                    return false;
                }
            }
        }
        if (monto <= 0 || monto == "") {
            crear_alerta('error', 'Cheques', 'Favor especificar el monto');
            $('#txtMonto').focus();
            return false;
        }
        if (i != '') {
            if (parseFloat(monto) > parseFloat(monto_pendiente)) {
                crear_alerta('error', 'Cheques', 'El monto no puede ser mayor a la deuda de la factura (' + monto_pendiente + ')');
                $('#txtMonto').focus();
                return false;
            }
        }
        if (aplica_cch > 0) {
            if (caja_chica != "") {
                descripcion += ' ' + nombre_cch;
            } else {
                crear_alerta('error', 'Caja Chica', 'Debe Seleccionar una Caja Chica.');
                return false;
            }
        }
        if (banco != '' && cuenta != '' && disponible != '') {
            var disponible_total = parseFloat(disponible);
            disponible_total += (parseFloat(sobregira) > 0) ? parseFloat(monto_sobregiro) : 0;
            if (monto > disponible_total) {
                crear_alerta('error', 'Cheques', 'El monto ingresado es mayor que el saldo disponible.');
                return false;
            }
        } else {
            crear_alerta('warning','','Debe especificar Banco y Cuenta');
            return false;
        }
        if (i == "") {
            i = j + "null";
            j++;
        } else {
            //verificar repetido
            if ($("#tbContenedorCheques .tr_cheque").length > 0) {
                $("#tbContenedorCheques .tr_cheque").each(function () {
                    if ($(this).attr("name") == ("tr_cheque" + i)) {
                        repetido = true;
                    }
                });
            }
            txt_factura = $("#slcFactura").next('div').text();
            factura = $("#slcFactura").val();
        }
        if (repetido == true) {
            crear_alerta('error', 'Cheques', 'Factura ya fue agregada');
            $("#txtTipo").val('');
            $("#txtSerie").val('');
            return false;
        }
        if (factura != "") {
            proveedor = $('#slcProveedor').val();
        }
        var html = '<tr id="tr_cheque' + i + '" name="tr_cheque' + i + '" class="tr_cheque">';
        html += '<td>';
        html += '<input type="text" id="txtTablaTipo' + i + '" name="txtTablaTipo[]" class="text tables-input" readonly="readonly" value="' + tipo + '" />';
        html += '<input type="hidden" id="txt_presupuesto' + i + '" name="txt_presupuesto[]" class="text tables-input" readonly="readonly" value="' + presupuesto + '" />';
        html += '<input type="hidden" id="txt_actividad_general' + i + '" name="txt_actividad_general[]" class="text tables-input" readonly="readonly" value="' + actividad_general + '" />';
        html += '<input type="hidden" id="txt_actividad_especifica' + i + '" name="txt_actividad_especifica[]" class="text tables-input" readonly="readonly" value="' + actividad_especifica + '" />';
        html += '<input type="hidden" id="txt_actividad_espeficifica_text' + i + '" name="txt_actividad_espeficifica_text[]" class="text tables-input" readonly="readonly" value="' + txt_actividad_espeficifica + '" />';
        html += '<input type="hidden" id="txt_numero_documento' + i + '" name="txt_numero_documento[]" class="text tables-input" readonly="readonly" value="' + numero_documento + '" />';
        html += '</td>';

        html += '<td>';
        html += '<input id="txtTablaSerie' + i + '" name="txtTablaSerie[]" type="text" class="text tables-input" readonly="readonly" value="' + serie + '" />';
        html += '</td>';

        html += '<td>';
        html += '<input id="txtTablaTextoFactura' + i + '" type="text" class="text tables-input" readonly="readonly" value="' + txt_factura.trim() + '" />';
        html += '<input id="txtTablaProveedor' + i + '" name="txtTablaProveedor[]" type="hidden" class="text tables-input" readonly="readonly" value="' + proveedor + '" />';
        html += '<input id="txtTablaFactura' + i + '"  data-id="' + i + '" name="txtTablaFactura[]" type="hidden" class="text tables-input factura_tabla" readonly="readonly" value="' + factura + '" />';
        html += '</td>';

        html += '<td>';
        html += '<input id="txtTablaDescripcion' + i + '" name="txtTablaDescripcion[]" type="text" class="text tables-input-show tables-input descripcion_tabla" readonly="readonly" value="' + descripcion + '"  maxlength="300" style="display: none;"/>';
        html += '<input id="txt_tabla_proyecto' + i + '" name="txt_tabla_proyecto[]" type="hidden" class="text " value="' + proyecto_id + '" style="display: none;"/>';
        html += '<label id="txtTablaDescripcion' + i + '_lbl" class="descripcion_tabla_lbl" style="display: block;">'+descripcion.trim()+'</label>';
        html += '</td>';
        
        // Se deshabilito la cuenta contable
        // html += '<td style="width:auto;">';
        // html += '<input id="txtTablaCuenta' + i + '" name="txtTablaCuenta[]" type="hidden" class="text tables-input tables-input" readonly="readonly" value="' + cuenta + '"  maxlength="10"/>';
        // html += '<textarea id="TablaCuenta' + i + '" style="width:auto !important;resize: none;" type="text" class="text tables-input tables-input" readonly="readonly" >' + txtCuenta + '</textarea>';
        // html += '</td>';

        html += '<td>';
        html += '<input id="txtTablaMonto' + i + '" name="txtTablaMonto[]" type="text" class="text tables-input-show tables-input soloNumeros  monto numeric numero" extras="." readonly="readonly" value="' + monto.toFixed(2) + '"  maxlength="19"/>';
        html += '</td>';

        html += '<td>';
        html += '<input id="txtTablaMontoSujeto' + i + '" name="txtTablaMontoSujeto[]" type="text" class="text tables-input monto_sujeto" readonly="readonly" value="' + monto_sujeto.toFixed(2) + '" maxlength="19" />';
        html += '<input id="txtTablaMontoPendiente' + i + '" name="txtTablaMontoPendiente[]" type="hidden" readonly="readonly" value="' + monto_pendiente + '" maxlength="19" />';
        html += '</td>';

        html += '<td>';
        html += '<input id="txtTablaRetenciones_id' + i + '" name="txtTablaRetenciones_id[]" type="hidden" class="text tables-input" readonly="readonly" value="" />';
        html += '<input id="txtTablaRetenciones_procentaje' + i + '" name="txtTablaRetenciones_procentaje[]" type="hidden" class="text tables-input" readonly="readonly" value=""  maxlength="19"/>';
        html += '<input id="txtTablaRetencion' + i + '" name="txtTablaRetencion[]" type="text" class="text tables-input" readonly="readonly" value="' + retencion.toFixed(2) + '"  maxlength="19" />';
        html += '</td>';

        html += '<td>';
        html += '<input id="txtTablaTotal' + i + '" name="txtTablaTotal[]" type="text" class="text tables-input subtotal" readonly="readonly" value="' + total.toFixed(2) + '"  maxlength="19"/>';
        html += '</td>';

        html += '<td>';
        html += '<button type="button" id="btnTablaGuardar' + i + '" class="btn btn-primary btn-mini btnGuardarChe" style="margin-right: 5px;float: left; height: 30px; width: 50px;display: none;" value="' + i + '">Guardar</button>';
        html += '<button type="button" id="btnTablaEditar' + i + '" class="btn btn-primary btn-mini btnEditChe" style="margin-right: 5px;float: left; height: 30px; width: 50px; display: block;" value="' + i + '">Editar</button>';
        html += '<button type="button" class="btn btn-danger btn-mini btnDelChe" style="float:left; /*margin-left:5%;*/ height:30px;width:50px;">Eliminar</button>';
        html += '<a href="#myModal" style="margin-left: 10px;" class="myModal icon-table btnRetChe" id="' + i + '"><span class="icon16 icomoon-icon-list-view-2" value="' + i + '"></span></a>';
        html += '</td>';

        html += '</tr>';

        var oTable = $('#tlbCheque').dataTable();

        content += html;
        //Se destruye el datatable para luego volver a crearla
        oTable.fnDestroy();

        $("#tbContenedorCheques").append(html);
        aplidarDataTable('tlbCheque');

        $("#slcFactura option:selected").removeAttr('selected');
        $("#slc_proyecto option:selected").removeAttr('selected');

        $("#slc_presupuesto").val('');
        $("#slc_actividad_general").val('');
        $("#slc_actividad_espeficifica").val('');

        $("#txtDescripcion").val('');
        $("#txtMonto").val('');

        $("#txtTipo").val('');
        $("#txtSerie").val('');
        $("#txtTmpMontoPendiente").val('0');

        $("#slcFactura").select2('data', null);
        $("#slc_proyecto").select2('data', null);
        $("#slc_presupuesto").select2('data', null);
        $("#slc_actividad_general").select2('data', null);
        $("#slc_actividad_espeficifica").select2('data', null);
        // Monto total de renta
        total_monto();
        // Monto sujeto a retencion
        total_monto_sujeto();
        sumatoria_monto();
        if(proveedor = ''){
            $("#cuenta_cont").select2('data', null);
        }
        $("#slcProveedor").select2('disable');
    });

    //Guardar cheque
    $(".btnGuardarChe").live('click', function () {
        event.preventDefault();

        var parent = $(this).parent().parent();

        var tr_id = $(this).val();

        if ($('#txtTablaMonto' + tr_id).val() == "" || $('txtTablaMonto' + tr_id).val() <= 0) {
            $('#txtTablaMonto' + tr_id).focus();
            crear_alerta('error', 'Cheques', 'EL monto debe ser mayor a 0');
            return false;
        }

        if (parseFloat($('#txtTablaMonto' + tr_id).val()) < parseFloat($('#txtTablaMontoSujeto' + tr_id).val())) {
            crear_alerta('error', 'Cheques', 'Monto no puede ser menor al monto sujeto');
            $('#txtTablaMonto' + tr_id).focus();
            return false;
        }

        if ($("#txtTablaFactura" + tr_id).val() != '') {
            if (parseFloat($('#txtTablaMonto' + tr_id).val()) > parseFloat($('#txtTablaMontoPendiente' + tr_id).val())) {
                crear_alerta('error', 'Cheques', 'El monto no puede ser mayor a la deuda de la factura (' + $('#txtTablaMontoPendiente' + tr_id).val() + ')');
                $('#txtTablaMonto' + tr_id).focus();
                return false;
            }
        }
        var monto = parseFloat($('#txtTablaMonto' + tr_id).val());
        $('#txtTablaMonto' + tr_id).val(monto.toFixed(2));
        //txtTablaMonto[]

        var total = parseFloat($('#txtTablaMonto' + tr_id).val() - $('#txtTablaRetencion' + tr_id).val());
        $('#txtTablaTotal' + tr_id).val(total.toFixed(2));

        $("#" + parent[0].id + " .tables-input-show").addClass('tables-input');
        $("#" + parent[0].id + " .tables-input-show").attr('readonly', 'readonly');

        
        $("#" + parent[0].id + " .descripcion_tabla").css('display','none');
        $("#" + parent[0].id + " .descripcion_tabla_lbl").css('display','block');

        $(this).hide();
        $("#" + parent[0].id + " .btnEditChe").show();
        total_monto();
        total_monto_sujeto();
        sumatoria_monto();
        ediciones_pendientes = ediciones_pendientes - 1;

        var newID = $(this).val();
        $("#" + newID).show();
    });

    //Editar cheque
    $(".btnEditChe").live('click', function () {
        ediciones_pendientes++;
        var parent = $(this).parent().parent();

        $("#" + parent[0].id + " .tables-input-show").removeClass('tables-input');
        $("#" + parent[0].id + " .tables-input-show").removeAttr('readonly');
        
        $("#" + parent[0].id + " .descripcion_tabla").css('display','block');
        $("#" + parent[0].id + " .descripcion_tabla_lbl").css('display','none');
        
        $(this).hide();
        $("#" + parent[0].id + " .btnGuardarChe").show();

        var newID = $(this).val();
        $("#" + newID).hide();
    });

    //Retencion de cheque
    $(".btnRetChe").live('click', function () {
        event.preventDefault();

        var id = $(this).attr('id');        
        $("#btnTablaDet" + id).show();

        var cheque_pendiente = $("#hdnChequePendiente").val();

        $('#sujeto').val('');
        $("#slcRetenciones").select2('data', null);
        $('#slcRetenciones').select2();

        var seleccionados = $('#txtTablaRetenciones_id' + id).val();
        var seleccionados_array = seleccionados.split(',');

        $('#sujeto').val($('#txtTablaMontoSujeto' + id).val());

        if (seleccionados != "") {
            $("#slcRetenciones option").each(function () {
                if (jQuery.inArray($(this).val(), seleccionados_array) != -1) {
                    $(this).attr("selected", "selected");
                }
            });
            $("#slcRetenciones").select2();
        }
        $('#txtTmpRetencion').val(id);

        if (cheque_pendiente > 0) {
            // $('#sujeto').attr('readonly', 'readonly');
            // $("#slcRetenciones").select2('disable');
            // $("#guardar_modal").hide();
        }
    });

    //eliminar
    $('#tlbCheque tbody').on('click', '.btnDelChe', function () {
        var table = $('#tlbCheque').DataTable();
        var parent = $(this).parent().parent();
        var nRow = $(parent).attr("id");
        table.fnDeleteRow(parent[0], null, true);
        total_monto();
        contar_filas();
        total_monto_sujeto();
        sumatoria_monto();
    });

    function aplidarDataTable(idTabla) {
        $('#' + idTabla).dataTable({
            "bPaginate": false,
            "bInfo": false,
            "bSort": false,
            "bFilter": false,
        });
    }

    $("#slcBanco").change(function () {
        ban_id = $(this).val();
        if ($(this).val()>0) {
            $.ajax({
                url: urlj + "utm/cuentas/obtener_cuenta",
                type: 'POST',
                dataType: 'json',
                data: {ban_id: ban_id},
                success: function (json) {
                    // DATOS para chequeras
                    // $('#slcChequera').html(json.datos);
                    // $('#slcChequera option[value=""]').text('');
                    // $('#slcChequera').select2({placeholder: "Seleccione una opción"});
                    // DATOS para Cuentas
                    $('#slcCuentaBancaria').html(json.cuentas);
                    $('#slcCuentaBancaria option[value=""]').text('');
                    $('#slcCuentaBancaria').select2({placeholder: "Seleccione una opción"});
                    $('#txtNumero').val("");
                    $('#slcChequera').html(json.new_chq_html);
                    $('#slcChequera option[value=""]').text('');
                    $('#slcChequera').select2({placeholder: "Seleccione una opción"});
                    if (json.saldo_new != null) {
                        $("#lblSaldo").text('$'+json.saldo_new);
                        $("#mostrar_saldo").show('slow');
                    }else{
                        $("#lblSaldo").text('');
                        $("#mostrar_saldo").hide('slow');
                    }
                    if (json.numeros != null) {
                        var cant = json.numeros;
                        var num = cant.split("#");
                        var n = num[0];
                        var dis = num[1];
                        var saldo = num[2];
                        var n_cu = num[3];
                        var sal_min = num[4];
                        $("#cuenta_chequera").val(n_cu);
                        if (dis <= 0) {
                            crear_alerta('error', 'Cheques', 'No hay cheques disponibles');
                            $("#txtNumero").val("");
                        } else {
                            $("#txtNumero").val(n.trim());
                        }
                    }
                }
            });
        }else{
            $('#slcChequera').html('<option value=""></option>');
            $('#slcChequera').select2({placeholder: "Seleccione una opción"});
            $('#slcCuentaBancaria').html('<option value=""></option>');
            $('#slcCuentaBancaria').select2({placeholder: "Seleccione una opción"});
            $("#mostrar_saldo").hide('none');
            $("#txtNumero").val("");
        }
    });

    $("#slcChequera").change(function () {
        chq_id = $(this).val();
        $("#cuenta_chequera").val(chq_id);
        if ($(this).val()>0) {
            $.ajax({
                url: urlj + "utm/cuentas/obtener_numero",
                type: 'POST',
                data: {chq_id: chq_id},
                success: function (data) {
                    var cant = data;
                    var num = cant.split("#");
                    var n = num[0];
                    var dis = num[1];
                    var saldo = num[2];
                    var n_cu = num[3];
                    var sal_min = num[4];
                    $("#cuenta_chequera").val(n_cu);
                    if (dis <= 0) {
                        crear_alerta('error', 'Cheques', 'No hay cheques disponibles');
                        $("#txtNumero").val("");
                    } else {
                        $("#txtNumero").val(n.trim());
                    }
                    // $("#saldo").val(saldo);  
                    // $("#saldo_min").val(sal_min);
                }
            });
        }else{
            $("#txtNumero").val("");
        }
    });

    $("#slcProveedor").change(function () {
        $("#slcFactura").select2('data', null);
        if ($("#slcProveedor").val() == "") {
            $("#slcFactura").select2('disable');
            //get_cuentas_cuenta_proveedor
            $("#cuenta_cont").select2('data', null);
            $("#cuenta_cont").select2('enable');
        } else {
            var proveedor = $("#slcProveedor").val();
            $.ajax({
                url: urlj + "utm/cuentas/get_factura_x_proveedor",
                type: 'POST',
                dataType: 'json',
                data: {proveedor: proveedor},
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    wait.close();
                    $("#slcFactura").html(data);
                }
            });
            $("#slcFactura").select2('enable');
            /* **************************************************************************** */
            /* Se deshabilito, ya que no se mostrara cuenta contable */
            // $.ajax({
            //     url: urlj + "utm/cuentas/get_cuentas_cuenta_proveedor",
            //     type: 'POST',
            //     dataType: 'json',
            //     data: {proveedor: proveedor, tipo: 'GASTO'},
            //     beforeSend: function () {
            //         wait.start();
            //     },
            //     success: function (data) {
            //         wait.close();
            //         $("#cuenta_cont").select2('data', {id: data.cuenta, text: data.cuenta_nombre});
            //         $("#cuenta_cont").select2('disable');
            //     }
            // });
            /* **************************************************************************** */
        }
    });

    $("#slcFactura").on("change", function() {
        if ($(this).val() > 0) {
        get_datos_factura();
    } else {
        $("#txtMonto").removeAttr('readonly');
        $("#txtMonto").val('');

        $("#slc_proyecto option").removeAttr('selected');
        $("#slc_presupuesto").html('<option value=""></option>');
        $("#slc_actividad_general").html('<option value=""></option>');
        $("#slc_actividad_espeficifica").html('<option value=""></option>');

        $("#slc_proyecto").select2({placeholder: 'Seleccione una opción'});
        $("#slc_presupuesto").select2({placeholder: 'Seleccione una opción'});
        $("#slc_actividad_general").select2({placeholder: 'Seleccione una opción'});
        $("#slc_actividad_espeficifica").select2({placeholder: 'Seleccione una opción'});
    }
    });

    function get_datos_factura() {
        var result = null;
        if ($('#slcFactura').val() != "") {
            var id_factura = $('#slcFactura').val();
            $.ajax({
                url: urlj + "utm/cuentas/get_datos_factura",
                type: 'POST',
                dataType: 'json',
                data: {id_factura: id_factura},
                success: function (data) {
                    $("#txtTipo").val(data[0].tif_abreviacion);
                    $("#txtSerie").val(data[0].dpv_serie_documento);
                   
                    var pendiente = 0;
                    if (data[0].pendiente != '' && data[0].pendiente > 0) {
                        pendiente = parseFloat(data[0].pendiente).toFixed(2);
                    } else {
                        pendiente = parseFloat(data[0].dpv_monto_pendiente).toFixed(2);
                    }
                   
                    if (pendiente > 0) {
                        $("#txtTmpMontoPendiente").val(pendiente);
                        $("#txtMonto").val(pendiente);
                        //$("#txtMonto").attr('readonly','readonly');
                    }

                    if ( data[0].dpv_id_pcl != null){
                        $("#slc_proyecto option").each(function(){
                            if ( data[0].dpv_id_pcl == $(this).attr('value')){
                                $('#slc_proyecto').val( $(this).attr('value') ).trigger('change.select2');
                                $('#slc_proyecto').select2();
                                $('#slc_proyecto').select2('disable');
                            }
                         });
                    }

                }
            });
            //buscar proyecto            
            wait.start();
            $.ajax({
                url: urlj+'modulo_compras/procesos/get_datos_proyectos',
                type: 'POST',
                data: {
                    tipo: 2,
                    codigo: id_factura
                },
                success:function(data) {                                     
                    var obj = jQuery.parseJSON(data);
                    if (obj.info == true) {
                        $("#slc_presupuesto").html("");
                        $("#slc_presupuesto").html(obj.presupuesto);
                        $("#slc_presupuesto").select2({placeholder: 'Seleccione una opción'});
                        if (obj.presupuesto != '<option value=""></option>') { $('#slc_presupuesto').select2('disable'); }
    
                        $("#slc_actividad_general").html("");
                        $("#slc_actividad_general").html(obj.general);                        
                        $("#slc_actividad_general").select2({placeholder: 'Seleccione una opción'});
                        if (obj.general != '<option value=""></option>') { $('#slc_actividad_general').select2('disable'); }
    
                        $("#slc_actividad_espeficifica").html("");
                        $("#slc_actividad_espeficifica").html(obj.especifica);
                        $("#slc_actividad_espeficifica").select2({placeholder: 'Seleccione una opción'});
                        if (obj.especifica != '<option value=""></option>') { $('#slc_actividad_espeficifica').select2('disable'); }

                    }           
                    wait.close();
                }
            });
        }
    }

    /* ***************************************************************************** */
    /* Se dehabilito para mostrar en el select las cuentas por proveedor precargadas */
    // $("#slcFactura").select2({
    //     placeholder: 'Buscar factura',
    //     minimumInputLength: 3,
    //     ajax: {

    //         url: urlj + 'utm/cuentas/get_factura_like',
    //         dataType: 'json',
    //         type: 'POST',
    //         delay: 250,
    //         data: function (factura) {
    //             return {
    //                 factura: factura,
    //                 proveedor: $("#slcProveedor").val()
    //             };
    //         },
    //         results: function (data) {
    //             var myResults = [];
    //             $.each(data, function (index, item) {
    //                 myResults.push({
    //                     'id': item.dpv_id,
    //                     'text': item.dpv_numero_documento,
    //                     'data-tipo': item.dpv_concepto
    //                 });
    //             });
    //             return {
    //                 results: myResults
    //             };
    //         }
    //     }
    // });
    /* ***************************************************************************** */

    $("#guardar_modal").live("click", function () {
        event.preventDefault();

        var id = $('#txtTmpRetencion').val();
        var error = false;
        var porcentaje = 0;
        var retenciones = "";
        var porcentaje_tabla = "";
        var cantidad_seleccionados = 0;

        if ($('#sujeto').val() == "") {
            crear_alerta('error', 'Cheques', 'Ingrese el valor sujeto a retención');
            $('#sujeto').focus();
            error = true;
            return false;
        }

        if ($('#slcRetenciones').val() == "") {
            crear_alerta('error', 'Retención', 'Seleccione un tipo de retención');
            $('#sujeto').focus();
            error = true;
            return false;
        }

        if (parseFloat($('#sujeto').val()) > parseFloat($('#txtTablaMonto' + id).val())) {
            crear_alerta('error', 'Retención', 'Valor sujeto a retención es mayor que el monto, ($' + $('#txtTablaMonto' + id).val() + ')');
            $('#sujeto').focus();
            error = true;
            return false;
        }

        $('#slcRetenciones :selected').each(function (i, selected) {
            retenciones = retenciones + $(selected).val() + ",";
            porcentaje = porcentaje + $(selected).data("valor");
            porcentaje_tabla = porcentaje_tabla + $(selected).data("valor") + ",";
            cantidad_seleccionados++;
        });

        /*if ($('#sujeto').val() <= 0) {
         crear_alerta('error', 'Retención', 'Valor sujeto debe ser mayor a 0');
         $('#sujeto').focus();
         error = true;
         return false;
         }*/

        if (cantidad_seleccionados <= 0 && $('#sujeto').val() > 0) {
            crear_alerta('error', 'Retención', 'Debe seleccionar una retención');
            error = true;
            return false;
        }

        if (cantidad_seleccionados > 0 && $('#sujeto').val() <= 0) {
            crear_alerta('error', 'Retención', 'Valor sujeto debe ser mayor a 0');
            error = true;
            return false;
        }

        retenciones = retenciones.substring(0, retenciones.length - 1);
        porcentaje_tabla = porcentaje_tabla.substring(0, porcentaje_tabla.length - 1);

        $('#txtTablaRetenciones_id' + id).val(retenciones);
        $('#txtTablaRetenciones_procentaje' + id).val(porcentaje_tabla);

        var sujeto = parseFloat($('#sujeto').val());

        calculo_retencion(porcentaje, sujeto.toFixed(2), id);

        if (error == false) {
            $.fancybox.close();
        }
    });

    function consultar_numero() {
        numero = $("#txtNumero").val();
        id_chequera = $("#slcChequera").val();
        $.ajax({
            url: urlj + "utm/cuentas/validar_num_cheque",
            type: 'POST',
            dataType: 'json',
            data: {id_chequera: id_chequera, numero: numero},
            success: function (data) {
                if (data.resp == 1) {
                    crear_alerta('error', 'Informaci&oacute;n', 'El número de cheque fuera del rango');
                    $("#txtNumero").val('');

                }
                if (data.resp == 2) {
                    crear_alerta('error', 'Informaci&oacute;n', 'El número de cheque ya fue usado');
                    $("#txtNumero").val('');
                }
                $("#frmAgregarCheque").submit();
            }
        });
    }


    function calculo_retencion(porcentaje, valor_sujeto, id) {
        var retencion = 0;
        var sub_total = 0;

        retencion = (valor_sujeto * porcentaje) / 100;
        sub_total = $('#txtTablaMonto' + id).val() - retencion;
        $('#txtTablaMontoSujeto' + id).val(valor_sujeto);
        $('#txtTablaRetencion' + id).val(retencion);
        $('#txtTablaTotal' + id).val(sub_total);

        $('#sujeto').val('');
        $("#slcRetenciones").select2('data', null);
        total_monto();
        total_monto_sujeto();
        sumatoria_monto();
        $.fancybox.close();
    }

    //subtotal
    function total_monto() {
        suma = 0;
        celda = "";
        $('.subtotal').each(function () {
            celda = $(this).val();
            suma += parseFloat(celda || 0, 10);
        });
        suma = suma.toFixed(2);
        $('#txt_valor_monto').val(suma);
    }

    function total_monto_sujeto() {
        suma = 0;
        celda = "";
        $('.monto_sujeto').each(function () {
            celda = $(this).val();
            suma += parseFloat(celda || 0, 10);
        });
        suma = suma.toFixed(2);
        $('#txt_total_monto_sujeto').val(suma);
    }

    function contar_filas() {
        var suma = 0;
        $(".tr_cheque").each(function () {
            suma++;
        });

        if (suma == 0) {
            $("#slcProveedor").select2('enable');
        }
    }

    //sumataria de monto
    function sumatoria_monto() {
        suma = 0;
        celda = "";
        $('.monto').each(function () {
            celda = $(this).val();
            suma += parseFloat(celda || 0, 10);
        });
        suma = suma.toFixed(2);
        $('#txt_total_monto').val(suma);
    }

    $(".myModal").fancybox({
        width: '40%',
        height: 'auto',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        beforeLoad: function () {

        },
        beforeClose: function () {

        }
    });

    //si colocas .51 que devuelva 0.51
    $("body").on('keypress', '.numero', function (event) {
        $(this).numeric();
        var text = $(this).val();
        if ((text.indexOf('.') != -1) && (text.substring(text.indexOf('.')).length > 2) && (event.which != 0 && event.which != 8) && ($(this)[0].selectionStart >= text.length - 2)) {
            event.preventDefault();
        }
    });


    $("#slcFactura").select2('disable');

    //Sugerir proveedor en 'a la orden de:'
    $("#slcProveedor").change(function () {
        var idprv =$(this).val();
        var prv_text = $("#slcProveedor option:selected").data('nombre');
        if(idprv == ''){
            $('#txtOrden').val('');
        }else{
            $('#txtOrden').val(prv_text);
        }
    });

    $(document).on('change', '#slcCuentaBancaria', function() {
        if ($(this).val()>0) {
            $.ajax({
               url: urlj + "utm/cuentas/obtener_cuenta",
                 type: 'POST',
                 data: { cuenta: $(this).val() },
                 dataType: 'json',
                 beforeSend: function () {
                     wait.start('Cargando..');
                },
                 error: function (xhr, status, error){
                  // exportarError(xhr.responseText);
                  wait.close();
                },
                success: function (json) {
                    //console.log(json);
                    //console.log(json.saldo);
                    wait.close();
                    // DATOS para chequeras
                    $('#slcChequera').html(json.chequeras);
                    $('#slcChequera option[value=""]').text('');
                    $('#slcChequera').select2({placeholder: "Seleccione una opción"});
                    $("#lblSaldo").text(json.saldo);
                    $("#mostrar_saldo").show('slow');
                    if (json.numeros != null) {
                        var cant = json.numeros;
                        var num = cant.split("#");
                        var n = num[0];
                        var dis = num[1];
                        var saldo = num[2];
                        var n_cu = num[3];
                        var sal_min = num[4];
                        $("#cuenta_chequera").val(n_cu);
                        if (dis <= 0) {
                            crear_alerta('error', 'Cheques', 'No hay cheques disponibles');
                            $("#txtNumero").val("");
                        } else {
                            $("#txtNumero").val(n.trim());
                        }
                    }
                }
            });
        } else {
            $('#slcChequera').html('<option value=""></option>');
            $('#slcChequera').select2({placeholder: "Seleccione una opción"});
            $("#mostrar_saldo").hide('slow');
            $("#txtNumero").val("");
        }
    });

    $(document).on('click', '.fancy_detalle_partida', function(event) {                
        $.fancybox({
            modal: false,
            closeClick: false,
            width: '100%',
            height: '100%',            
            autoSize: false,  
            closeBtn: false,
            helpers:{
                overlay:{closeClick:false}
            },                        
            type: 'inline',                        
            href: $(this).attr('href'),         
            afterLoad: function () {                
                //var id = $(this).attr('href');
                //Cargar valores sugeridos para concepto y fecha de la partida
                switch($(location).attr("href").split('/').pop()) {
                    case 'tra_transferencia':
                        //$('#concepto_gral').val('Concepto no definido');
                        break;                    
                    default:
                        $('#concepto_gral').val('Cheque #' + $('#txtNumero').val());
                }
                
                if($('#fecha').val()==''){                    
                    $('#fecha').val($('#txtFecha').val());    
                }
                
                setTimeout(function() {
                    $('.fancybox-outer .fancy_detalle_partida').select2();    
                }, 500);
                wait.close();
            },
            beforeClose: function () {
                var rowCount = $('#contenedor_detalle tr').length;
                var fe = $('#fecha').val();
                var co = $('#concepto_gral').val();
                var ti = $('#tipo').val();
                if(rowCount > 0){
                    if(fe && co && ti){//Tiene Fecha
                        return true;
                    }else{//No tiene Fecha
                        crear_alerta('error', 'Cheques', 'Debe agregar concepto, tipo, fecha');
                        return false;
                    }  
                }
                $('.fancybox-outer .fancy_detalle_partida').select2('destroy');
            }        
        });        
    });

    $(document).on('change', '#slcProveedor', function() {
        val = $(this).val();        
        if(val.length > 0){
            $('#link_modal').css('display', 'none');
            $('#contenedor_detalle').html('');
        }else{
            $('#link_modal').css('display', '');
        }
    });

    $(document).on('change', '.descripcion_tabla', function() {
        input = $(this).attr('id');
        $("#"+input+"_lbl").text(  $("#"+input).val() );
    });

    $("#slc_proyecto").change(function (){
        var proyecto = $(this).val();
        if ( proyecto != "" ) {
            $.ajax({
                dataType: 'text',
                type: 'post',
                data: {proyecto: proyecto},
                url: urlj + 'utm/cuentas/get_presupuestoxproyecto',
                success: function (data) {
                    $("#slc_presupuesto").html("");
                    $("#slc_presupuesto").html(data);
                    $("#slc_presupuesto").select2({placeholder: 'Seleccione una opción'});
                }
            });
        } else {
            $("#slc_presupuesto").html('<option value=""></option>');
            $("#slc_presupuesto").select2({placeholder: 'Seleccione una opción'});
        }
    });

    $("#slc_presupuesto").change(function (){
        var presupuesto = $(this).val();
        if ( presupuesto != "" ) {
            $.ajax({
                dataType: 'text',
                type: 'post',
                data: {presupuesto: presupuesto},
                url: urlj + 'utm/cuentas/get_actividades_generalesxpresupusto',
                success: function (data) {
                    $("#slc_actividad_general").html("");
                    $("#slc_actividad_general").html(data);
                    $("#slc_actividad_general").select2({placeholder: 'Seleccione una opción'});
                }
            });
        } else {
            $("#slc_actividad_general").html('<option value=""></option>');
            $("#slc_actividad_general").select2({placeholder: 'Seleccione una opción'});
        }
    });

    $("#slc_actividad_general").change(function (){
        var general     = $(this).val();
        var presupuesto = $("#slc_presupuesto").val();
        if ( general != "" ) {
            $.ajax({
                dataType: 'text',
                type: 'post',
                data: {general: general,presupuesto:presupuesto},
                url: urlj + 'utm/cuentas/get_actividades_especificas_x_actividad_general',
                success: function (data) {
                    $("#slc_actividad_espeficifica").html("");
                    $("#slc_actividad_espeficifica").html(data);
                    $("#slc_actividad_espeficifica").select2({placeholder: 'Seleccione una opción'});
                }
            });
        } 
    });

    $('#guardar_detallex23').on('click',function(event){
        event.preventDefault();
        var debe  = (!isNaN(parseFloat($('#total_debe').val())))?parseFloat($('#total_debe').val()):0;
        var haber = (!isNaN(parseFloat($('#total_haber').val())))?parseFloat($('#total_haber').val()):0;

        if (debe > 0 && haber >0){
            if (debe != haber) {
                crear_alerta('error','Error al Procesar','Revisa los datos ingresados, Debe y Haber no coniciden');
            }else{
                 $.fancybox.close();
            }
        }else{
            crear_alerta('info','Error al procesar','Revisa los datos ingresados');
        }
        return false;
    });
    
});