jQuery(document).ready(function($) {
	//$("input[name^='fecha']").datepicker({dateFormat: 'dd-mm-yy',changeMonth: true, changeYear: true});
	$("input[name^='fecha']").mask("99-99-9999");
	$("input[name^='fecha']").attr('placeholder',"dd-mm-yyyy");
	$("input[name^='fecha']").removeClass('hasDatepicker').datepicker({
            showButtonPanel: true,
            changeMonth: true,
            changeYear: true,
            dateFormat: 'dd-mm-yy',
            monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
            dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
            nextText: "Siguiente",
            prevText: "Anterior",
            //minDate: 0
        });

	$("#fecha_ini, #fecha_fin").change(function(event){
		jQuery.validator.addMethod("fecha_ini_fin", function(value, element, params) {
        ini = $(params[0]).val();
        fin = $(params[1]).val();
            return this.optional(element) || ( ini <= fin );
       
        }, jQuery.validator.format("Verifique las fechas del periodo."));

    jQuery.validator.addMethod("fecha", function(value, element) {
            // dd/mm/yyyy
            var re = /^\d{1,2}\-\d{1,2}\-\d{4}$/;
            // valid if optional and empty OR if it passes the regex test
            return (this.optional(element) && value=="") || re.test(value);
        }, jQuery.validator.format("Verifique las fechas del periodo.")
        );
	});

	$(".eliminar").click(function(event){
		event.preventDefault();
		var url= $(this).attr("href");
		alerta_confirm(url,'Alerta de confirmación','¿Seguro que quieres borrar este registro?');
	});
	  
	$('#frm_mantto').validate({
	      ignore: null, ignore: 'input[type="hidden"]',
	       rules: {
	       	fecha_ini:{required:true, fecha:true},
            fecha_fin:{required:true, fecha_ini_fin: ["input[name='fecha_ini']", "input[name='fecha_fin']"]},
	       } ,
	       errorPlacement: function (error, element) {
	        if($(element).is("select")){ $(element).next().append(error); }
	        else { 
	         error.insertAfter(element);
	        }
	       }, 
	       submitHandler: function(form){
	          console.log( $(form).serialize() );
	           wait.start();
	      $("#contenedor_consulta").hide("slide", { 
	       direction: 'right'
	     }, 400, function() { //despues de ocultar div enviar el ajax
	     	//id_motorista=$("#id_motorista").val();
	       $.ajax({
	         type: 'post',
	         url:  window.gSateliteWhite.baseUrl('transporte/procesos/solicitud_mantenimiento/1'),
	         data: $("#frm_mantto").serialize(),
	         success: function (data) {  
	           $("#contenedor_consulta_tbody").html(data);
	                 wait.close();
	                //$("#consultar_submit").removeAttr('disabled');
	                //$(".accion_botones").show('slow');
	                $("#contenedor_consulta").show("slide", {
	                 direction: 'left'
	               }, 500);
	                //$("#tabla_").dataTable();
	              }
	            });
	     	});
	       } 
	   }); 
});

