jQuery(document).ready(function($) {
	//$("input[name^='fecha']").datepicker({dateFormat: 'dd-mm-yy',changeMonth: true, changeYear: true});
	//$("input[name^='fecha']").mask("99-99-9999");
	//$("input[name^='fecha']").attr('placeholder',"dd-mm-yyyy");
	$("input[name^='fecha']").removeClass('hasDatepicker').datepicker({
            showButtonPanel: true,
            changeMonth: true,
            changeYear: true,
            dateFormat: 'dd-mm-yy',
            monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
            dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
            nextText: "Siguiente",
            prevText: "Anterior",
            //minDate: 0
        });

	$("#nuevo_horario").click(function(event) {
		event.preventDefault();
		url_accion = $(this).attr('url');
		   $.ajax({
		        url: url_accion,
		        type: 'post',
		        success: function(data) {
		      	$.fancybox(data);
		        }
		      });		

	});

	$("#fecha_ini, #fecha_fin").change(function(event){
		jQuery.validator.addMethod("fecha_ini_fin", function(value, element, params) {
        ini = $(params[0]).val();
        fin = $(params[1]).val();
            return this.optional(element) || ( ini <= fin );
       
        }, jQuery.validator.format("Verifique las fechas del periodo."));

    jQuery.validator.addMethod("fecha", function(value, element) {
            // dd/mm/yyyy
            var re = /^\d{1,2}\-\d{1,2}\-\d{4}$/;
            // valid if optional and empty OR if it passes the regex test
            return (this.optional(element) && value=="") || re.test(value);
        }, jQuery.validator.format("Verifique las fechas del periodo.")
        );
	});


	$('#form_detalle_consulta').validate({
	      ignore: null, ignore: 'input[type="hidden"]',
	       rules: {
	       	fecha_ini:{required:true, fecha:true},
            fecha_fin:{required:true, fecha_ini_fin: ["input[name='fecha_ini']", "input[name='fecha_fin']"]},
	       },
	       errorPlacement: function (error, element) {
	        if($(element).is("select")){ $(element).next().append(error); }
	        else { 
	         error.insertAfter(element);
	        }
	       }, 
	       submitHandler: function(form){
	          console.log( $(form).serialize() );
	           wait.start();
	      $("#contenedor_consulta").hide("slide", { 
	       direction: 'right'
	     }, 400, function() { //despues de ocultar div enviar el ajax
	     	id_motorista=$("#id_motorista").val();
	       $.ajax({
	         type: 'post',
	         url:  window.gSateliteWhite.baseUrl('transporte/cruds/detalle_horario/'+id_motorista+'/1'),
	         data: $("#form_detalle_consulta").serialize(),
	         success: function (data) {  
	           $("#contenedor_consulta_tbody").html(data);
	                 wait.close();
	                //$("#consultar_submit").removeAttr('disabled');
	                //$(".accion_botones").show('slow');
	                $("#contenedor_consulta").show("slide", {
	                 direction: 'left'
	               }, 500);
	                //$("#tabla_").dataTable();
	              }
	            });
	     });

	       } 
	   }); 

	$("#agregar_detalle").live('click',function(event) {
	 url_accion = $(this).attr('url');
	    $.ajax({
	         url: url_accion,
	         type: 'post',
	         data: $("#form_detalle_h").serialize(),
	         success: function(data) {
	         if(data >=1){
	             crear_alerta('success','Éxito','Registro agregado, filtrar y consultar para ver el detalle');
	             $("#form_detalle_h").trigger("reset");
	             $.fancybox.close();
	         }
	         else {
	           crear_alerta('error','Error en guardar',data);
	         }
	         }
	       });   

	});

	$(".editar_horario").live('click',function(event) {
		event.preventDefault();
		url_accion = $(this).attr('href');
		   $.ajax({
		        url: url_accion,
		        type: 'post',
		        success: function(data) {
		      	$.fancybox(data);
		        }
		      });		

	});

	$(".eliminar_horario").live('click',function(event) {
		event.preventDefault();
		url_accion = $(this).attr('href');
		var datos = [url_accion, $(this).parent().parent()];
		alerta_confirm_ajax(eliminar_detalle,datos,'Eliminar registro','¿Realmente desea eliminar el registro seleccionado?');
	});

	$("#actualizar_detalle").live('click',function(event) {
	 url_accion = $(this).attr('url');
	    $.ajax({
	         url: url_accion,
	         type: 'post',
	         data: $("#form_detalle_h").serialize(),
	         success: function(data) {
	         if(data >=1){
	             crear_alerta('success','Éxito','Registro actualizado, filtrar y consultar para ver el cambio');
	            // $("#consultar_detalle").trigger('click');
	            $.fancybox.close();
	         }
	         else {
	           crear_alerta('error','Error en actualizar',data);
	         }
	         }
	       });   

	});

});

function eliminar_detalle(array_datos) {
 url_accion=array_datos[0];
 remover=array_datos[1];
 $.ajax({
      url: url_accion,
      type: 'post',
      success: function(data) {
    	if(data>=1) {
    		crear_alerta('success','Eliminado','Registro eliminado con éxito');
    		$(remover).remove();
    	}
    	else {
    		crear_alerta('error','Error','El registro no pudo ser eliminado');
    	}
      }
    });		

}